// ----------------------------------------------------------------------
// Javascript form validation routines.
// ----------------------------------------------------------------------

var nbsp = 160;		// non-breaking space char
var emptyString = /^\s*$/ ;
var global_valfield;	// retain valfield for timer thread

// --------------------------------------------
//                  trim
// Trim leading/trailing whitespace off string
// --------------------------------------------

function trim(str)
{
  return str.replace(/^\s+|\s+$/g, '');
}


// --------------------------------------------
//                  setfocus
// Delayed focus setting to get around IE bug
// --------------------------------------------

function setFocusDelayed()
{
  global_valfield.focus();
}

function setfocus(valfield)
{
  // save valfield in global variable so value retained when routine exits
  global_valfield = valfield;
  //setTimeout( 'setFocusDelayed()', 100 );
}



function displayError(fld,message)
{
  // setting an empty string can give problems if later set to a 
  // non-empty string, so ensure a space present. (For Mozilla and Opera one could 
  // simply use a space, but IE demands something more, like a non-breaking space.)
  var dispmessage;
  if (emptyString.test(message)) 
    dispmessage = String.fromCharCode(nbsp);    
  else  
    dispmessage = message;

  var elem = document.getElementById(fld);
  elem.firstChild.nodeValue = dispmessage;  
}


function validateStringNotEmpty(valfield,infofield)
{
	var tfld = trim(valfield.value);
	if (tfld.length > 0)
	{
		displayError(infofield, "");
		return true;
	}
	else
	{
		displayError(infofield, "Field is required.");
    	setfocus(valfield);
    	return false;
	}
}

function validateActivationStringNotEmpty(valfield,infofield)
{
	if(document.forms.adding.activationType.value=="none")
	{
		displayError(infofield, "");
		return true;
	}
	return validateStringNotEmpty(valfield,infofield);
}

function validatePasswordStringNotEmpty(valfield,infofield)
{
	if(document.forms.adding.activationType.value=="baanlogin_ssl")
	{
		// No password required for baanlogin_ssl
		displayError(infofield, "");
		return true;
	}
	return validateActivationStringNotEmpty(valfield,infofield);
}

function validateActivationNumericNotEmpty(valfield,infofield)
{
	if(document.forms.adding.activationType.value=="none")
	{
		displayError(infofield, "");
		return true;
	}
	return validateNumericNotEmpty(valfield,infofield);
}

function validateActivationNumeric(valfield,infofield)
{
	if(document.forms.adding.activationType.value=="none")
	{
		displayError(infofield, "");
		return true;
	}
	return validateNumeric(valfield,infofield);
}

function validateNumericNotEmpty(valfield, infofield)
{
	var tfld = trim(valfield.value);
	
	if (tfld.length > 0)
	{
		var numberRE = /^[0-9]*$/	// numeric check, must start with number ^, number can repeat n times with * until end of String $  
 		if (!numberRE.test(valfield.value)) 
 		{
    		displayError (infofield, "Field must be numeric (non-negative integer).");
    		setfocus(valfield);
    		return false;
    	}
		displayError(infofield, "");
		return true;
	}
	else
	{
		displayError(infofield, "Field is required.");
    	setfocus(valfield);
    	return false;
	}
}

function validateIdentifier(valfield, infofield)
{
	var tfld = trim(valfield.value);
	
	if (tfld.length > 0)
	{
		var idRE = /^[0-9A-Za-z_]*$/	// identifier check
 		if (!idRE.test(valfield.value)) 
 		{
    		displayError (infofield, "Identifier contains invalid characters.");
    		setfocus(valfield);
    		return false;
    	}
		displayError(infofield, "");
		return true;
	}
	displayError(infofield, "Field is required.");
   	setfocus(valfield);
   	return false;
}

function validateNumeric(valfield, infofield)
{
	var tfld = trim(valfield.value);
	
	if (tfld.length > 0)
	{
		var numberRE = /^[0-9]*$/	// numeric check, must start with number ^, number can repeat n times with * untill end of String $  
 		if (!numberRE.test(valfield.value)) 
 		{
    		displayError (infofield, "Field must be numeric.");
    		setfocus(valfield);
    		return false;
    	}
	}
	displayError(infofield, "");
	return true;
}

function validateNumericRange(valfield, infofield, minValue, maxValue)
{
	var tfld = trim(valfield.value);
	
	if (tfld.length > 0)
	{
		var numberRE = /^[0-9]*$/	// numeric check, must start with number ^, number can repeat n times with * until end of String $  
		if (!numberRE.test(valfield.value)) 
		{
			displayError (infofield, "Field must be numeric.");
			setfocus(valfield);
			return false;
		}
		if (valfield.value < minValue || valfield.value > maxValue)
		{
			displayError (infofield, "Value out of range [" + minValue + "-" + maxValue + "].");
			setfocus(valfield);
			return false;
		}
	}
	displayError(infofield, "");
	return true;
}

function validateActivationNumericRange(valfield, infofield, minValue, maxValue)
{
	if(document.forms.adding.activationType.value=="none")
	{
		displayError(infofield, "");
		return true;
	}
	return validateNumericRange(valfield, infofield, minValue, maxValue);
}

function validateSignedNumeric(valfield, infofield)
{
	// 'valfield' should contain a positive or negative numerical value
	var tfld = trim(valfield.value);
	
	if (tfld.length > 0)
	{
		var numberRE = /^-?[0-9]+$/	// numeric check, optional minus sign followed by one or more digits
 		if (!numberRE.test(valfield.value)) 
 		{
    		displayError (infofield, "Field must be numeric.");
    		setfocus(valfield);
    		return false;
    	}
	}
	displayError(infofield, "");
	return true;
}

function validateActivationSignedNumeric(valfield, infofield)
{
	// 'valfield' should contain a positive or negative numerical value
	// (only if activation is other than 'none')
	if(document.forms.adding.activationType.value=="none")
	{
		displayError(infofield, "");
		return true;
	}
	return validateSignedNumeric(valfield, infofield);
}
