//tooltip.js 
var tool_layer = document.createElement("div");
document.body.appendChild(tool_layer);
tool_layer.style.position = "absolute";
tool_layer.style.visibility = "hidden";
tool_layer.style.backgroundColor = "#FFFFE1";
tool_layer.style.border = "1px solid #000000"; 

var tooltip =
{ 
	displayed:false, 
	on:function(message)
	{ 
		tool_layer.innerHTML = message; 
		this.displayed = true; 
		tool_layer.style.visibility = "visible"; 
	}, 
	off:function()
	{ 
		this.displayed = false; 
		tool_layer.style.visibility = "hidden"; 
	}, 
	move:function(evt)
	{ 
		var dist = 15; 
		if (this.displayed)
		{ 
			if (document.addEventListener)
			{ 
				tool_layer.style.left = ((evt.clientX + window.pageXOffset)+dist) + 'px'; 
				tool_layer.style.top = ((evt.clientY + window.pageYOffset)+dist) + 'px'; 
			} 
			else if (window.opera)
			{ 
				tool_layer.style.left = ((evt.clientX + window.pageXOffset)+dist) + 'px'; 
				tool_layer.style.top = ((evt.clientY + window.pageYOffset)+dist) + 'px'; 
			} 
			else if (window.event)
			{ 
				if (document.compatMode && document.compatMode!= 'BackCompat')
				{ 
					tool_layer.style.left = ((event.clientX + document.documentElement.scrollLeft)+dist) + 'px'; 
					tool_layer.style.top = ((event.clientY + document.documentElement.scrollTop)+dist) + 'px'; 
				} 
				else
				{ 
					tool_layer.style.left = ((event.clientX + document.body.scrollLeft)+dist) + 'px'; 
					tool_layer.style.top = ((event.clientY + document.body.scrollTop)+dist) + 'px'; 
				} 
			} 
			else if (document.layers)
			{ 
				tool_layer.left = evt.pageX+dist; 
				tool_layer.top = evt.pageY+dist; 
			} 
		} 
	} 
} 

function addEvents(elem)
{ 
	elem.onmouseover = tooltip.on; 
	elem.onmouseout = tooltip.off; 
	elem.onmousemove = tooltip.move; 
} 
