<%@page import="com.infor.erpln.c4ws.util.LNEnvironment"%>
<%@ page language="java" contentType="text/html; charset=ISO-8859-1"
    pageEncoding="ISO-8859-1"%>
<%@ page import="com.infor.erpln.soap.Messages" %>
<%@ page import="java.util.Hashtable" %>
<%@ page import="com.infor.erpln.soap.servlet.ErpServerManager" %>
<%@ include file="esapi_utils.jspf" %>
<%
    String orgPage = request.getParameter("org");
	if (orgPage == null)
	{
		orgPage = "index.jsp";
	}

	String errorString = ""; // errorString
	String action = request.getParameter("action"); // action Modify / Add
	String name = request.getParameter("name"); //name
	String envname = request.getParameter("envname"); // LN environment name
	try
	{
		ErpServerManager man = new ErpServerManager(application);
		if (envname == null || envname.isEmpty())
		{
		    envname = man.getEnvironmentIDForCP(name);
		}
		LNEnvironment env = new LNEnvironment(envname);
		
		String hostName = request.getParameter("hostName"); //hostname
		String port = request.getParameter("port"); //port
		String type = request.getParameter("activationType"); // check on activationType
		
		
		// Checks of the InputFields
		if (name == null || name.trim().length() == 0) // ERP Server name check
		{
		    errorString = Messages.get("config_error_name_missing");
			throw new IllegalArgumentException(); // skip rest of the tests
		}
		if (!name.matches("^[0-9A-Za-z_]*$"))
		{
		    errorString = Messages.get("config_error_invalid_identifier");
			throw new IllegalArgumentException();
		}
		LNEnvironment temp = man.getEnvironmentForCP(name);
		if (temp == null && action.equals(Messages.get("button_modify")))
		{
		    errorString = Messages.get("config_error_name_not_exists");
			throw new IllegalArgumentException();
		}
		if (temp != null && action.equals(Messages.get("button_add")))
		{
		    errorString = Messages.get("config_error_name_exists");
			throw new IllegalArgumentException();
		}
		
		if (hostName == null || hostName.trim().length() == 0) // Host name check
		{
		    errorString = Messages.get("config_error_hostname_missing");
			throw new IllegalArgumentException();
		}
		env.setHost(hostName);
		
		if (port == null || port.trim().length() == 0) // Port number check
		{
		    errorString = Messages.get("config_error_port_missing");
			throw new IllegalArgumentException();
		}
		try
		{
		    env.setPort(Integer.parseInt(port));
		}
		catch (NumberFormatException e)
		{
		    errorString = Messages.get("config_error_port_numeric");
			throw new IllegalArgumentException();
		}

		if (!(type.equals("rexec") || type.equals("baanlogin") || type.equals("baanlogin_ssl") || type.equals("none")))
		{
		    errorString = Messages.get("config_error_activation_type");
			throw new IllegalArgumentException();
		}
		env.setActivation(type);

		if (!type.equals("none")) // check on activationType
		{	
			String user = request.getParameter("activationUser"); // user
			if (user == null || user.trim().length() == 0) // User check
			{
			    errorString = Messages.get("config_error_user_missing");
				throw new IllegalArgumentException();
			}
			env.setUser(user);
			
			if (!type.equals("baanlogin_ssl"))
			{
				String password = request.getParameter("activationPassword"); //password
				if (password == null || password.trim().length() == 0) // password check
				{
				    errorString = Messages.get("config_error_password_missing");
					throw new IllegalArgumentException();
				}
				env.setCleartextPassword(password);
			}
			else
			{
			    // Only for baanlogin_ssl, set "useUPN" option
			    String useUpn = request.getParameter("useUpn"); // use UPN
				boolean upn = useUpn != null && useUpn.trim().length() > 0;
			    env.setUseUpn(upn);
			}
			
			String bse = request.getParameter("activationBse"); // bse
			if (bse == null || bse.trim().length() == 0) // bse check
			{
			    errorString = Messages.get("config_error_bse_missing");
				throw new IllegalArgumentException();
			}
			env.setBSE(bse);
			
			String bshell = request.getParameter("activationBshell"); // bshell
			if (bshell == null || bshell.trim().length() == 0) // bshell check
			{
			    errorString = Messages.get("config_error_bshell_missing");
				throw new IllegalArgumentException();
			}
			env.setBshell(bshell);
			
			String company = request.getParameter("activationCompany"); // company
			if (company != null && company.trim().length() != 0) // company check
			{
				int intCompany = 0;			
				try
				{
					 intCompany = Integer.parseInt(company);
				}
				catch (NumberFormatException e)
				{
				    errorString = Messages.get("config_error_company_numeric");
					throw new IllegalArgumentException();
				}
				if (intCompany < 0 || intCompany > 9999)
				{
				    errorString = Messages.get("config_error_company_range");
					throw new IllegalArgumentException();
				}
				env.setCompany(intCompany);
			}
			else
			{
				env.setCompany(-1);// when company is empty or null, then company is -1
			}
				
			String options = request.getParameter("activationDaemonOptions"); // DaemonOptions
			if (options == null || options.trim().length() == 0)// DaemonOptions check
			{
				env.setTraceBackend(false);
			}
			else
			{
				env.setTraceBackend(true);
			}
			
			String anonymousAllowed = request.getParameter("anonymousAllowed"); // allow anonymous requests
			boolean allowed = anonymousAllowed != null && anonymousAllowed.trim().length() > 0;
		    env.setAnonymousAllowed(allowed);
		
		    String environment = request.getParameter("activationEnvironment"); // Environment
		    if (environment == null || environment.trim().length() == 0)
		    {
		        env.setCommand("");
		    }
		    else
		    {
		        env.setCommand(environment);
		    }
		
		    String maxConnections = request.getParameter("maxConnections"); //maxConnections
		    if (maxConnections != null && maxConnections.trim().length() != 0) // maxConnections check
		    {
		        int iMaxConnections = 0;
		        try
		        {
		            iMaxConnections = Integer.parseInt(maxConnections);
		            if (iMaxConnections < 0)
		            {
		    		    errorString = Messages.get("config_error_maxconnections_range");
		                throw new IllegalArgumentException();
		            }
		        }
		        catch (NumberFormatException e)
		        {
				    errorString = Messages.get("config_error_maxconnections_numeric");
		            throw new IllegalArgumentException();
		        }
		        env.setMaxConnections(iMaxConnections);
		    } else
		    {
			    errorString = Messages.get("config_error_maxconnections_missing");
		        throw new IllegalArgumentException();
		    }
		
		    String maxReferences = request.getParameter("maxReferences"); //maxReferences
		    if (maxReferences != null && maxReferences.trim().length() != 0) // maxReferences check
		    {
		        int iMaxReferences = 1;
		        try
		        {
		            iMaxReferences = Integer.parseInt(maxReferences);
		            if (iMaxReferences < 0)
		            {
		    		    errorString = Messages.get("config_error_maxreferences_range");
		                throw new IllegalArgumentException();
		            }
		        }
		        catch (NumberFormatException e)
		        {
				    errorString = Messages.get("config_error_maxreferences_numeric");
		            throw new IllegalArgumentException();
		        }
		        env.setMaxReferences(iMaxReferences);
		    } else
		    {
			    errorString = Messages.get("config_error_maxreferences_missing");
		        throw new IllegalArgumentException();
		    }
		
		    String maxThreads = request.getParameter("maxThreads"); //maxThreads
		    if (maxThreads != null && maxThreads.trim().length() != 0) // maxThreads check
		    {
		        int iMaxThreads = 0;
		        try
		        {
		            iMaxThreads = Integer.parseInt(maxThreads);
		        }
		        catch (NumberFormatException e)
		        {
				    errorString = Messages.get("config_error_maxThreads_numeric");
		            throw new IllegalArgumentException();
		        }
		        env.setMaxThreads(iMaxThreads);
		    }
		    else
		    {
			    errorString = Messages.get("config_error_maxThreads_missing");
		        throw new IllegalArgumentException();
		    }
		
		    String timerDelay = request.getParameter("timerDelay"); //timerDelay
		    if (timerDelay != null && timerDelay.trim().length() != 0) // timerDelay check
		    {
		        int iTimerDelay = 0;
		        try
		        {
		            iTimerDelay = Integer.parseInt(timerDelay);
		            if (iTimerDelay < 0 || iTimerDelay > 2147483)
		            {
		    		    errorString = Messages.get("config_error_keepalive_range");
		                throw new IllegalArgumentException();
		            }
		        }
		        catch (NumberFormatException e)
		        {
				    errorString = Messages.get("config_error_keepalive_numeric");
		            throw new IllegalArgumentException();
		        }
		        env.setKeepAlive(iTimerDelay);
		    }
		    else
		    {
			    errorString = Messages.get("config_error_keepalive_missing");
		        throw new IllegalArgumentException();
		    }
        }

        //saving of theConnectionPoint
        if (action.equals(Messages.get("button_modify"))) // check on Action
        {
    		man.modifyEnvironment(env);
        }
        else if (action.equals(Messages.get("button_add")))
        {
		    man.addEnvironment(name, env);

		    // set a preferred connectionpoint if there is only one
		    String[] points = man.listConnectionPointNames();
   			if (points.length == 1)
   			{
   				session.setAttribute("lastConnectionPoint", getValidatedConnectionpoint(name));
   			}
        }
        else
        {
		    errorString = Messages.get("config_error_invalid_action", action);
		    throw new IllegalArgumentException();
        }
    }
	catch (Exception e)
    {
        // Ignore this exception. (Cause for this exception is available in 'errorString')
    }
%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1" />
	<title><%=Messages.get("productname")%> - <%=Messages.get("save_title")%></title>
	<meta http-equiv="expires" content="0"/>
	<meta http-equiv="pragma" content="no-cache"/>
	<link href="<%=request.getContextPath()%>/css/wwwstyle.css" type="text/css" rel="stylesheet" />
</head>
<body>
		<table>
		<tbody>
			<tr class="header"><td class="headertext">&nbsp;</td></tr>
			<tr class="logobox">
				<td class="logocell">
					<a href="http://www.infor.com/">
						<img class="logo"
						 src="<%=request.getContextPath()%>/images/infor_logo.gif"/>
					</a>
				</td>
			</tr>
			<tr class="topnavbox">
				<td class="topnavcell">
					<%=Messages.get("productname")%>
				</td>
			</tr>
			<tr>
				<td class="detail">
					<div class="detailname">
						<%=Messages.get("save_title")%>
					</div>
					<p>
					<%
						if (errorString.length() == 0)
						{
							out.println(Messages.get("config_save_success", new Object[] {encodeHTML(action), encodeHTML(name)}));
						}
						else
						{
							out.println("<font color='#FF0000'>" + encodeHTML(Messages.get("config_save_error", errorString)) + "</font>");
						}
					%>
					</p>
				</td>
			</tr>
			<tr>
				<td class="detail">
				<%
				if (errorString.length() == 0)
				{
				%>
					<input type="button" value="<%=Messages.get("button_continue")%>" onclick="location.href='cp.jsp?org=<%=encodeURL(orgPage)%>'"/>
				<%
				}
				else
				{
					Hashtable params = new Hashtable();
					params.putAll(request.getParameterMap());
					session.setAttribute("params", params);
				%>
					<input type="button" value="<%=Messages.get("button_back")%>" onclick="location.href='add_cp.jsp?org=<%=encodeURL(orgPage)%>&amp;envname=<%=encodeURL(envname)%>'"/>
				<%
				}
				%>
				</td>
			</tr>
			<tr class="footerbox">
				<td class="footertext">
					<%=Messages.get("copyright")%>
				</td>
			</tr>
		</tbody>
	</table>
</body>
</html>