<%@ page language="java" contentType="text/html; charset=ISO-8859-1"
    pageEncoding="ISO-8859-1"%>
<%@ page import="com.infor.erpln.soap.Messages" %>
<%@ page import="com.infor.erpln.soap.servlet.ErpServerManager" %>
<%@ page import="com.infor.erpln.soap.boi.BoiExplorer" %>
<%@ page import="java.util.List" %>
<%@ include file="esapi_utils.jspf" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1" />
	<title><%=Messages.get("productname")%> - <%=Messages.get("deploy_boi_title")%></title>
	<link href="<%=request.getContextPath()%>/css/wwwstyle.css" type="text/css" rel="stylesheet" />
	<script language="javascript" src="help.js"></script>
	<script type="text/javascript">
		onload = function()
		{
			s = document.getElementById("servers");
			s.onchange = function()
			{
				cp = this.options[this.selectedIndex].value;
				if (cp.length > 0)
				{
					setWaitCursor();
					document.getElementById("ButtonConfigure").disabled = true;
					/* reload the page for the selected connection point */
					document.location.replace("list_boi.jsp?cp="+cp);
				}
			}
		}
		
		function addOption(anchor)
		{
			if (document.getElementById("ignoreMD").checked)
			{
				anchor.href +=  "&ignoreMD=true";
			}
			return true;
		}
	</script>
</head>
<body>
<%
	String connectionPoint = request.getParameter("cp");
	if (connectionPoint != null)
	{
		// remember last selection in this session
		session.setAttribute("lastConnectionPoint", getValidatedConnectionpoint(connectionPoint));
	}
	else
	{
		// get last selection from this session
		String lastSelectedConnectionPoint = (String) session.getAttribute("lastConnectionPoint");
		if (lastSelectedConnectionPoint != null)
		{
			// default back to last selection
			connectionPoint = lastSelectedConnectionPoint;
		}
	}
%>
	<table>
		<tbody>
			<tr class="header"><td class="headertext"><a href="javascript:help('help/helplist_boi.jsp')"><%=Messages.get("button_help")%></a></td></tr>
			<tr class="logobox">
				<td class="logocell">
					<a href="http://www.infor.com/">
						<img class="logo"
						 src="<%=request.getContextPath()%>/images/infor_logo.gif"/>
					</a>
				</td>
			</tr>
			<tr class="topnavbox">
				<td class="topnavcell">
					<%=Messages.get("productname")%>
				</td>
			</tr>
			<tr>
				<td class="detail">
					<div class="detailname">
						<%=Messages.get("deploy_boi_title")%>
					</div>
					<form>
						<%=Messages.get("config_label_erp_server")%>
						<select id="servers">
						<%
							int nrPoints = 0;
							String selected = "";
							if (connectionPoint == null)
							{
								selected = "selected";
							}
							out.println("<option " + selected + " value=''>" + Messages.get("config_select_server") + "</option>");
							
							ErpServerManager man = new ErpServerManager(application);
							String[] points = man.listConnectionPointNames();
							nrPoints = points.length;
							for (int i = 0; i < points.length; i++)
							{
								String point = points[i];
								if (connectionPoint != null && connectionPoint.equals(point))
								{
									selected = "selected";
								}
								else
								{
									selected = "";
								}
								out.println("<option " + selected + " value='" + point + "'>" + point + "</option>");
							}
						%>
						</select>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
						<input type="button" id="ButtonConfigure" value="<%=Messages.get("button_configure")%>" onclick="location.href='cp.jsp?org=list_boi.jsp'"/>
					</form>
				</td>
			</tr>
			<tr>
				<td class="detail">
					<div class="detailname"><%=Messages.get("available_boi_title")%></div>
					<%
						try
						{
							List<BoiExplorer.Boi> bois = BoiExplorer.getInstance().getBois();
							if (bois.size() > 0)
							{
								if (connectionPoint == null)
								{
									connectionPoint = "";
								}
					%>
					<form method="post" action="<%=request.getContextPath()%>/deploy_boi.jsp?cp=<%=encodeURL(connectionPoint)%>">
					<table class="list">
						<tr>
							<td>&nbsp;</td>
							<td><%=Messages.get("config_header_boi_name")%></td>
							<td><%=Messages.get("config_header_manager_class")%></td>
							<td>&nbsp;</td>
						</tr>
						<%
								for (BoiExplorer.Boi boi : bois)
								{
									String boiClass = boi.getClassName();
									String boiName = boi.getName();
						%>
						<tr class="listitem">
							<td width="16"><input type="checkbox" name="<%=boiName%>;<%=boiClass%>"/></td>
							<td><%=boiName%></td>
							<td><%=boiClass%></td>
						<%
									if (connectionPoint.equals(""))
									{
						%>
								<td width="16">&nbsp;</td>
						<%
									}
									else
									{
						%>
								<td width="16"><a href="deploy_boi.jsp?name=<%=boiName%>&class=<%=boiClass%>&cp=<%=encodeURL(connectionPoint)%>" onclick="addOption(this);setWaitCursor();">
								<img src="<%=request.getContextPath()%>/images/deploy.gif" alt="<%=Messages.get("button_deploy")%>"/></a></td>
						<%
									}
						%>
						</tr>
						<%
								}
								String disabled = "";
								if (connectionPoint.equals(""))
								{
									disabled = "disabled";
								}
						%>
					</table>
					<input type="submit" value="<%=Messages.get("button_deploy")%>" <%=disabled%> onclick="setWaitCursor();"/>
					&nbsp;
					<input type="checkbox" id="ignoreMD" name="ignoreMD" value="true"/>&nbsp;<%=Messages.get("config_ignore_metadata")%>
					</form>
					<%
							}
							else // domains.size() == 0
							{
					%>
					<p><%=Messages.get("config_no_available_bois")%></p>
					<%
							}
						}
						catch (Exception ex)
						{
							out.println("<p><font color='#FF0000'>" + Messages.get("config_error_available_boi"));
							out.println("(See log file for details.)</font></p>");
						}
					%>
				</td>
			</tr>
			<tr>
				<td class="detail">
					<input type="button" value="<%=Messages.get("button_back")%>" onclick="location.href='config.jsp'"/>
				</td>
			</tr>
			<tr class="footerbox">
				<td class="footertext">
					<%=Messages.get("copyright")%>
				</td>
			</tr>
		</tbody>
	</table>
</body>
</html>