<%@ page language="java" contentType="text/html; charset=ISO-8859-1"
    pageEncoding="ISO-8859-1"%>
<%@ page import="com.infor.erpln.soap.Messages" %>
<%@ page import="com.infor.erpln.soap.WSDLImporter" %>
<%@ page import="com.infor.erpln.soap.servlet.ErpServerManager" %>
<%@ include file="esapi_utils.jspf" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1" />
	<title><%=Messages.get("productname")%> - <%=Messages.get("import_title")%></title>
	<link href="<%=request.getContextPath()%>/css/wwwstyle.css" type="text/css" rel="stylesheet" />
	<script language="javascript" src="help.js"></script>
	<script type="text/javascript">
		onload = function()
		{
			s = document.getElementById("servers");
			s.onchange = function()
			{
				cp = this.options[this.selectedIndex].value;
				if (cp.length > 0)
				{
					setWaitCursor();
					document.getElementById("ButtonConfigure").disabled = true;
					/* reload the page for the selected connection point */
					document.location.replace("import.jsp?cp="+cp);
				}
			}
		}
	</script>
</head>
<body>
<%
	WSDLImporter wsdlImporter = new WSDLImporter(application);
	String connectionPoint = request.getParameter("cp");
	if (connectionPoint != null)
	{
		// remember last selection in this session
		session.setAttribute("lastConnectionPoint", getValidatedConnectionpoint(connectionPoint));
	}
	else
	{
		// get last selection from this session
		String lastSelectedConnectionPoint = (String) session.getAttribute("lastConnectionPoint");
		if (lastSelectedConnectionPoint != null)
		{
			// default back to last selection
			connectionPoint = lastSelectedConnectionPoint;
		}
	}
%>
	<table>
		<tbody>
			<tr class="header"><td class="headertext"><a href="javascript:help('help/helpimport.jsp')"><%=Messages.get("button_help")%></a></td></tr>
			<tr class="logobox">
				<td class="logocell">
					<a href="http://www.infor.com/">
						<img class="logo"
						 src="<%=request.getContextPath()%>/images/infor_logo.gif"/>
					</a>
				</td>
			</tr>
			<tr class="topnavbox">
				<td class="topnavcell">
					<%=Messages.get("productname")%>
				</td>
			</tr>
			<tr>
				<td class="detail">
					<div class="detailname">
						<%=Messages.get("deploy_bde_title")%>
					</div>
					<form>
						<%=Messages.get("config_label_erp_server")%>
						<select id="servers">
						<%
							int nrPoints = 0;
							String selected = "";
							if (connectionPoint == null)
							{
								selected = "selected";
							}
							out.println("<option " + selected + " value=''>" + Messages.get("config_select_server") + "</option>");
							
							ErpServerManager man = new ErpServerManager(application);
							String[] points = man.listConnectionPointNames();
							nrPoints = points.length;
							for (int i = 0; i < points.length; i++)
							{
								String point = points[i];
								if (connectionPoint != null && connectionPoint.equals(point))
								{
									selected = "selected";
								}
								else
								{
									selected = "";
								}
								out.println("<option " + selected + " value='" + point + "'>" + point + "</option>");
							}
						%>
						</select>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
						<input type="button" id="ButtonConfigure" value="<%=Messages.get("button_configure")%>" onclick="location.href='cp.jsp?org=import.jsp'"/>
					</form>
				</td>
			</tr>
			<tr>
				<td class="detail">
					<div class="detailname"><%=Messages.get("available_title")%></div>
					<%
						try
						{
							if (connectionPoint != null)
							{
								wsdlImporter.initialize(connectionPoint);
								String[] list = wsdlImporter.listWSDL();
								wsdlImporter.close();
								if (list.length > 0)
								{
					%>
					<form method="post" action="<%=request.getContextPath()%>/deploy.jsp?cp=<%=encodeURL(connectionPoint)%>">
					<table class="list">
						<%
									for (int i = 0; i < list.length; i++)
									{
						%>
						<tr class="listitem">
							<td width="16"><input type="checkbox" name="<%=list[i]%>"/></td>
							<td><%=list[i]%></td>
							<td width="16"><a href="deploy.jsp?name=<%=list[i]%>&cp=<%=encodeURL(connectionPoint)%>" onclick="setWaitCursor();">
								<img src="<%=request.getContextPath()%>/images/deploy.gif" alt="<%=Messages.get("button_deploy")%>"/></a></td>
						</tr>
						<%
									}
						%>
					</table>
					<input type="submit" value="<%=Messages.get("button_deploy")%>" onclick="setWaitCursor();"/>
					</form>
					<%
								}
								else // list.length == 0
								{
					%>
					<p><%=Messages.get("config_no_available_web_services")%></p>
					<%
								}
							}
							else // connectionPoint == null
							{
								if (nrPoints == 0)
								{
					%>
					<p><%=Messages.get("config_click_configure")%></p>
					<%
								}
								else
								{
					%>
					<p><%=Messages.get("config_select_server2")%></p>
					<%
								}
							}
						}
						catch (Exception ex)
						{
							out.println("<p><font color='#FF0000'>" + Messages.get("config_error_available"));
							out.println("(See log file for details.)</font></p>");
						}
					%>
				</td>
			</tr>
			<tr>
				<td class="detail">
					<input type="button" value="<%=Messages.get("button_back")%>" onclick="location.href='config.jsp'"/>
				</td>
			</tr>
			<tr class="footerbox">
				<td class="footertext">
					<%=Messages.get("copyright")%>
				</td>
			</tr>
		</tbody>
	</table>
</body>
</html>