<%@ page language="java" contentType="text/html; charset=ISO-8859-1"
    pageEncoding="ISO-8859-1"%>
<%@ page import="com.infor.erpln.soap.Messages" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
	<head>
		<title><%=Messages.get("productname")%> Help - <%=Messages.get("deploy_boi_title")%> page</title>
		<link rel="StyleSheet" href="../css/wwwstyle.css" type="text/css"/>
	</head>
	<body>
		<table>
			<tbody>
				<tr class="header"><td class="headertext">&nbsp;</td></tr>
				<tr class="logobox">
					<td class="logocell">
						<a href="http://www.infor.com/">
							<img class="logo"
							 src="../images/infor_logo.gif"/>
						</a>
					</td>
				</tr>
				<tr class="topnavbox">
					<td class="topnavcell">
						<%=Messages.get("productname")%> Help
					</td>
				</tr>
				<tr>
					<td class="detail">
						<div class="detailname">
							<%=Messages.get("deploy_boi_title")%> page
						</div>
						<p>The <%=Messages.get("deploy_boi_title")%> page allows you to generate WSDL 
							files from installed BOI proxies and deploy these in the Connector for Web Services.</p>
						<p>BOI proxies can be installed on the web server by copying the BOI jar files to
							the c4ws/WEB-INF/lib folder and restart the web server.</p>
						<p>On this page you can perform the following actions:</p>
						<ul>
						  <li>Select an ERP Server. Use the 
							drop-down listbox to select an ERP Server. If the listbox
							does not contain an ERP Server then click 
							<b>Configure</b> to <a href="helpcp.jsp">configure ERP 
							Servers</a>.</li>
						  <li>Deploy BOI Web Services: select one or more web services 
							from the list and click <b>Deploy</b>. Alternatively you can click the
							<img border="0" src="../images/deploy.gif" width="16" height="16"/> 
							icon to deploy that BOI web service.</li>
						  <li>To navigate back to the <a href="helpconfig.jsp">Deployed Web Services page</a>, click <b>Back</b>.
							</li>
						</ul>
						<p>The option "Ignore BOI Metadata" ignores the metadata from the BOI proxy regarding the
						"cardinality" of the attributes of the business object. This defines whether an attribute is
						"required" or "optional". By selecting this option, all attributes are considered to be optional.
						This has 2 consequences:</p>
						<ul>
						<li>When generating the WSDL file, all child elements within the business object are
						generated with "minOccurs=0". Client software generated from the WSDL file will not
						require any of the attributes to be present in the SOAP request.</li>
						<li>At run-time, when processing a SOAP request, the Connector for Web Services will add
						default values for <b>required</b> attributes that are not present in the SOAP request.
						By selecting the "Ignore Metadata" option, all attributes are optional, so no default values
						will be sent to the ERP Server.</li>
						</ul>
						<p>This option is useful if the BOI metadata incorrectly specifies optional attributes as "required".
						Client software that has been generated based on the WSDL for such a BOI, will want to send data
						for those attributes, even though it is not necessary. After correcting the client software,
						and not sending data for these attributes, the Connector for Web Services will still add default
						values for the "missing fields" that are (incorrectly) assumed to be required.<br />
						Selecting the "Ignore Metadata" option when deploying the BOI will alter this situation:
						the Connector for Web Services will not add any default values when passing the request to the
						ERP Server. The generated client software will no longer require any attributes to be present
						in the SOAP request. The developer of the software will have to take care that the "really required"
						attributes will be included in the request.
						</p>
					</td>
				</tr>
				<tr class="footerbox">
					<td class="footertext">
						<%=Messages.get("copyright")%>
					</td>
				</tr>              
			</tbody>
		</table>
	</body>
</html>