<%@ page language="java" contentType="text/html; charset=ISO-8859-1"
    pageEncoding="ISO-8859-1"%>
<%@ page import="com.infor.erpln.soap.Messages" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
	<head>
		<title><%=Messages.get("productname")%> Help - Connection pooling page</title>
		<link rel="StyleSheet" href="../css/wwwstyle.css" type="text/css"/>
		<script language="javascript" src="../help.js"></script>
	</head>
	<body>
		<table>
			<tbody>
				<tr class="header"><td class="headertext">&nbsp;</td></tr>
				<tr class="logobox">
					<td class="logocell">
						<a href="http://www.infor.com/">
							<img class="logo"
							 src="../images/infor_logo.gif"/>
						</a>
					</td>
				</tr>
				<tr class="topnavbox">
					<td class="topnavcell">
						<%=Messages.get("productname")%> Help
					</td>
				</tr>
				<tr>
					<td class="detail">
						<div class="detailname">
							Connection pooling 
						</div>
							<br />
						<p>This page contains some additional information about connection pooling.</p>
						<p>A connection represents a running Infor ERP instance, costing system resources, a license and so on.<br/>
						For the processing of SOAP messages these connections can be shared (pooling).
						With pooling enabled multiple SOAP requests can be processed using one connection.</p>
						<p>The following properties together determine the behavior of the connection pooling:</p>
						<ul>
						<li>Max connections</li>
						<li>Max references</li>
						<li>Max threads</li>
						<li>Keep alive time</li>
						</ul>
						<p>The picture shows an overview of a pooling setup with <i>'Max connections'</i> set to 3, <i>'Max references'</i> to 4.<br/>
						<img src="pooling_example.gif"/><br/>
						The connections are first filled to the max references, then a new connection will be created.
						When multiple connections are available a reference will be added to the connection with the least references.<br/>
						<img src="pooling_example1.gif"/><br/>
						When the maximum number of connections is reached no new connections will be created anymore. If in
						that case the maximum number of references is reached for all connections then the number of
						references can grow beyond the max references limit.<br/>
						<img src="pooling_example2.gif"/></p>
						<p><b>Some special cases:</b><br/>
						<b>Max connections = 0</b><br/>
						This means there is an unlimited number of connections available. Connection sharing is disabled in
						this case, each connection will have one reference. The value of <i>'Max references'</i> is not used.<br/>
						<img src="pooling_example3.gif"/><br/>
						<b>Max references = 1</b><br/>
						Connection sharing will happen after all connections, up to <i>'Max connections'</i>, have been created.<br/>
						<img src="pooling_example4.gif"/><br/>
						<b>Max references = 0</b><br/>
						This setting disables connection sharing. Connections are created up to the <i>'Max connections'</i> setting,
						then a new request will result in a connection error.<br/>
						<img src="pooling_example5.gif"/><br/>
						<b>Max references = 0</b> and <b>Max threads &gt; 0</b><br/>
						This setting disables connection sharing but allows request queueing. Connections are created up to the
						<i>'Max connections'</i> setting, and following requests are placed in a queue. Once a connection becomes available,
						this connection is assigned to the oldest request from the queue (which is then removed from the queue).
						If the queue is filled up to the <i>Max threads</i> setting, a new request will result in a connection error.<br/>
						<img src="pooling_example6.gif"/><br/>
						</p>
						<p><a href="#" onclick="history.back();">Back to previous Help page</a></p>
					</td>
				</tr>
				<tr class="footerbox">
					<td class="footertext">
						<%=Messages.get("copyright")%>
					</td>
				</tr>              
			</tbody>
		</table>
	</body>
</html>