<%@ page language="java" contentType="text/html; charset=ISO-8859-1"
    pageEncoding="ISO-8859-1"%>
<%@ page import="com.infor.erpln.soap.Messages" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
	<head>
		<title><%=Messages.get("productname")%> Help - Configure ERP Servers page</title>
		<link rel="StyleSheet" href="../css/wwwstyle.css" type="text/css"/>
		<script language="javascript" src="../help.js"></script>
	</head>
	<body>
		<table>
			<tbody>
				<tr class="header"><td class="headertext">&nbsp;</td></tr>
				<tr class="logobox">
					<td class="logocell">
						<a href="http://www.infor.com/">
							<img class="logo"
							 src="../images/infor_logo.gif"/>
						</a>
					</td>
				</tr>
				<tr class="topnavbox">
					<td class="topnavcell">
						<%=Messages.get("productname")%> Help
					</td>
				</tr>
				<tr>
					<td class="detail">
						<div class="detailname">
							Add / Modify a ERP Server page
						</div>
							<br />
						On this page the ERP Server details can be viewed and modified.
						<br /><br />
						<table class="list">
							<tr>
								<td class="tdleft"><b>Field</b></td>
								<td><b>Description</b></td>
							</tr>
							<tr class="listitem2">
								<td>ERP Server</td>
								<td>Identifier of the ERP Server, which must be unique.
								</td>
							</tr>
							<tr class="listitem2">
								<td>Host name</td>
								<td>Hostname contains the TCP/IP hostname to an ERP System</td>
							</tr>
							<tr class="listitem2">
								<td>Activation type</td>
								<td>This field contains the activation type for activating the ERP Application Server.
									This can be one of the following types:
									<ul>
										<li><i>rexec</i>: This activation type is based upon the rexec protocol.
											The rexec protocol transmits the username and password non encrypted over
											the network which makes it a not-so secure protocol.</li>
										<li><i>baanlogin</i>: This activation type is based upon the BaanLogin protocol,
											which is more secure than rexec because the username and password are sent
											encrypted over the network.</li>
										<li><i>baanlogin_ssl</i>: This activation type uses a "Secure Sockets Layer" to
											connect to the Application Server. All communication will be encrypted.
											A mutual trust relationship needs to exist between the C4WS server and
											the Application server.</li>
										<li><i>none</i>: No server side activation is done automatically. In stead the
											user should start a Server side Bshell and ottstpjcadaemon manually. This
											option is only used when backend-side debugging must be done.</li>
									</ul>
								</td>
							</tr>
							<tr class="listitem2">
								<td>Port</td>
								<td>Connection port contains the TCP/IP port to an ERP Server<br /></td>
							</tr>
						</table>
						<br /><br />
						The following fields must be set when <b>activation</b> is required.
						<br /><br />
						<table class="list">
							<tr>
								<td class="tdleft"><b>Field</b></td>
								<td><b>Description</b></td>
							</tr>
							<tr class="listitem2">
								<td>User</td>
								<td>This field contains the backend OS username which is used for authentication on the
									ERP Application server.<br /><br />
									<i>In case the Activation type is "none", this field is made read-only and its value is not used.</i></td>
							</tr>
							<tr class="listitem2">
								<td>Password</td>
								<td>This field contains the password which must be used for authentication with the
									ERP Application server system.<br /><br />
									<i>In case the Activation type is "none", this field is made read-only and its value is not used.</i></td>
							</tr>
							<tr class="listitem2">
								<td>BSE</td>
								<td>This field contains the Baan Environment path (BSE) of the bshell to be started.<br /><br />
									<i>In case the Activation type is "none", this field is made read-only and its value is not used.</i></td>
							</tr>
							<tr class="listitem2">
								<td>Bshell</td>
								<td>This field contains the logical name of the bshell to be started (configured in \${BSE}/lib/ipc_info).<br/><br/>
									<i>In case the Activation type is "none", this field is made read-only and its value is not used.</i></td>
							</tr>
							<tr class="listitem2">
								<td>Environment</td>
								<td>Optional field containing environment settings for the bshell process. For example, you can set
									the environment variable TRACEJCA (set TRACEJCA=1) which has the same meaning as checking the 'trace' option.<br/><br/>
									<i>In case the Activation type is "none", this field is made read-only and its value is not used.</i></td>
							</tr>
							<tr class="listitem2">
								<td>Company</td>
								<td>This field contains the Baan company number which the ERP Application server should use.
									When this field is not filled, the default user company will be used.</td>
							</tr>
							<tr class="listitem2">
								<td>Max connections</td>
								<td>This property indicates the maximum number of physical connections which can be established
									for this connection point. When this property has the value 0 the number of physical
									connections is not limited (pooling disabled).<br/><br/>
								<i>In case the Activation type is "none", this field is made read-only and its value is fixed to 0.</i><br/>
								<i>More information on pooling can be found here: </i> <a href="javascript:help('help_pooling_example.jsp')">Pooling help page</a><br/></td>
							</tr>
							<tr class="listitem2">
								<td>Max references</td>
								<td>This property indicates the maximum number of references that can be made to one
									physical connection. This limit is only effective as long as the <i>'Max connections'</i>
									limit has not yet been reached. When the <i>'Max connections'</i> limit has been reached,
									the connection with the lowest number of references will be chosen.<br/><br/>
									<i>In case the Activation type is "none", this field is made read-only and its value is fixed to 1.</i><br/>
								<i>More information on pooling can be found here: </i> <a href="javascript:help('help_pooling_example.jsp')">Pooling help page</a><br/></td>									
							</tr>
							<tr class="listitem2">
								<td>Max threads</td>
								<td>This property indicates the maximum number of threads that can be queued, waiting for a
									physical connection to become available. The default value ("0") means that no queueing will be done.
									A negative value ("-1") indicates that there is no limit to the number of threads that can be queued.
									<br/>
									This property is typically used in combination with <i>'Max references' = 0</i> to prevent
									multiple requests from being processed concurrently in the same bshell.
									<br/><br/>
									<i>In case the Activation type is "none", this field is made read-only and its value is fixed to 0.</i><br/>
								<i>More information on pooling can be found here: </i> <a href="javascript:help('help_pooling_example.jsp')">Pooling help page</a><br/></td>									
							</tr>
							<tr class="listitem2">
								<td>Keep alive time</td>
								<td>Field containing the number of seconds the connection with the ERP Application
									Server connection should remain after the last reference is gone.<br /> 
									The default value for this field is 0 which means that the connection is removed at
									the moment there are no references anymore.<br/><br/>
								<i>In case the Activation type is "none", this field is made read-only and its value is fixed to 0.</i><br/>
								<i>More information on pooling can be found here: </i> <a href="javascript:help('help_pooling_example.jsp')">Pooling help page</a><br/></td>									
							</tr>
							<tr class="listitem2">
								<td>Options: Trace</td>
								<td>When this option is checked,  a trace files is generated on the server, in
									the \${BSE}/log directory, in which the activities of the ottstpjcadaemon and ottstpbdeman
									processes are traced. This file is named: trace.jca(bshell.pid).<br/><br/>
									<i>In case the Activation type is "none", this field is made read-only and its value is not used.</i></td>
							</tr>
							<tr class="listitem2">
								<td>Options: Allow anonymous requests</td>
								<td>When this option is checked, "anonymous" SOAP requests will be processed. Anonymous
									requests are requests in which no username/password has been specified in the SOAP header.
									In this case the username/password as specified above will be used for authentication.<br/>
									If this option has not been checked, all SOAP requests are required to contain the username
									and password in the SOAP header.<br/><br/>
									<i>In case the Activation type is "none", this field is made read-only and its value is not used.</i></td>
							</tr>
							<tr class="listitem2">
								<td>Options: Use UPN instead of User ID</td>
								<td>When this option is checked, the "User Principal Name" of the user will be used instead of
								the User ID when establishing a "baanlogin_ssl" connection to the ERP Application Server.<br/><br/>
									<i>This option is only available if the Activation type is "baanlogin_ssl".</i></td>
							</tr>
						</table>
						<br/><br/>
						Any modified configuration data is not saved until <b>Add</b> (new ERP Server) or
						<b>Modify</b> (existing ERP Server) is clicked. After successfully saving the configuration data
						the browser navigates back to the <a href="helpcp.jsp"><i>Configure ERP Servers page</i></a>.<br/><br/>
						To leave the page without saving any changes, click <b>Cancel</b>.
					</td>
				</tr>
				<tr class="footerbox">
					<td class="footertext">
						<%=Messages.get("copyright")%>
					</td>
				</tr>              
			</tbody>
		</table>
	</body>
</html>
