<%@ page language="java" contentType="text/html; charset=ISO-8859-1"
    pageEncoding="ISO-8859-1"%>
<%@ page import="com.infor.erpln.soap.Messages" %>
<%@ page import="com.infor.erpln.soap.DeploymentDescriptor" %>
<%@ page import="com.infor.erpln.soap.XMLUtil" %>
<%@ page import="com.infor.erpln.soap.AdditionalSettings" %>
<%@ page import="com.infor.erpln.soap.boi.WSDLGenerator" %>
<%@ page import="com.infor.erpln.soap.boi.BoiExplorer" %>
<%@ page import="com.infor.erpln.rest.bde.BdeRegistry"%>
<%@ page import="java.util.Hashtable" %>
<%@ page import="java.util.Enumeration" %>
<%@ page import="org.w3c.dom.Document" %>
<%@ include file="esapi_utils.jspf" %>
<%
	Hashtable<String,String> status = new Hashtable<String,String>();
	String warning = "";
	try
	{
		String connectionPoint = request.getParameter("cp");
		if (connectionPoint == null || connectionPoint.equals(""))
		{
		    warning = "There is no ERP Server specified";
			throw new IllegalArgumentException();
		}
		
		WSDLGenerator generator = new WSDLGenerator();
		DeploymentDescriptor desc = new DeploymentDescriptor(application);

		String boiName = request.getParameter("name");
		String boiClass = request.getParameter("class");
		boolean ignoreMetadata = Boolean.parseBoolean(request.getParameter("ignoreMD"));
		if (boiName != null)
		{
			String message = "";
			try
			{
				if (boiClass == null)
				{
					boiClass = BoiExplorer.getInstance().getClassName(boiName);
					if (boiClass == null) {
					    // Refresh was invoked on "ServiceName_2"
					    // Try again with "ServiceName"
					    int separatorIndex = boiName.lastIndexOf('_');
					    if (separatorIndex > -1) {
					        String shortName = boiName.substring(0, separatorIndex);
					        boiClass = BoiExplorer.getInstance().getClassName(shortName);
					    }
					}
				}
				String wsdl = generator.generateWSDL(boiName, boiClass, ignoreMetadata);
				Document doc = XMLUtil.StringToDocument(wsdl);
				String uniqueName = desc.add(boiName, doc, connectionPoint);
				AdditionalSettings.setIgnoreMetadata(uniqueName, ignoreMetadata);
				AdditionalSettings.save();
			}
			catch (Exception ex)
			{
				message = "Error when deploying BOI";
			}
			status.put(boiName, message);
		}
		else
		{
			Enumeration<String> paramNames = request.getParameterNames();
			while (paramNames.hasMoreElements())
			{
				String name = paramNames.nextElement();
				String value = request.getParameter(name);
				if (value.equals("on"))
				{
					// split name into boiName and boiClass
					int index = name.indexOf(';');
					boiName = name.substring(0, index);
					boiClass = name.substring(index + 1);
					String message = "";
					try
					{
						String wsdl = generator.generateWSDL(boiName, boiClass, ignoreMetadata);
						Document doc = XMLUtil.StringToDocument(wsdl);
						String uniqueName = desc.add(boiName, doc, connectionPoint);
						AdditionalSettings.setIgnoreMetadata(uniqueName, ignoreMetadata);
						AdditionalSettings.save();
					}
					catch (Exception ex)
					{
						message = "Error when deploying BOI";
					}
					status.put(boiName, message);
				}
			}
		}
		desc.reload();
		BdeRegistry.getInstance().reload();
	}
	catch (Exception ex)
	{
	    if (!warning.isEmpty()) {
	        status.put("", warning);
	    } else {
			status.put("", "An error occurred. (See log file for details.)");
	    }
	}
%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1" />
	<title><%=Messages.get("productname")%> - <%=Messages.get("deploy_title")%></title>
	<meta http-equiv="expires" content="0"/>
	<meta http-equiv="pragma" content="no-cache"/>
	<link href="<%=request.getContextPath()%>/css/wwwstyle.css" type="text/css" rel="stylesheet" />
</head>
<body>
	<table>
		<tbody>
			<tr class="header"><td class="headertext">&nbsp;</td></tr>
			<tr class="logobox">
				<td class="logocell">
					<a href="http://www.infor.com/">
						<img class="logo"
						 src="<%=request.getContextPath()%>/images/infor_logo.gif"/>
					</a>
				</td>
			</tr>
			<tr class="topnavbox">
				<td class="topnavcell">
					<%=Messages.get("productname")%>
				</td>
			</tr>
			<tr>
				<td class="detail">
					<div class="detailname">
						<%=Messages.get("deploy_title")%>
					</div>
					<table class="list">
						<tr>
							<td><%=Messages.get("config_header_service_name")%></td>
							<td><%=Messages.get("config_header_result")%></td>
						</tr>
						<%
							Enumeration<String> names = status.keys();
							while (names.hasMoreElements())
							{
								String name = names.nextElement();
								String message = status.get(name);
								if (message.length() == 0)
								{
									message = Messages.get("config_success");
								}
								else
								{
									message = "<font color='#FF0000'>Error: " + message + "</font>";
								}
								
								out.println("<tr class='listitem'>");
								out.println("  <td>" + encodeHTML(name) + "</td>");
								out.println("  <td>" + message + "</td>");
								out.println("</tr>");
							}
						%>
					</table>
				</td>
			</tr>
			<tr>
				<td class="detail">
					<input type="button" value="<%=Messages.get("button_continue")%>" onclick="location.href='config.jsp'"/>
				</td>
			</tr>
			<tr class="footerbox">
				<td class="footertext">
					<%=Messages.get("copyright")%>
				</td>
			</tr>
		</tbody>
	</table>
</body>
</html>