<%@ page language="java" contentType="text/html; charset=ISO-8859-1"
    pageEncoding="ISO-8859-1"%>
<%@ page import="com.infor.erpln.soap.Messages" %>
<%@ page import="com.infor.erpln.soap.DeploymentDescriptor" %>
<%@ page import="com.infor.erpln.soap.WSDLImporter" %>
<%@ page import="com.infor.erpln.soap.XMLUtil" %>
<%@ page import="com.infor.erpln.rest.bde.BdeRegistry"%>
<%@ page import="java.util.Hashtable" %>
<%@ page import="java.util.Enumeration" %>
<%@ page import="org.w3c.dom.Document" %>
<%@ page import="java.io.File"%>
<%@ page import="java.util.regex.Pattern"%>
<%@ page import="java.util.regex.Matcher"%>
<%@ page import="org.apache.commons.io.FileUtils"%>
<%@ page import="com.infor.erpln.c4ws.util.oauth.BaseUriUtil"%>
<%@ page import="com.infor.erpln.soap.servlet.ServletUtils"%>
<%@ page import="com.infor.erpln.rest.apidoc.openapi.Specification"%>
<%@ page import="com.infor.erpln.rest.apidoc.WSDLConverter"%>
<%@ include file="esapi_utils.jspf" %>
<%!
// Pattern to match the "serverAndPort" (group 1) and the "applicationContext" (group 2) in the request URL
private static final Pattern REQUEST_PATTERN = Pattern.compile("https?://([^/]+)(/[^/]+)/deploy.jsp");

// Create an OpenAPI specification for the given WSDL, and write it to the correct location.
private void generateOpenAPIFile(String wsdl, String connectionPoint, String bdeName, HttpServletRequest request) {
    String baseUri = BaseUriUtil.getBaseUri(request); // "http://servername:port/c4ws/deploy.jsp"
    String serverAndPort = null;
    String applicationContext = null;
    Matcher matcher = REQUEST_PATTERN.matcher(baseUri);
    if (!matcher.matches()) {
        return;
    }
    serverAndPort = matcher.group(1);      // "servername:port"
    applicationContext = matcher.group(2); // "/c4ws"
    // Convert WSDL to OpenAPI specification
    WSDLConverter converter = new WSDLConverter(wsdl);
    converter.setConnectionpoint(connectionPoint);
    converter.setHostAndPort(serverAndPort);
    converter.setBasePath(applicationContext + "/rest");
    try {
        Specification specification = converter.convert();
        
        // Write to file
        File swaggerFile = new File(getSwaggerFolder(connectionPoint), bdeName + ".json");
        FileUtils.writeStringToFile(swaggerFile, specification.toJSONString(), "UTF-8");
    } catch (Exception e) {
        // ignore
    }
}

// Return the folder where the "swagger.json" files are stored. That is "<configFolder>/apidoc/<connectionPoint>"
private File getSwaggerFolder(String connectionPoint) {
    File apidocFolder = new File(ServletUtils.getC4WSProperties().getConfigFolder(), "openapi");
    return new File(apidocFolder, connectionPoint);
}
%>
<%
	Hashtable<String,String> status = new Hashtable<String,String>();
	String warning = "";
	try
	{
		String connectionPoint = request.getParameter("cp");
		if (connectionPoint == null || connectionPoint.equals(""))
		{
		    warning = "There is no ERP Server specified";
			throw new IllegalArgumentException();
		}
		
		WSDLImporter importer = new WSDLImporter(application);
		DeploymentDescriptor desc = new DeploymentDescriptor(application);

		importer.initialize(connectionPoint);
		String name = request.getParameter("name");
		if (name != null)
		{
			String message = "";
			try
			{
				String wsdl = importer.getWSDL(name);
				Document doc = XMLUtil.StringToDocument(wsdl);
				String uname = desc.add(name, doc, connectionPoint);
				
				if (!name.equals(uname))
				{
					message = Messages.get("deploy_rename_warning", uname);
				}
				generateOpenAPIFile(wsdl, connectionPoint, name, request);
			}
			catch (Exception ex)
			{
				message = "Error when deploying BDE";
			}
			status.put(name, message);
		}
		else
		{
			Enumeration<String> paramNames = request.getParameterNames();
			while (paramNames.hasMoreElements())
			{
				name = paramNames.nextElement();
				String value = request.getParameter(name);
				if (value.equals("on"))
				{
					String message = "";
					try
					{
						String wsdl = importer.getWSDL(name);
						Document doc = XMLUtil.StringToDocument(wsdl);
						String uname = desc.add(name, doc, connectionPoint);
						
						if (!name.equals(uname))
						{
							message = Messages.get("deploy_rename_warning", uname);
						}
						generateOpenAPIFile(wsdl, connectionPoint, name, request);
					}
					catch (Exception ex)
					{
						message = "Error when deploying BDE";
					}
					status.put(name, message);
				}
			}
		}
		importer.close();
		desc.reload();
		BdeRegistry.getInstance().reload();
	}
	catch (Exception ex)
	{
	    if (!warning.isEmpty()) {
	        status.put("", warning);
	    } else {
			status.put("", "An error occurred. (See log file for details.)");
	    }
	}
%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1" />
	<title><%=Messages.get("productname")%> - <%=Messages.get("deploy_title")%></title>
	<meta http-equiv="expires" content="0"/>
	<meta http-equiv="pragma" content="no-cache"/>
	<link href="<%=request.getContextPath()%>/css/wwwstyle.css" type="text/css" rel="stylesheet" />
</head>
<body>
	<table>
		<tbody>
			<tr class="header"><td class="headertext">&nbsp;</td></tr>
			<tr class="logobox">
				<td class="logocell">
					<a href="http://www.infor.com/">
						<img class="logo"
						 src="<%=request.getContextPath()%>/images/infor_logo.gif"/>
					</a>
				</td>
			</tr>
			<tr class="topnavbox">
				<td class="topnavcell">
					<%=Messages.get("productname")%>
				</td>
			</tr>
			<tr>
				<td class="detail">
					<div class="detailname">
						<%=Messages.get("deploy_title")%>
					</div>
					<table class="list">
						<tr>
							<td><%=Messages.get("config_header_service_name")%></td>
							<td><%=Messages.get("config_header_result")%></td>
						</tr>
						<%
							Enumeration<String> names = status.keys();
							while (names.hasMoreElements())
							{
								String name = names.nextElement();
								String message = status.get(name);
								if (message.length() == 0)
								{
									message = Messages.get("config_success");
								}
								else
								{
								    message = encodeHTML(message);
								}
								if (message.startsWith("Error"))
								{
									message = "<font color='#FF0000'>" + message + "</font>";
								}
								
								out.println("<tr class='listitem'>");
								out.println("  <td>" + encodeHTML(name) + "</td>");
								out.println("  <td>" + message + "</td>");
								out.println("</tr>");
							}
						%>
					</table>
				</td>
			</tr>
			<tr>
				<td class="detail">
					<input type="button" value="<%=Messages.get("button_continue")%>" onclick="location.href='config.jsp'"/>
				</td>
			</tr>
			<tr class="footerbox">
				<td class="footertext">
					<%=Messages.get("copyright")%>
				</td>
			</tr>
		</tbody>
	</table>
</body>
</html>