<%@ page language="java" contentType="text/html; charset=ISO-8859-1"
    pageEncoding="ISO-8859-1"%>
<%@ page import="com.infor.erpln.soap.Messages" %>
<%@ page import="com.infor.erpln.soap.DeploymentDescriptor" %>
<%@ page import="com.infor.erpln.soap.servlet.ErpServerManager" %>
<%@ page import="com.infor.erpln.c4ws.util.LNEnvironment" %>
<%@ include file="esapi_utils.jspf" %>
<%
	String orgPage = request.getParameter("org");
	if (orgPage == null)
	{
		orgPage = "index.jsp";
	}
%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1" />
	<meta http-equiv="expires" content="0"/>
	<meta http-equiv="pragma" content="no-cache"/>
	<title><%=Messages.get("productname")%> - <%=Messages.get("erp_servers_title")%></title>
	<link href="<%=request.getContextPath()%>/css/wwwstyle.css" type="text/css" rel="stylesheet" />
	<script language="javascript" src="help.js"></script>
	<script type="text/javascript">
	function setCloudEnvironment(message)
	{
		// message contains "{0}" placeholder for the selected name
		setWaitCursor()
		var listBox = document.getElementById("cloudEnv")
		var envName = listBox.value // The real "LNUI environment" name
		var displayName = listBox.options[listBox.selectedIndex].label // "ERP Server" name as shown in the list
		var substitutedMessage = message.replace("{0}", displayName)
		var ok = confirm(substitutedMessage)
		// if ok go to set_cloudenv page, else go to this page (resetting the selection)
		if (ok)
		{
			// Let 'set_cloudenv.jsp' set the cloud environment, and return to this page
			window.location.href = "set_cloudenv.jsp?org=<%=encodeURL(orgPage)%>&name=" + envName
		}
		else
		{
			// Reload this page to reset the selection in the "cloudEnv" listbox
			window.location.href = "cp.jsp?org=<%=encodeURL(orgPage)%>"
		}
	}
	
	function setIMSEnvironment(message)
	{
		// message contains "{0}" placeholder for the selected name
		setWaitCursor()
		var listBox = document.getElementById("imsEnv")
		var envName = listBox.value // The real "LNUI environment" name
		var displayName = listBox.options[listBox.selectedIndex].label // "ERP Server" name as shown in the list
		var substitutedMessage = message.replace("{0}", displayName)
		var ok = confirm(substitutedMessage)
		// if ok go to set_imsenv page, else go to this page (resetting the selection)
		if (ok)
		{
			// Let 'set_imsenv.jsp' set the IMS environment, and return to this page
			window.location.href = "set_imsenv.jsp?org=<%=encodeURL(orgPage)%>&name=" + envName
		}
		else
		{
			// Reload this page to reset the selection in the "imsEnv" listbox
			window.location.href = "cp.jsp?org=<%=encodeURL(orgPage)%>"
		}
	}
	</script>
</head>
<body>
	<table>
		<tbody>
			<tr class="header"><td class="headertext"><a href="javascript:help('help/helpcp.jsp')"><%=Messages.get("button_help")%></a></td></tr>
			<tr class="logobox">
				<td class="logocell">
					<a href="http://www.infor.com/">
						<img class="logo"
						 src="<%=request.getContextPath()%>/images/infor_logo.gif"/>
					</a>
				</td>
			</tr>
			<tr class="topnavbox">
				<td class="topnavcell">
					<%=Messages.get("productname")%>
				</td>
			</tr>
			<tr>
				<td class="detail">
					<div class="detailname">
						<%=Messages.get("erp_servers_title")%>
					</div>
					<%
						try
						{
							ErpServerManager man = new ErpServerManager(application);
							boolean inCloud = man.isCloudEnabled();
							String cloudEnv = man.getCloudEnvironmentID();
							String imsEnv = man.getIMSEnvironmentID();
							String[] list = man.listConnectionPointNames();
							if (list.length > 0)
							{
					%>
					<form method="post" action="<%=request.getContextPath()%>/remove.jsp">
					<table class="list">
						<tr> 
							<td><%=Messages.get("config_header_erp_server")%></td>
							<td><%=Messages.get("config_header_hostname")%></td>
							<td><%=Messages.get("config_header_activation_type")%></td>
							<td><%=Messages.get("config_header_port")%></td>
							<td><%=Messages.get("config_header_bse")%></td>
							<td><%=Messages.get("config_header_user")%></td>
							<td>&nbsp;</td>
							<td>&nbsp;</td>
						</tr>
						<%
						    for (int i = 0; i < list.length; i++)
														{
														    LNEnvironment env = man.getEnvironmentForCP(list[i]);
						%>
						<tr class="listitem">
							<td><%=encodeHTML(list[i])%></td>
							<td><%=encodeHTML(env.getHost())%></td>
							<td><%=encodeHTML(env.getActivation())%></td>
							<td><%=env.getPort()%></td>
							<td><%=encodeHTML(env.getBSE())%></td>
							<td><%=encodeHTML(env.getUser())%></td>
							<td width="16"><a href="add_cp.jsp?name=<%=encodeURL(list[i])%>&action=<%=Messages.get("button_modify")%>&org=<%=encodeURL(orgPage)%>">
											<img src="<%=request.getContextPath()%>/images/modify.gif" alt="<%=Messages.get("button_modify_server")%>"/></a></td>
							<%
									// only allow removal if this connectionpoint is not is use
									DeploymentDescriptor desc = new DeploymentDescriptor(application);
									if (desc.isConnectionPointInUse(list[i]))
									{	// is use: disabled trashcan
							%>
							<td width="16"><img src="<%=request.getContextPath()%>/images/trashcan_disabled.gif" alt="<%=Messages.get("config_server_in_use")%>"/></td>
							<%
									}
									else
									{	// not in use: removal allowed
							%>
							<td width="16"><a href="remove_cp.jsp?name=<%=encodeURL(list[i])%>&org=<%=encodeURL(orgPage)%>" onclick='return confirm("<%=Messages.get("config_question_delete_server", encodeHTML(list[i]))%>")'>
											<img src="<%=request.getContextPath()%>/images/trashcan.gif" alt="<%=Messages.get("button_remove_server")%>"/></a></td>
							<%
									}
							%>
						</tr>
						<%
								}
						%>
					</table>
					</form>
					<%
								if (inCloud && list.length > 1) {
									String message = Messages.get("config_question_set_cloudenv");
									%>
					<table class="list"><tr><td class="row-left"><%=Messages.get("config_label_cloudenv")%></td>
					<td><select id="cloudEnv" name="cloudEnv" onchange="setCloudEnvironment('<%=message%>')">
							<%
							boolean envSelected = false;
							for (int i = 0; i < list.length; i++)
							{
								LNEnvironment env = man.getEnvironmentForCP(list[i]);
								if (!"baanlogin_ssl".equals(env.getActivation())) {
								    // Skip environments that do not use baanlogin_ssl (mandatory for Cloud)
								    continue;
								}
								String name = env.getName();
								boolean isCloudEnvironment = name.equals(cloudEnv);
								if (isCloudEnvironment) {
								    envSelected = true;
								}
								String optionSelected = isCloudEnvironment ? "selected" : "";
								// Note: environment name ("name") may differ from ERP Server name (list[i]).
								// ERP Server name will be shown in the list box; environment name will be used
								// as "value" and processed by "setCloudEnvironment" function.
							%>
								<option <%=optionSelected%> value="<%=encodeAttribute(name)%>"><%=encodeHTML(list[i])%></option>
							<%
							}
							if (!envSelected) {
								// Nothing selected yet, add empty option
								%>
								<option selected disabled style="display:none" value="">&nbsp;</option>
								<%	
							}
							%>
						</select>
					</td></tr></table>
					<%
								}
								// Add list box for IMS environment
								String message = Messages.get("config_question_set_imsenv");
								%>
					<table class="list"><tr><td class="row-left"><%=Messages.get("config_label_imsenv")%></td>
					<td><select id="imsEnv" name="imsEnv" onchange="setIMSEnvironment('<%=message%>')">
							<%
								boolean envSelected = false;	
								for (int i = 0; i < list.length; i++)
								{
									LNEnvironment env = man.getEnvironmentForCP(list[i]);
									if (!"baanlogin_ssl".equals(env.getActivation())) {
									    // Skip environments that do not use baanlogin_ssl (mandatory for IMS)
									    continue;
									}
									String name = env.getName();
									boolean isImsEnvironment = name.equals(imsEnv);
									if (isImsEnvironment) {
									    envSelected = true;
									}
									String optionSelected = isImsEnvironment ? "selected" : "";
									// Note: environment name ("name") may differ from ERP Server name (list[i]).
									// ERP Server name will be shown in the list box; environment name will be used
									// as "value" and processed by "setCloudEnvironment" function.
								%>
							<option <%=optionSelected%> value="<%=encodeAttribute(name)%>"><%=encodeHTML(list[i])%></option>
								<%
								}
								if (!envSelected){
									// Nothing selected yet, add empty option
									%>
									<option selected disabled style="display:none" value="">&nbsp;</option>
									<%
								}%>
						</select>
					</td></tr></table>
								<%
							}
							else // list.length == 0
							{
					%>
					<p><%=Messages.get("config_click_add")%></p>
					<%
							}
						}
						catch (Exception ex)
						{
							out.println("<p><font color='#FF0000'>" + Messages.get("config_error_servers"));
							out.println("(See log file for details.)</font></p>");
						}
					%>
					<input type="button" value="<%=Messages.get("button_add_server")%>" onclick="window.location='select_env.jsp?action=<%=Messages.get("button_add")%>&org=<%=encodeURL(orgPage)%>'"/>
				</td>
			</tr>
			<tr>
				<td class="detail">
					<input type="button" value="<%=Messages.get("button_back")%>" onclick="setWaitCursor(); location.href='<%=encodeURL(orgPage)%>'"/>
				</td>
			</tr>
			<tr class="footerbox">
				<td class="footertext">
					<%=Messages.get("copyright")%>
				</td>
			</tr>
		</tbody>
	</table>
</body>
</html>