<%@ page language="java" contentType="text/html; charset=ISO-8859-1"
    pageEncoding="ISO-8859-1"%>
<%@ page import="com.infor.erpln.soap.Messages" %>
<%@ page import="com.infor.erpln.soap.DeploymentDescriptor" %>
<%@ page import="com.infor.erpln.soap.Endpoint" %>
<%@ page import="com.infor.erpln.soap.AdditionalSettings" %>
<%@ page import="com.infor.erpln.soap.servlet.ErpServerManager" %>
<%@ page import="com.infor.erpln.c4ws.util.LNEnvironment"%>
<%@ include file="esapi_utils.jspf" %>
<%
	boolean isCloudEnabled = new ErpServerManager(application).isCloudEnabled();
%>
<%!private String getTooltip(ServletContext context, String connectionPoint)
{
	try
	{
		ErpServerManager man = new ErpServerManager(context);
		LNEnvironment env = man.getEnvironmentForCP(connectionPoint);
		String activation = env.getActivation();
		
		String result = Messages.get("config_label_erp_server") + encodeHTML(connectionPoint) +
		"<br/>" + Messages.get("config_label_hostname") + encodeHTML(env.getHost()) +
		"<br/>" + Messages.get("config_label_activation_type") + encodeHTML(activation) +
		"<br/>" + Messages.get("config_label_port") + env.getPort();
		if (!activation.equals("none"))
		{
			result += "<br/>" + Messages.get("config_label_bse") + encodeHTML(env.getBSE()) +
					  "<br/>" + Messages.get("config_label_user") + encodeHTML(env.getUser());
		}
		return result;
	}
	catch (Exception ex)
	{
		return "";
	}
}%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1" />
	<meta http-equiv="expires" content="0"/>
	<meta http-equiv="pragma" content="no-cache"/>
	<title><%=Messages.get("productname")%> - <%=Messages.get("config_title")%></title>
	<link href="<%=request.getContextPath()%>/css/wwwstyle.css" type="text/css" rel="stylesheet" />
	<script language="javascript" src="help.js"></script>
</head>
<body>
	<table>
		<tbody>
			<tr class="header"><td class="headertext"><a href="javascript:help('help/helpconfig.jsp')"><%=Messages.get("button_help")%></a></td></tr>
			<tr class="logobox">
				<td class="logocell">
					<a href="http://www.infor.com/">
						<img class="logo"
						 src="<%=request.getContextPath()%>/images/infor_logo.gif"/>
					</a>
				</td>
			</tr>
			<tr class="topnavbox">
				<td class="topnavcell">
					<%=Messages.get("productname")%>
				</td>
			</tr>
			<tr>
				<td class="detail">
					<div class="detailname">
						<%=Messages.get("config_title")%>
					</div>
					<%
						try
						{
							DeploymentDescriptor deploymentDesc = new DeploymentDescriptor(application);
							Endpoint[] list = deploymentDesc.listEndpoints();
							if (isCloudEnabled)
							{
								%>
								<p><%=Messages.get("config_no_cloud_web_services")%></p>
								<%
							}
							else if (list.length > 0)
							{
					%>
					<form method="post" action="<%=request.getContextPath()%>/undeploy.jsp">
					<table class="list">
						<tr>
							<td>&nbsp;</td>
							<td><%=Messages.get("config_header_service_name")%></td>
							<td><%=Messages.get("config_header_type")%></td>
							<td><%=Messages.get("config_header_erp_server")%></td>
							<td>&nbsp;</td>
							<td>&nbsp;</td>
						</tr>
						<%
								for (int i = 0; i < list.length; i++)
								{
						%>
						<tr class="listitem">
							<td width="16"><input type="checkbox" name="<%=encodeAttribute(list[i].getName())%>"/></td>
							<td><%=encodeHTML(list[i].getName())%></td>
							<td><%=encodeHTML(list[i].getType())%></td>
							<td onmouseover="tooltip.on('<%=getTooltip(application, list[i].getConnectionPoint())%>')" onmouseout="tooltip.off()" onmousemove="tooltip.move(event)"><%=encodeHTML(list[i].getConnectionPoint())%></td>
						<%
									if (list[i].getType().equals("BOI"))
									{
									    boolean ignoreMetadata = AdditionalSettings.isIgnoreMetadata(list[i].getName());
									    String urlOption = ignoreMetadata ? "&ignoreMD=true" : "";
						%>	
							<td width="16"><a href="deploy_boi.jsp?name=<%=encodeURL(list[i].getBDEName())%>&cp=<%=encodeURL(list[i].getConnectionPoint())%><%=urlOption %>" onclick="setWaitCursor();">
											<img src="<%=request.getContextPath()%>/images/refresh.gif" alt="<%=Messages.get("button_refresh")%>"/></a></td>
						<%
									}
									else
									{
						%>	
							<td width="16"><a href="deploy.jsp?name=<%=encodeURL(list[i].getBDEName())%>&cp=<%=encodeURL(list[i].getConnectionPoint())%>" onclick="setWaitCursor();">
											<img src="<%=request.getContextPath()%>/images/refresh.gif" alt="<%=Messages.get("button_refresh")%>"/></a></td>
						<%
									}
						%>
							<td width="16"><a href="undeploy.jsp?name=<%=encodeURL(list[i].getName())%>" onclick='return confirm("<%=Messages.get("config_question_undeploy", encodeHTML(list[i].getName()))%>")'>
											<img src="<%=request.getContextPath()%>/images/trashcan.gif" alt="<%=Messages.get("button_undeploy")%>"/></a></td>
						</tr>
						<%
								}
						%>
					</table>
					<input type="submit" value="<%=Messages.get("button_undeploy")%>" onclick='return confirm("<%=Messages.get("config_question_undeploy_multiple")%>")'/>
					</form>
					<%
							}
							else // list.length == 0
							{
					%>
					<p><%=Messages.get("config_no_deployed_web_services")%></p>
					<%
							}
						}
						catch (Exception ex)
						{
							out.println("<p><font color='#FF0000'>" + Messages.get("config_error_deployed"));
							out.println("(See log file for details.)</font></p>");
						}
						
						// set a preferred connectionpoint if there is only one
						if (session.getAttribute("lastConnectionPoint") == null)
						{
							ErpServerManager man = new ErpServerManager(application);
							String[] points = man.listConnectionPointNames();
							if (points.length == 1)
							{
								session.setAttribute("lastConnectionPoint", points[0]);
							}
						}
					%>
				</td>
			</tr>
			<tr>
				<td class="detail">
					<input type="button" value="<%=Messages.get("button_back")%>" onclick="location.href='index.jsp'"/>
					<%
					if (!isCloudEnabled)
					{
					%>
					<input type="button" value="<%=Messages.get("button_deploy_bdes")%>" onclick="setWaitCursor(); location.href='import.jsp'"/>
					<input type="button" value="<%=Messages.get("button_deploy_bois")%>" onclick="setWaitCursor(); location.href='list_boi.jsp'"/>
					<%
					}
					%>
				</td>
			</tr>
			<tr class="footerbox">
				<td class="footertext">
					<%=Messages.get("copyright")%>
				</td>
			</tr>
		</tbody>
	</table>
	<script language="javascript" src="tooltip.js"></script>
</body>
</html>