<%@page import="com.infor.erpln.c4ws.util.C4WSProperties"%>
<%@page import="com.infor.erpln.soap.servlet.SettingsManager"%>
<%@page import="com.infor.erpln.c4ws.util.C4WSPropertiesManager"%>
<%@page import="com.infor.erpln.soap.Messages"%>
<%@ page language="java" contentType="text/html; charset=ISO-8859-1"
    pageEncoding="ISO-8859-1"%>
<%@ include file="esapi_utils.jspf" %>
<%
    String orgPage = request.getParameter("org");
	if (orgPage == null) {
		orgPage = "index.jsp";
	}

	SettingsManager man = (SettingsManager) session.getAttribute("settings");
	if (man == null) {
	    man = new SettingsManager(application);
	    session.setAttribute("settings", man);
	}
	
	String lnuiConfigFile = man.getLNUIConfigFile();
	String storePath = man.getKeystoreLocation();
	String storePassword = man.getDummyKeystorePassword();
	String consumerKey = man.getConsumerKey();
	String consumerSecret = man.getDummyConsumerSecret();
	String cloudEnabled = man.isCloudEnabled() ? "true" : "";

	String action = request.getParameter("action");
	if (action == null) {
	    // Use data from SettingsManager
	} else if (action.equals("save")) {
	    // Get submitted data from request
	    lnuiConfigFile = request.getParameter("lnuiconfig");
	    storePath = request.getParameter("keystorepath");
	    storePassword = request.getParameter("keystorepassword");
	    consumerKey = request.getParameter("consumerkey");
	    consumerSecret = request.getParameter("consumersecret");
	    cloudEnabled = request.getParameter("cloudenabled");
	    // Set data in SettingsManager
	    man.setKeystoreLocation(storePath);
	    man.setKeystorePassword(storePassword);
	    man.setConsumerKey(consumerKey);
	    man.setConsumerSecret(consumerSecret);
	    man.setCloudEnabled("true".equals(cloudEnabled));
	    // Set LNUI config file -- possibly changing inherited values
	    man.setLNUIConfigFile(lnuiConfigFile);
	    // Save changes
	    man.saveChanges();
	    // Remove settings from session object
	    session.setAttribute("settings", null);
	} else if (action.equals("cancel")) {
	    // Remove settings from session object
	    session.setAttribute("settings", null);
	}
%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="expires" content="0"/>
	<meta http-equiv="pragma" content="no-cache"/>
	<% if ("cancel".equals(action) || "save".equals(action)) { %>
	<meta http-equiv="REFRESH" content="0;URL=<%= request.getContextPath() + "/" + encodeAttribute(orgPage) %>"/>
	<% } %>
	<title><%=Messages.get("productname")%> - <%=Messages.get("advanced_title")%></title>
	<link href="<%=request.getContextPath()%>/css/wwwstyle.css" type="text/css" rel="stylesheet" />
	<script language="javascript" src="help.js"></script>
	<script type="text/javascript">
		function warnChangedCloud() {
			var origCloudEnabled = document.getElementById("origCE").value        // string ("true" or "")
			var newCloudEnabled = document.getElementById("cloudenabled").checked // boolean
			if ((origCloudEnabled == "true" && !newCloudEnabled) || (origCloudEnabled != "true" && newCloudEnabled)) {
				// Original setting differs from current setting -- Make warning visible
				document.getElementById("warning").style.visibility = "visible"
			} else {
				document.getElementById("warning").style.visibility = "hidden"
			}
			return true
		}
		function comparePasswords(first, second, warning) {
			// arguments: first = id of first password input field
			//            second = id of second password input field
			//            warning = id of (hidden) warning text
			var pwd1 = document.getElementById(first).value
			var pwd2 = document.getElementById(second).value
			var match = (pwd1 == pwd2)
			document.getElementById("submit").disabled = !match
			document.getElementById(warning).style.visibility = (match ? "hidden" : "visible")
		}
	</script>
</head>
<body>
<form method="post" id="advform" action="<%= request.getContextPath() %>/advanced.jsp?org=<%=encodeURL(orgPage)%>&action=save">
	<table>
		<tbody>
			<tr class="header"><td class="headertext"><a href="javascript:help('help/helpadvanced.jsp')"><%=Messages.get("button_help")%></a></td></tr>
			<tr class="logobox">
				<td class="logocell">
					<a href="http://www.infor.com/">
						<img class="logo"
						 src="<%=request.getContextPath()%>/images/infor_logo.gif"/>
					</a>
				</td>
			</tr>
			<tr class="topnavbox">
				<td class="topnavcell">
					<%=Messages.get("productname")%>
				</td>
			</tr>
			<tr>
				<td class="detail">
					<div class="detailname">
						<%=Messages.get("config_label_advanced")%>
					</div>
					<input type="hidden" id="origCE" name="origCE" value="<%= man.isCloudEnabled() ? "true" : "" %>"/>
					<table>
						<tr>
							<%
								String cloudChecked = "";
								if ("true".equals(cloudEnabled)) {
									cloudChecked = "checked";
								}
							%>
							<td class="row-left"><b><%=Messages.get("config_label_cloudEnabled")%></b></td>
							<td><input type="checkbox" <%= cloudChecked %> id="cloudenabled" name="cloudenabled" value="true"
										onchange="warnChangedCloud()" /></td>
						</tr>
						<tr>
							<td class="row-left"><b><%=Messages.get("config_label_lnui_configfile")%></b></td>
							<td><input type="text" size="100" id="lnuiconfig" name="lnuiconfig" value="<%=encodeAttribute(lnuiConfigFile)%>"/></td>
						</tr>
					</table>
						
				</td>
			</tr>
			<tr>
				<td class="detail">
					<div class="detailname">
						<%=Messages.get("config_label_keystore_settings")%>
					</div>
					<table>
						<tr>
							<td class="row-left"><b><%=Messages.get("config_label_keystore_path")%></b></td>
							<td><input type="text" size="100" id="keystorepath" name="keystorepath" value="<%=encodeAttribute(storePath)%>"/></td>
						</tr>
						<tr>
							<td class="row-left"><b><%=Messages.get("config_label_keystore_password")%></b></td>
							<td><input type="password" size="20" id="keystorepassword" name="keystorepassword" value="<%=encodeAttribute(storePassword)%>"
										onkeyup="comparePasswords('keystorepassword','keystorepwd_conf','storepwd_error')"
										onchange="comparePasswords('keystorepassword','keystorepwd_conf','storepwd_error')"/></td>
						</tr>
						<tr>
							<td class="row-left">&nbsp;</td>
							<td><input type="password" size="20" id="keystorepwd_conf" name="keystorepwd_conf" value="<%=encodeAttribute(storePassword)%>"
										onkeyup="comparePasswords('keystorepassword','keystorepwd_conf','storepwd_error')"
										onchange="comparePasswords('keystorepassword','keystorepwd_conf','storepwd_error')"/>
								<span id="storepwd_error" class="inputerror" style="visibility:hidden"><%=Messages.get("config_warning_passwords")%></span></td>
						</tr>
					</table>
				</td>
			</tr>
			<tr>
				<td class="detail">
					<div class="detailname">
						<%=Messages.get("config_label_oauth_settings")%>
					</div>
					<table>
						<tr>
							<td class="row-left"><b><%=Messages.get("config_label_oauth_key")%></b></td>
							<td><input type="text" size="20" id="consumerkey" name="consumerkey" value="<%=encodeAttribute(consumerKey)%>"/></td>
						</tr>
						<tr>
							<td class="row-left"><b><%=Messages.get("config_label_oauth_secret")%></b></td>
							<td><input type="password" size="20" id="consumersecret" name="consumersecret" value="<%=encodeAttribute(consumerSecret)%>"
										onkeyup="comparePasswords('consumersecret','consumersecret_conf','consumersecret_error')"
										onchange="comparePasswords('consumersecret','consumersecret_conf','consumersecret_error')"/></td>
						</tr>
						<tr>
							<td class="row-left">&nbsp;</td>
							<td><input type="password" size="20" id="consumersecret_conf" name="consumersecret_conf" value="<%=encodeAttribute(consumerSecret)%>"
										onkeyup="comparePasswords('consumersecret','consumersecret_conf','consumersecret_error')"
										onchange="comparePasswords('consumersecret','consumersecret_conf','consumersecret_error')"/>
								<span id="consumersecret_error" class="inputerror" style="visibility:hidden"><%=Messages.get("config_warning_secrets")%></span></td>
						</tr>
					</table>
				</td>
			</tr>
			<tr>
				<td class="detail">
				<span id="warning" class="inputerror" style="visibility:hidden"> <%= Messages.get("config_warning_cloudEnabled") %> </span>&nbsp;
				</td>
			</tr>
			<tr>
				<td class="detail">
					<input type="submit" id="submit" value='<%=Messages.get("button_modify")%>'/>
					<input type="button" value='<%=Messages.get("button_cancel")%>'
					 onclick="location.href='<%= request.getContextPath() %>/advanced.jsp?action=cancel&org=<%=encodeURL(orgPage)%>'"/>
				</td>
			</tr>
			<tr class="footerbox">
				<td class="footertext">
					<%=Messages.get("copyright")%>
				</td>
			</tr>
		</tbody>
	</table>
</form>

</body>
</html>
