<%@ page language="java" contentType="text/html; charset=ISO-8859-1"
    pageEncoding="ISO-8859-1"%>
<%@ page import="com.infor.erpln.soap.Messages" %>
<%@ page import="com.infor.erpln.soap.servlet.ErpServerManager" %>    
<%@ page import="com.infor.erpln.c4ws.util.LNEnvironment"%>
<%@ page import="java.util.Hashtable" %>
<%@ include file="esapi_utils.jspf" %>
<%!
	private String getStringValue(Hashtable<String, String[]> params, String name, String defaultValue)
	{
		String result = defaultValue;
		if (params != null)
		{
			String[] value = params.get(name);
			if ((value != null) && (value.length > 0) && (value[0] != null))
			{
				result = value[0];
			}
		}
		return result;
	}

	private int getIntegerValue(Hashtable<String, String[]> params, String name, int defaultValue)
	{
		int result = defaultValue;
		if (params != null)
		{
			String[] value = params.get(name);
			if ((value != null) && (value.length > 0) && (value[0] != null))
			{
				try
				{
					result = Integer.parseInt(value[0]);
				}
				catch (NumberFormatException ex)
				{}
			}
		}
		return result;
	}
%>
<%
	String orgPage = request.getParameter("org");
	if (orgPage == null)
	{
		orgPage = "index.jsp";
	}
	String envname = request.getParameter("envname"); // LN environment name, chosen in "select_env.jsp"
	if (envname == null || envname.equals("NONE")) {
    	envname = ""; // no environment was chosen (or no unmapped environment was available)
	}
%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1" />
	<title><%=Messages.get("productname")%> - <%=Messages.get("add_server_title", "Add/Modify")%></title>
	<link href="<%=request.getContextPath()%>/css/wwwstyle.css" type="text/css" rel="stylesheet" />
	<script language="javascript" src="help.js"></script>
	<script type="text/javascript" src="validator.js"></script>
	<script type="text/javascript">
		function Select() 
		{
			var id=document.getElementById("activationType").value
			var required = "*";
			var isDisabled = false;
			
			if(id=="baanlogin")
			{
				document.getElementById("port").readOnly=false
				if (document.getElementById("port").value=="512"){
					document.getElementById("port").value="7150"
				}
				document.getElementById("tdport").innerHTML="*"
				document.getElementById("activationPassword").disabled=false
				document.getElementById("anonymousAllowed").disabled=false
				document.getElementById("optionUpn").style.visibility="hidden"
			}
			else if (id=="baanlogin_ssl")
			{
				document.getElementById("port").readOnly=false
				if (document.getElementById("port").value=="512"){
					document.getElementById("port").value="7150"
				}
				document.getElementById("tdport").innerHTML="*"
				document.getElementById("activationPassword").disabled=true
				document.getElementById("tdpassword").innerHTML=""
				displayError("inf_password","");
				document.getElementById("anonymousAllowed").disabled=true
				document.getElementById("optionUpn").style.visibility="visible"
			}
			else if(id=="rexec")
			{
				document.getElementById("port").readOnly=true
				document.getElementById("port").value="512"
				displayError("inf_port","");
				
				document.getElementById("tdport").innerHTML=""
				document.getElementById("activationPassword").disabled=false
				document.getElementById("anonymousAllowed").disabled=false
				document.getElementById("optionUpn").style.visibility="hidden"
			}
			else //id=="none"
			{
				required = "";
				isDisabled= true;
				displayError("inf_bse","");
				displayError("inf_company","");
				displayError("inf_user","");
				displayError("inf_password","");
				displayError("inf_bshell","");
				displayError("inf_maxConnections","");
				displayError("inf_maxReferences","");
				displayError("inf_maxThreads","");
				displayError("inf_timerDelay","");
					
				document.getElementById("port").readOnly=false
				document.getElementById("tdport").innerHTML="*"
				document.getElementById("activationPassword").disabled=true
				document.getElementById("anonymousAllowed").disabled=true
				document.getElementById("optionUpn").style.visibility="hidden"
			}
			
			document.getElementById("timerDelay").disabled=isDisabled
			document.getElementById("maxConnections").disabled=isDisabled
			document.getElementById("maxReferences").disabled=isDisabled
			document.getElementById("maxThreads").disabled=isDisabled
			document.getElementById("activationUser").disabled=isDisabled
			document.getElementById("activationBse").disabled=isDisabled
			document.getElementById("activationBshell").disabled=isDisabled
			document.getElementById("activationEnvironment").disabled=isDisabled
			document.getElementById("activationDaemonOptions").disabled=isDisabled
			document.getElementById("activationCompany").disabled=isDisabled
			
			document.getElementById("tdmaxconnections").innerHTML=required
			document.getElementById("tdmaxreferences").innerHTML=required
			document.getElementById("tdmaxthreads").innerHTML=required
			document.getElementById("tdtimerdelay").innerHTML=required
			document.getElementById("tduser").innerHTML=required
			if (id != "baanlogin_ssl") {
				document.getElementById("tdpassword").innerHTML=required
			}
			document.getElementById("tdbse").innerHTML=required
			document.getElementById("tdbshell").innerHTML=required
			
			if (document.getElementById("activationCompany").value=="-1")
			{
				document.getElementById("activationCompany").value=""
			}
		}
		
		function validateOnSubmit()
		{
			var elem;
			var errs=0;
			// execute all element validations in reverse order, so focus gets
			// set to the first one in error.

			if (!validateActivationNumericRange(document.forms.adding.timerDelay,'inf_timerDelay', 0, 2147483)) errs += 1;
			if (!validateActivationNumericNotEmpty(document.forms.adding.maxConnections,'inf_maxConnections')) errs += 1;
			if (!validateActivationNumericNotEmpty(document.forms.adding.maxReferences,'inf_maxReferences')) errs += 1;
			if (!validateActivationSignedNumeric(document.forms.adding.maxThreads,'inf_maxThreads')) errs += 1;
			if (!validateActivationNumericRange(document.forms.adding.activationCompany,'inf_company', 0, 9999)) errs += 1;
			if (!validateActivationStringNotEmpty(document.forms.adding.activationBshell,'inf_bshell')) errs += 1;
			if (!validateActivationStringNotEmpty(document.forms.adding.activationBse,'inf_bse')) errs += 1;
			if (!validatePasswordStringNotEmpty(document.forms.adding.activationPassword,'inf_password')) errs += 1;
			if (!validateActivationStringNotEmpty(document.forms.adding.activationUser,'inf_user')) errs += 1;

			if (!validateNumericNotEmpty(document.forms.adding.port,'inf_port')) errs += 1; 
			if (!validateStringNotEmpty(document.forms.adding.hostName,'inf_hostname')) errs += 1; 
			if (!validateIdentifier(document.forms.adding.name,'inf_name')) errs += 1; 
		
			if (errs>1)  
			{
				setFocusDelayed();
				alert('<%=Messages.get("config_error_fields")%>');
			}
			if (errs==1)
			{
				setFocusDelayed();
				alert('<%=Messages.get("config_error_field")%>');
			}
			return (errs==0);
		};		
	</script>
	</head>
	<body onload="Select();">
	<%
	    // INIT
			Hashtable<String, String[]> parameters = (Hashtable<String, String[]>) session.getAttribute("params");

			// get initial values. if parameters is set then retrieve values from previous attempt
			String name = getStringValue(parameters, "name", "");
			String hostName = getStringValue(parameters, "hostName", "");
			int portNumber = getIntegerValue(parameters, "port", 512);
			int timerDelay  = getIntegerValue(parameters, "timerDelay", 0);
			int maxConnections  = getIntegerValue(parameters, "maxConnections", 0);
			int maxReferences  = getIntegerValue(parameters, "maxReferences", 1);
			int maxThreads = getIntegerValue(parameters, "maxThreads", 0);
			String activationType = getStringValue(parameters, "activationType", "rexec");
			String bse = getStringValue(parameters, "activationBse", "");
			int company = getIntegerValue(parameters, "activationCompany", -1);
			String bshell = getStringValue(parameters, "activationBshell", "");
			String environment = getStringValue(parameters, "activationEnvironment", "");
			String daemonOptions = getStringValue(parameters, "activationDaemonOptions", "");
			String anonymousAllowed = getStringValue(parameters, "anonymousAllowed", "");
			String user = getStringValue(parameters, "activationUser", "");
			String password = getStringValue(parameters, "activationPassword", "");
			String useUpn = getStringValue(parameters, "useUpn", "");

			String action = request.getParameter("action");
			action = getStringValue(parameters, "action", action);

			session.setAttribute("params", null); // reset the session hashtable to null

			String erpServerName = request.getParameter("name"); // set when clicking "modify" in "cp.jsp"
			if (action == null)
			{
				action = (erpServerName != null) ? Messages.get("button_modify") : Messages.get("button_add");
			}
			if (parameters == null &&			// First attempt (not after a failed "save_cp.jsp")
			        (erpServerName != null ||	// Modifying existing ERP Server
			        !envname.isEmpty())) 		// Creating new ERP Server based on LNUI environment
			{
				// get values from file
				ErpServerManager man = new ErpServerManager(application);
				LNEnvironment env = null;
				if (erpServerName != null) {
				    env = man.getEnvironmentForCP(erpServerName);
				} else {
				    env =  man.getEnvironmentForID(envname);
				    erpServerName = man.getCPForEnvironmentID(envname);
				}
				if (env != null) // check if connectionpoint exists
				{
					name = erpServerName;
					hostName = env.getHost();
					portNumber = env.getPort();
					timerDelay = env.getKeepAlive();
					maxConnections = env.getMaxConnections();
					maxReferences = env.getMaxReferences();
					maxThreads = env.getMaxThreads();
					String activation = env.getActivation();
					if (!activation.equals("none"))
					{
						activationType = env.getActivation();
						bse = env.getBSE();
						company = env.getCompany();
						bshell = env.getBshell();
						environment = env.getCommand();
						if (environment == null) environment = "";
						daemonOptions = env.isTraceBackend() ? "-trace" : "";
						user = env.getUser();
						password = env.getCleartextPassword();
						anonymousAllowed = env.isAnonymousAllowed() ? "true" : "";
						useUpn = env.isUseUpn() ? "true" : "";
					}
				}
			}
	%> 
	<table>
		<tbody>
			<tr class="header"><td class="headertext"><a href="javascript:help('help/help_add_cp.jsp')"><%=Messages.get("button_help")%></a></td></tr>
			<tr class="logobox">
				<td class="logocell">
					<a href="http://www.infor.com/">
						<img class="logo"
						 src="<%=request.getContextPath()%>/images/infor_logo.gif"/>
					</a>
				</td>
			</tr>
			<tr class="topnavbox">
				<td class="topnavcell">
					<%=Messages.get("productname")%>
				</td>
			</tr>
			<tr>
				<td class="detail">
					<div class="detailname">
						<%=Messages.get("add_server_title", encodeHTML(action))%>
					</div>
					<form name="adding" method="post" onsubmit="return validateOnSubmit()" action="<%=request.getContextPath()%>/save_cp.jsp?org=<%=encodeURL(orgPage)%>">
					<span class="tableTitel"><%=Messages.get("config_label_identifier")%></span>
					<input type="hidden" name="envname" value="<%=encodeAttribute(envname)%>"/>
					<table class="list">
						<tr >
							<td class="row-left"><%=Messages.get("config_label_erp_server")%></td>
							<td class="tableRequired" id="tdname">*</td>
							<% if (action.equals(Messages.get("button_add"))) {%>
								<td class="inputText"><input type="text" id="name" name="name" size="30" value='<%=encodeAttribute(name)%>' onblur="validateIdentifier(this, 'inf_name');" onchange="validateIdentifier(this, 'inf_name');"/></td>
							<% } else {	%>
								<td class="inputText"><input type="text" id="name" name="name" readonly="readonly" size="30" value='<%=encodeAttribute(name)%>'/></td>
							<% } %>
							<td id="inf_name" class="inputerror">&nbsp;</td>
						</tr>
					</table>
					
					<span class="tableTitel"><%=Messages.get("config_label_server")%></span>
					<table class="list">
						<tr>
							<td class="row-left"><%=Messages.get("config_label_hostname")%></td>
							<td class="tableRequired" id="tdhostname">*</td>
							<td class="inputText"><input type="text" id="hostName" name="hostName" size="30" value='<%=encodeAttribute(hostName)%>' onblur="validateStringNotEmpty(this, 'inf_hostname');" onchange="validateStringNotEmpty(this, 'inf_hostname');"/></td>
							<td id="inf_hostname" class="inputerror">&nbsp;</td>
						</tr>
						<tr>
							<td class="row-left"><%=Messages.get("config_label_activation_type")%></td>
							<td class="tableRequired">&nbsp;</td>
							<%
								String noneSelected = "";
								String rexecSelected = "";
								String baanloginSelected = "";
								String baanloginsslSelected = "";
								if (activationType.equals("baanlogin"))
									baanloginSelected = "selected";
								else if (activationType.equals("rexec"))
									rexecSelected = "selected";
								else if (activationType.equals("baanlogin_ssl"))
									baanloginsslSelected = "selected";
								else
									noneSelected = "selected";
							%>
							<td class="inputText"><select id="activationType" name="activationType" onchange="Select()">
									<option <%=rexecSelected%> value="rexec"><%=Messages.get("config_option_rexec")%></option>
									<option <%=baanloginSelected%> value="baanlogin"><%=Messages.get("config_option_baanlogin")%></option>
									<option <%=baanloginsslSelected%> value="baanlogin_ssl"><%=Messages.get("config_option_baanlogin_ssl")%></option>
									<option <%=noneSelected%> value="none"><%=Messages.get("config_option_none")%></option>
								</select>
							</td>
							<td>&nbsp;</td>
						</tr>
						<tr>
							<td class="row-left"><%=Messages.get("config_label_port")%></td>
							<td class="tableRequired" id="tdport">&nbsp;</td>
							<td class="inputText"><input type="text" id="port" name="port" size="6" value='<%= portNumber %>' onblur="validateNumericNotEmpty(this, 'inf_port');" onchange="validateNumericNotEmpty(this, 'inf_port');"/></td>
							<td id="inf_port" class="inputerror">&nbsp;</td>
						</tr>
					</table>
					
					<span class="tableTitel"><%=Messages.get("config_label_activation")%></span>
					<table class="list">
						<tr>
							<td class="row-left"><%=Messages.get("config_label_user")%></td>
							<td class="tableRequired" id="tduser">&nbsp;</td>
							<td class="inputText"><input type="text" id="activationUser" name="activationUser" size="30" value='<%=encodeAttribute(user)%>'  onblur="validateActivationStringNotEmpty(this, 'inf_user');" onchange="validateActivationStringNotEmpty(this, 'inf_user');" /></td>
							<td id="inf_user" class="inputerror">&nbsp;</td>
						</tr>
						<tr>
							<td class="row-left"><%=Messages.get("config_label_password")%></td>
							<td class="tableRequired" id="tdpassword">&nbsp;</td>
							<td class="inputText"><input type="password" id="activationPassword" name="activationPassword" size="30" value='<%=encodeAttribute(password)%>' onblur="validatePasswordStringNotEmpty(this, 'inf_password');" onchange="validatePasswordStringNotEmpty(this, 'inf_password');" /></td>
							<td id="inf_password" class="inputerror">&nbsp;</td>
						</tr>
						<tr>
							<td class="row-left"><%=Messages.get("config_label_bse")%></td>
							<td class="tableRequired" id="tdbse">&nbsp;</td>
							<td class="inputText"><input type="text" id= "activationBse" name="activationBse" size="30" value='<%=encodeAttribute(bse)%>' onblur="validateActivationStringNotEmpty(this, 'inf_bse');" onchange="validateActivationStringNotEmpty(this, 'inf_bse');" /></td>
							<td id="inf_bse" class="inputerror">&nbsp;</td>
						</tr>
						<tr>
							<td class="row-left"><%=Messages.get("config_label_bshell")%></td>
							<td class="tableRequired" id="tdbshell">&nbsp;</td>
							<td class="inputText"><input type="text" id="activationBshell" name="activationBshell" size="30" value='<%=encodeAttribute(bshell)%>' onblur="validateActivationStringNotEmpty(this, 'inf_bshell');" onchange="validateActivationStringNotEmpty(this, 'inf_bshell');" /></td>
							<td id="inf_bshell" class="inputerror">&nbsp;</td>
						</tr>
						<tr>
							<td class="row-left"><%=Messages.get("config_label_environment")%></td>
							<td class="tableRequired">&nbsp;</td>
							<td class="inputText"><input type="text" id="activationEnvironment" name="activationEnvironment" size="30" value='<%=encodeAttribute(environment)%>'/></td>
							<td>&nbsp;</td>
						</tr>
						<tr>
							<td class="row-left"><%=Messages.get("config_label_company")%></td>
							<td class="tableRequired">&nbsp;</td>
							<td class="inputText"><input type="text" id="activationCompany" name="activationCompany" size="6" value='<%= company %>' onblur="validateActivationNumericRange(this, 'inf_company', 0, 9999);" onchange="validateActivationNumericRange(this, 'inf_company', 0, 9999);" /></td>
							<td id="inf_company" class="inputerror">&nbsp;</td>
						</tr>
						<tr>
							<td class="row-left"><%=Messages.get("config_label_max_connections")%></td>
							<td class="tableRequired" id="tdmaxconnections">&nbsp;</td>
							<td class="inputText"><input type="text" id="maxConnections" name="maxConnections" size="6" value='<%= maxConnections %>' onblur="validateActivationNumericNotEmpty(this, 'inf_maxConnections');" onchange="validateActivationNumericNotEmpty(this, 'inf_maxConnections');"/></td>
							<td id="inf_maxConnections" class="inputerror">&nbsp;</td>
						</tr>
						<tr>
							<td class="row-left"><%=Messages.get("config_label_max_references")%></td>
							<td class="tableRequired" id="tdmaxreferences">&nbsp;</td>
							<td class="inputText"><input type="text" id="maxReferences" name="maxReferences" size="6" value='<%= maxReferences %>' onblur="validateActivationNumericNotEmpty(this, 'inf_maxReferences');" onchange="validateActivationNumericNotEmpty(this, 'inf_maxReferences');"/></td>
							<td id="inf_maxReferences" class="inputerror">&nbsp;</td>
						</tr>
						<tr>
							<td class="row-left"><%=Messages.get("config_label_max_threads")%></td>
							<td class="tableRequired" id="tdmaxthreads">&nbsp;</td>
							<td class="inputText"><input type="text" id="maxThreads" name="maxThreads" size="6" value='<%= maxThreads %>' onblur="validateActivationSignedNumeric(this, 'inf_maxThreads');" onchange="validateActivationSignedNumeric(this, 'inf_maxThreads');"/></td>
							<td id="inf_maxThreads" class="inputerror">&nbsp;</td>
						</tr>
						<tr>
							<td class="row-left"><%=Messages.get("config_label_keep_alive")%></td>
							<td class="tableRequired" id="tdtimerdelay">&nbsp;</td>
							<td class="inputText"><input type="text" id="timerDelay" name="timerDelay" size="6" value='<%= timerDelay %>' onblur="validateActivationNumericRange(this, 'inf_timerDelay', 0, 2147483);" onchange="validateActivationNumericRange(this, 'inf_timerDelay', 0, 2147483);"/></td>
							<td id="inf_timerDelay" class="inputerror">&nbsp;</td>
						</tr>
						<tr>
							<td class="row-left"><%=Messages.get("config_label_options")%></td>
							<td class="tableRequired">&nbsp;</td>
							<%
								String traceChecked = "";
								if (daemonOptions.indexOf("-trace") >= 0)
								{
									traceChecked = "checked";
								}
							%>
							<td class="inputText"><input type="checkbox" <%=traceChecked%>  id="activationDaemonOptions" name="activationDaemonOptions" value="-trace"/><%=Messages.get("config_label_trace")%></td>
							<td>&nbsp;</td>
						</tr>
						<tr>
							<td class="row-left">&nbsp;</td>
							<td class="tableRequired">&nbsp;</td>
							<%
								String anonymousChecked = "";
								if (anonymousAllowed.equals("true"))
								{
									anonymousChecked = "checked";
								}
							%>
							<td class="inputText"><input type="checkbox" <%=anonymousChecked%>  id="anonymousAllowed" name="anonymousAllowed" value="true"/><%=Messages.get("config_label_allow_anonymous")%></td>
							<td>&nbsp;</td>
						</tr>
						<tr id="optionUpn" style="visibility:hidden;">
							<td class="row-left">&nbsp;</td>
							<td class="tableRequired">&nbsp;</td>
							<%
								String upnChecked = "";
								if (useUpn.equals("true"))
								{
									upnChecked = "checked";
								}
							%>
							<td class="inputText"><input type="checkbox" <%=upnChecked%>  id="useUpn" name="useUpn" value="true"/><%=Messages.get("config_label_use_upn")%></td>
							<td>&nbsp;</td>
						</tr>
						
					</table>
					<br /><br />
					<input type="submit" value="<%=encodeAttribute(action)%>" name="action"/>
					<input type="button" value="<%=Messages.get("button_cancel")%>" onclick="location.href='cp.jsp?org=<%=encodeURL(orgPage)%>'"/>
					</form>
				</td>
			</tr>
			<tr class="footerbox">
				<td class="footertext">
					<%=Messages.get("copyright")%>
				</td>
			</tr>
		</tbody>
	</table>
</body>
</html>