<%@ page language="java" session="false" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"  %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"  %>
<%@ page import="com.infor.erpln.soap.Messages" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"> 
<html>
	<head>
		<link rel="StyleSheet" href="<%=request.getContextPath()%>/css/wwwstyle.css" type="text/css"/>
		<title><%=Messages.get("productname")%> - <%=Messages.get("log_title")%></title>
		<script language="javascript" src="<%=request.getContextPath()%>/help.js"></script>
	</head>
	<body>
		<table>
			<tbody>
				<tr class="header">
					<td class="headertext">
						<a href="javascript:help('<%=request.getContextPath()%>/help/helplogconfiguration.jsp')">Help</a>
					</td>
				</tr>
				<tr class="logobox">
					<td class="logocell">
						<a href="http://www.infor.com/">
							<img class="logo"
							 src="<%=request.getContextPath()%>/images/infor_logo.gif"/>
						</a>
					</td>
				</tr>
				<tr class="topnavbox">
					<td class="topnavcell">
						<%=Messages.get("productname")%> 
					</td>
				</tr>
				<tr>
					<td class="detail">
						<div class="detailname">
							<%=Messages.get("log_title")%>
						</div>
						<br />
						<form method="post" action="">
							<table>
								<tr>
								<td><b><%=Messages.get("log_label_level")%> </b></td>
								</tr>
							 	<c:choose>
							        <c:when test='${logger.rootLogLevel == "ERROR"}'>
							            <c:set var="errorSelected" value="checked"/>
							        </c:when>
							        <c:when test='${logger.rootLogLevel == "INFO"}'>
							            <c:set var="infoSelected" value="checked"/>
							        </c:when>
							        <c:when test='${logger.rootLogLevel == "DEBUG"}'>
							            <c:set var="debugSelected" value="checked"/>
							        </c:when>
							    </c:choose> 	 
								<tr>
									<td><input type="radio" name="rootLogLevel" value="ERROR" ${errorSelected}/><%=Messages.get("log_option_error")%> </td>
								</tr>
								<tr>
									<td><input type="radio" name="rootLogLevel" value="INFO"  ${infoSelected}/><%=Messages.get("log_option_info")%> </td>
								</tr>
								<tr>
									<td><input type="radio" name="rootLogLevel" value="DEBUG" ${debugSelected}/><%=Messages.get("log_option_debug")%> </td>
								</tr>
							</table>
							<br />	
							<table>
								<tr>
									<td class="row-left-log"><b><%=Messages.get("log_label_file_location")%></b></td>
									<spring:bind path="logger.logFileLocation">
										<td class="inputText"><input type="text" size="80" name="logFileLocation" value="${ logger.logFileLocation }" ></input></td>
								 		<td class="errorValidation">
								 			<c:forEach var="errorMessage" items="${status.errorMessages}">
								        		${errorMessage}
								            </c:forEach>
								        </td>
								        <td>&nbsp;</td>
							 		</spring:bind>
						 		</tr>
								<tr>
									<td class="row-left-log"><b><%=Messages.get("log_label_max_file_size")%></b></td>
									<spring:bind path="logger.maxFileSize">
										<td class="inputText"><input type="text" size="5" name="maxFileSize" value="${ logger.maxFileSize }" ></input></td>
								 		<td class="errorValidation">
								 			<c:forEach var="errorMessage" items="${status.errorMessages}">
								        		${errorMessage}
								            </c:forEach>
								        </td>
								        <td>&nbsp;</td>
							 		</spring:bind>
						 		</tr>
								<tr>
									<td class="row-left-log"><b><%=Messages.get("log_label_max_backup_files")%></b></td>
									<spring:bind path="logger.fileBackups">
										<td class="inputText"><input type="text" size="5" name=fileBackups value="${ logger.fileBackups }" ></input></td>
								 		<td class="errorValidation">
								 			<c:forEach var="errorMessage" items="${status.errorMessages}">
								        		${errorMessage}
								            </c:forEach>
								        </td>
								        <td>&nbsp;</td>
							 		</spring:bind>
						 		</tr>
						    </table>
						    <br /><br />
						    <input type="submit" class="button" name="save" value=<%=Messages.get("button_ok")%> />
						    &nbsp;
						    <input type="button" value=<%=Messages.get("button_cancel")%> onclick="window.location='<%=request.getContextPath()%>/index.jsp'" />
						</form>
					</td>
				</tr>
				<tr class="footerbox">
					<td class="footertext">
						<%=Messages.get("copyright")%>
					</td>
				</tr>
			</tbody>
		</table>
	</body>
</html>