<#--
   ******************************************************
   *
   *                       NOTICE
   *
   *  THIS SOFTWARE IS THE PROPERTY OF AND CONTAINS
   *  CONFIDENTIAL INFORMATION OF SSA GLOBAL 
   *  TECHNOLOGIES, INC., AND SHALL NOT BE COPIED,
   *  USED, NOR DISCLOSED WITHOUT EXPRESS WRITTEN
   *  AUTHORIZATION.  ALTHOUGH PUBLICATION IS NOT
   *  INTENDED, IN THE EVENT OF PUBLICATION, THE
   *  FOLLOWING NOTICE IS APPLICABLE:
   *
   *  (c) COPYRIGHT 2005 SSA GLOBAL TECHNOLOGIES, INC.
   *
   *           SSA GLOBAL TECHNOLOGIES, INC.
   *
   ******************************************************
 -->

<#import "wsdl.common.ftl" as common/>

<#macro copyright>
<!-- 
   ******************************************************
   Copyright (c) 2008 Infor. All rights reserved. www.infor.com.
  
   Generated by: ${generatorname}
   ${generatorversion} 
 
   on ${today?datetime}. 
   Please: DO NOT EDIT THIS GENERATED SOURCE 
!-->
</#macro>

<#--
	Generates a BusinessObject complex type definition.

	@param	iBO			a IBusinessObjectMetadata object
-->
<#macro generateBusinessObject iBO>
		<xsd:complexType name="${iBO.typeName}">
			<xsd:sequence>
	<#list iBO.members as member>
		<#if !member.isAttribute()>
				<xsd:element name="${member.name}"<#if member.cardinalityMin==0 || allOptional> minOccurs="0"</#if><#if (member.cardinalityMax==-1)> maxOccurs="unbounded"</#if> type="${common.getDatatype(member.type)}"/>
		</#if>
	</#list>
			</xsd:sequence>
	<#list iBO.members as member>
		<#if member.isAttribute() && member.type.isPrimal() >
			<xsd:attribute name="${member.name}" type="${common.getDatatype(member.type)}"/>
		</#if>
	</#list>
		</xsd:complexType>
</#macro>

<#--
	Generates a list for the BusinessObject complex type.

	@param	iBO			a IBusinessObjectMetadata object
-->
<#macro generateIteratorBusinessObject iBO>
		<xsd:complexType name="${iBO.typeName}List">
			<xsd:sequence>
				<xsd:element name="${iBO.proxyName}" minOccurs="0" maxOccurs="unbounded" type="${common.getDatatype(iBO)}"/>
			</xsd:sequence>
		</xsd:complexType>
</#macro>
