<#--
   ******************************************************
   *
   *                       NOTICE
   *
   *  THIS SOFTWARE IS THE PROPERTY OF AND CONTAINS
   *  CONFIDENTIAL INFORMATION OF SSA GLOBAL 
   *  TECHNOLOGIES, INC., AND SHALL NOT BE COPIED,
   *  USED, NOR DISCLOSED WITHOUT EXPRESS WRITTEN
   *  AUTHORIZATION.  ALTHOUGH PUBLICATION IS NOT
   *  INTENDED, IN THE EVENT OF PUBLICATION, THE
   *  FOLLOWING NOTICE IS APPLICABLE:
   *
   *  (c) COPYRIGHT 2005 SSA GLOBAL TECHNOLOGIES, INC.
   *
   *           SSA GLOBAL TECHNOLOGIES, INC.
   *
   ******************************************************
 -->
<#import "wsdl.common.ftl" as common/>
<#import "wsdl.macros.ftl" as macro/>

<#assign businessInterfaceName=boiname>
<#assign namespace="http://www.infor.com/boi_interface/"+businessInterfaceName>
<@macro.copyright/>

<wsdl:definitions 
	xmlns:bo="${namespace}" 
	xmlns:soap="http://schemas.xmlsoap.org/wsdl/soap/" 
	xmlns:wsdl="http://schemas.xmlsoap.org/wsdl/" 
	xmlns:xsd="http://www.w3.org/2001/XMLSchema" 
	targetNamespace="${namespace}" 
	name="${businessInterfaceName}">

	<wsdl:types>
		<xsd:schema targetNamespace="${namespace}">
<#-- generate the used business objects -->
<#assign boList=common.getBusinessObjects()/>
<#list boList as bo>
	<@macro.generateBusinessObject iBO=bo/>
</#list>
<#-- generate the business object lists for iterator returns -->
<#assign boList=common.getIteratorBusinessObjects()/> 
<#list boList as bo>
	<@macro.generateIteratorBusinessObject iBO=bo/>
</#list>
<#-- generate generic types -->
			<xsd:simpleType name="char">
				<xsd:restriction base="xsd:string">
					<xsd:length value="1"/>
				</xsd:restriction>
			</xsd:simpleType>
			<xsd:element name="BoiException" type="xsd:string"/>
			<xsd:complexType name="ActivationType">
				<xsd:sequence>
					<xsd:element name="username" type="xsd:string" minOccurs="0"/>
					<xsd:element name="password" type="xsd:string" minOccurs="0"/>
					<xsd:element name="company" type="xsd:int" minOccurs="0"/>
				</xsd:sequence>
			</xsd:complexType>
			<xsd:element name="Activation" type="bo:ActivationType"/>
		</xsd:schema>	
	</wsdl:types>
	
<#-- generate messages -->
<#list metadata.methods as method>
	<#if common.isMethodValid(method)>
	<wsdl:message name="${method.name}Request">
		<#list method.parameters as parameter>
			<#if parameter.scope != "out">
		<wsdl:part name="${parameter.name}" type="${common.getDatatype(parameter.type)}"/>
			</#if>
		</#list>
	</wsdl:message>
	<wsdl:message name="${method.name}Response">
		<#if method.returnType.type.isIterator()>
		<wsdl:part name="${method.returnType.name}List" type="${common.getDatatype(method.returnType.type)}"/>
		<#else>
		<wsdl:part name="${method.returnType.name}" type="${common.getDatatype(method.returnType.type)}"/>
		</#if>
	</wsdl:message>
	</#if>
</#list>
	<wsdl:message name="BoiException">
		<wsdl:part name="BoiException" element="bo:BoiException"/>
	</wsdl:message>
	<wsdl:message name="Header">
		<wsdl:part name="Activation" element="bo:Activation"/>
	</wsdl:message>
	
<#-- generate portType and operations -->
	<wsdl:portType name="${businessInterfaceName}">
<#list metadata.methods as method>	
	<#if common.isMethodValid(method)>
		<wsdl:operation name="${method.name}">
			<wsdl:input message="bo:${method.name}Request"/>
			<wsdl:output message="bo:${method.name}Response"/>
			<wsdl:fault name="BoiException" message="bo:BoiException"/>
		</wsdl:operation>
	</#if>
</#list>
	</wsdl:portType>
	
<#-- generate bindings -->
	<wsdl:binding name="${businessInterfaceName}SoapBinding" type="bo:${businessInterfaceName}">
		<soap:binding style="rpc" transport="http://schemas.xmlsoap.org/soap/http"/>
<#list metadata.methods as method>	
	<#if common.isMethodValid(method)>
		<wsdl:operation name="${method.name}">
			<soap:operation soapAction=""/>						
			<wsdl:input>
				<soap:body use="literal" namespace="${namespace}"/>
				<soap:header message="bo:Header" part="Activation" use="literal"/>						
			</wsdl:input>
			<wsdl:output>
				<soap:body use="literal" namespace="${namespace}"/>
			</wsdl:output>
			<wsdl:fault name="BoiException">
				<soap:fault name="BoiException" use="literal"/>
			</wsdl:fault>
		</wsdl:operation>
	</#if>
</#list>
	</wsdl:binding>

<#-- generate services -->
	<wsdl:service name="${businessInterfaceName}Service">
		<wsdl:port name="${businessInterfaceName}SoapPort" binding="bo:${businessInterfaceName}SoapBinding">
			<soap:address location="http://localhost:8080/c4ws/services/${businessInterfaceName}/ConnectionPoint"/>
		</wsdl:port>
	</wsdl:service>
</wsdl:definitions>