<#--
	******************************************************
	*
	*                       NOTICE
	*
	*  THIS SOFTWARE IS THE PROPERTY OF AND CONTAINS
	*  CONFIDENTIAL INFORMATION OF INFOR INC., AND SHALL
	*  NOT BE COPIED, USED, NOR DISCLOSED WITHOUT EXPRESS 
	*  WRITTEN AUTHORIZATION. ALTHOUGH PUBLICATION IS NOT 
	*  INTENDED, IN THE EVENT OF PUBLICATION, THE FOLLOWING 
	*  NOTICE IS APPLICABLE:
	*
	*  (c) COPYRIGHT 2006 INFOR, INC.
	*
	******************************************************
 -->

<#--
	Returns a datatype string from an IObjectMetadata object.
	Simple types will return the xml schema type, like "xsd:string".
	Complex types will return the business object type, like "bo:com.eibus.test.regression.typesafe.Streets".
	
	@param		iDatatype		an IObjectMetadata object
	@return		a datatype string
-->
<#function getDatatype iDatatype>
	<#if iDatatype.isPrimal()>
		<#switch iDatatype.xmlDataType>
			<#case "string">
				<#return "xsd:string">
			<#case "i8">
				<#return "xsd:long">
			<#case "ui8">
				<#return "xsd:unsignedLong">
			<#case "i4">
			<#case "int">
			<#case "enumeration">
				<#return "xsd:int">
			<#case "ui4">
				<#return "xsd:unsignedInt">
			<#case "i2">
				<#return "xsd:short">
			<#case "ui2">
				<#return "xsd:unsignedShort">
			<#case "i1">
				<#return "xsd:byte">
			<#case "ui1">
				<#return "xsd:unsignedByte">
			<#case "r8">
				<#return "xsd:double">
			<#case "r4">
				<#return "xsd:float">
			<#case "boolean">
				<#return "xsd:boolean">
			<#case "time">
			<#case "time.tz">
				<#return "xsd:time">
			<#case "date">
				<#return "xsd:date">
			<#case "dateTime">
			<#case "dateTime.tz">
				<#return "xsd:dateTime">
			<#case "bin.base64">
				<#return "xsd:base64Binary">
			<#case "number">
				<#return "xsd:decimal">
			<#case "xml.node">
				<#return "xsd:string">
			<#case "char">
				<#return "bo:char">
			<#default>
				<#return "xsd:${iDatatype.xmlDataType}">
		</#switch>
	<#elseif iDatatype.isIterator()>
		<#return "bo:${iDatatype.businessObjectType.typeName}List">
	<#else>
		<#return "bo:${iDatatype.typeName}">		
	</#if>
</#function>

<#--
	Checks if a method is valid.
	This is used to filter the addList and addShow methods.
	Also methods without return value are filtered out.
	
	@param		iMethod		an IMethodMetadata object
	@return		boolean true is the method is valid, false if it should be skipped.
-->
<#function isMethodValid iMethod>
	<#if !iMethod.returnType?has_content>
		<#return false>
	</#if>
	<#if iMethod.name == "addList" || iMethod.name == "addShow">
		<#return false>
	</#if>
	<#return true>
</#function>

<#--
	Get a list of all used business objects.
	This list is used to generate the schema types.
	@return a sequence of business objects
-->
<#function getBusinessObjects>
	<#local boList=[]/>
	<#list metadata.methods as method>
		<#if isMethodValid(method)>
			<#-- add all complex parameters -->
			<#list method.parameters as parameter>
				<#if !parameter.type.isPrimal()>
					<#local boList=common.addBO(boList, parameter.type)/>
				</#if>
			</#list>
			<#-- add the return object -->
			<#local returnType=method.returnType.type/>
			<#if returnType.isIterator()>
				<#local boList=common.addBO(boList, returnType.businessObjectType)/>
			<#elseif !returnType.isPrimal()>
				<#local boList=common.addBO(boList, returnType)/>
			</#if>
		</#if>
	</#list>
	<#return boList>
</#function>

<#--
	Get a list of all iterator business objects.
	This list is used to generate the schema types.
	@return a sequence of iterator business objects
-->
<#function getIteratorBusinessObjects>
	<#local iboList=[]/>
	<#list metadata.methods as method>
		<#if isMethodValid(method)>
			<#-- check the return type -->
			<#local returnType=method.returnType.type/>
			<#if returnType.isIterator()>
				<#if iboList?seq_contains(returnType.businessObjectType)>
					<#-- Already in the list -->
				<#else>
					<#local iboList=iboList+[returnType.businessObjectType]>
				</#if>
			</#if>
		</#if>
	</#list>
	<#return iboList>
</#function>


<#--
	Add a business object to the list of business objects.
	Doesn't do anything if the business object is already in the list.
	Recursively adds all members that are business objects.
	
	@param	iBOList		The sequence of business objects.
	@param	iBO			The business object (IBusinessObjectMetadata) to be added.
	@return The new sequence
-->
<#function addBO iBOList iBO>
	<#if iBOList?seq_contains(iBO)>
		<#-- Already in the list -->
	<#else>
		<#local iBOList=iBOList+[iBO]>
		<#list iBO.members as member>
			<#assign type = member.type>
			<#if type.isPrimal()>
				<#-- Nothing to do for primal types -->
			<#elseif type.isIterator()>
				<#local iBOList=addBO(iBOList, type.businessObjectType)/>
			<#else>
				<#local iBOList=addBO(iBOList, type)/>
			</#if>
		</#list>
	</#if>
	<#return iBOList>
</#function>
