/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.soap.servlet;

import com.infor.erpln.c4ws.util.C4WSPropertiesManager;
import com.infor.erpln.soap.DeploymentDescriptor;
import com.infor.erpln.soap.Endpoint;
import com.infor.erpln.soap.Messages;
import com.infor.erpln.soap.conversion.MessageConverter;
import com.infor.erpln.soap.servlet.ServletAdapter;
import com.infor.erpln.soap.servlet.ServletUtils;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.resources.WsservletMessages;
import com.sun.xml.ws.util.exception.JAXWSExceptionBase;
import com.sun.xml.ws.util.localization.Localizable;
import com.sun.xml.ws.util.localization.LocalizableMessageFactory;
import com.sun.xml.ws.util.localization.Localizer;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.MimeHeaders;
import javax.xml.ws.http.HTTPBinding;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Encoder;

public final class WSServletDelegate {
    private List<ServletAdapter> adapters;
    private final ServletContext context;
    private final Map<String, ServletAdapter> fixedUrlPatternEndpoints = new HashMap();
    private final List<ServletAdapter> pathUrlPatternEndpoints = new ArrayList();
    private final Map<Locale, Localizer> localizerMap = new HashMap();
    private boolean publishStatusPage;
    private Encoder encoder = ESAPI.encoder();
    private static final Localizer defaultLocalizer = new Localizer();
    private static final LocalizableMessageFactory messageFactory = new LocalizableMessageFactory("com.sun.xml.ws.resources.wsservlet");
    private static final Logger logger = Logger.getLogger("javax.enterprise.resource.webservices.jaxws.servlet.http");

    public WSServletDelegate(List<ServletAdapter> adapters, ServletContext context) {
        String publishStatusPageParam;
        this.adapters = adapters;
        this.context = context;
        for (ServletAdapter info : adapters) {
            this.registerEndpointUrlPattern(info);
        }
        this.localizerMap.put(defaultLocalizer.getLocale(), defaultLocalizer);
        if (logger.isLoggable(Level.INFO)) {
            logger.info(WsservletMessages.SERVLET_INFO_INITIALIZE());
        }
        this.publishStatusPage = (publishStatusPageParam = context.getInitParameter("com.sun.xml.ws.server.http.publishStatusPage")) == null || Boolean.parseBoolean(publishStatusPageParam);
    }

    public void destroy() {
        if (logger.isLoggable(Level.INFO)) {
            logger.info(WsservletMessages.SERVLET_INFO_DESTROY());
        }
        for (ServletAdapter a : this.adapters) {
            try {
                a.getEndpoint().dispose();
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    public void reloadAdapters(List<ServletAdapter> adapters) {
        this.destroy();
        this.fixedUrlPatternEndpoints.clear();
        this.pathUrlPatternEndpoints.clear();
        this.adapters = adapters;
        for (ServletAdapter info : adapters) {
            this.registerEndpointUrlPattern(info);
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info(WsservletMessages.SERVLET_INFO_INITIALIZE());
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response, ServletContext context) throws ServletException {
        try {
            ServletAdapter target = this.getTarget(request);
            if (target != null) {
                String query = request.getQueryString();
                if (target.isMetadataQuery(query)) {
                    target.publishWSDL(context, request, response);
                    return;
                }
                WSBinding binding = target.getEndpoint().getBinding();
                if (binding instanceof HTTPBinding) {
                    target.handle(context, request, response);
                } else {
                    this.writeWebServicesHtmlPage(request, response);
                }
            } else {
                this.writeWebServicesHtmlPage(request, response);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw new ServletException(e.getMessage());
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response, ServletContext context) {
        try {
            ServletAdapter target = this.getTarget(request);
            if (target != null) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(WsservletMessages.SERVLET_TRACE_GOT_REQUEST_FOR_ENDPOINT((Object)target.name));
                }
            } else {
                Localizer localizer = this.getLocalizerFor((ServletRequest)request);
                this.writeNotFoundErrorPage(localizer, response, "Invalid request");
                return;
            }
            target.handle(context, request, response);
        }
        catch (JAXWSExceptionBase e) {
            logger.log(Level.SEVERE, defaultLocalizer.localize((Localizable)e), e);
            response.setStatus(500);
        }
        catch (Throwable e) {
            if (e instanceof Localizable) {
                logger.log(Level.SEVERE, defaultLocalizer.localize((Localizable)e), e);
            } else {
                logger.log(Level.SEVERE, "caught throwable", e);
            }
            response.setStatus(500);
        }
    }

    public void doPut(HttpServletRequest request, HttpServletResponse response, ServletContext context) throws ServletException {
        try {
            ServletAdapter target = this.getTarget(request);
            if (target != null) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(WsservletMessages.SERVLET_TRACE_GOT_REQUEST_FOR_ENDPOINT((Object)target.name));
                }
            } else {
                Localizer localizer = this.getLocalizerFor((ServletRequest)request);
                this.writeNotFoundErrorPage(localizer, response, "Invalid request");
                return;
            }
            WSBinding binding = target.getEndpoint().getBinding();
            if (binding instanceof HTTPBinding) {
                target.handle(context, request, response);
            } else {
                response.setStatus(405);
            }
        }
        catch (JAXWSExceptionBase e) {
            logger.log(Level.SEVERE, defaultLocalizer.localize((Localizable)e), e);
            response.setStatus(500);
        }
        catch (Throwable e) {
            if (e instanceof Localizable) {
                logger.log(Level.SEVERE, defaultLocalizer.localize((Localizable)e), e);
            } else {
                logger.log(Level.SEVERE, "caught throwable", e);
            }
            response.setStatus(500);
        }
    }

    public void doDelete(HttpServletRequest request, HttpServletResponse response, ServletContext context) throws ServletException {
        this.doPut(request, response, context);
    }

    protected void writeNotFoundErrorPage(Localizer localizer, HttpServletResponse response, String message) throws IOException {
        response.setStatus(404);
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        out.println("<html>");
        out.println("<head><title>");
        out.println(WsservletMessages.SERVLET_HTML_TITLE());
        out.println("</title></head>");
        out.println("<body>");
        out.println(WsservletMessages.SERVLET_HTML_NOT_FOUND((Object)message));
        out.println("</body>");
        out.println("</html>");
    }

    protected void warnMissingContextInformation() {
        logger.warning(WsservletMessages.SERVLET_WARNING_MISSING_CONTEXT_INFORMATION());
    }

    protected static MimeHeaders getHeaders(HttpServletRequest req) {
        Enumeration enums = req.getHeaderNames();
        MimeHeaders headers = new MimeHeaders();
        while (enums.hasMoreElements()) {
            String headerName = (String)enums.nextElement();
            String headerValue = req.getHeader(headerName);
            headers.addHeader(headerName, headerValue);
        }
        return headers;
    }

    private void registerEndpointUrlPattern(ServletAdapter a) {
        String urlPattern = a.urlPattern;
        if (urlPattern.indexOf("*.") != -1) {
            logger.warning(WsservletMessages.SERVLET_WARNING_IGNORING_IMPLICIT_URL_PATTERN((Object)a.name));
        } else if (urlPattern.endsWith("/*")) {
            this.pathUrlPatternEndpoints.add(a);
        } else if (this.fixedUrlPatternEndpoints.containsKey(urlPattern)) {
            logger.warning(WsservletMessages.SERVLET_WARNING_DUPLICATE_ENDPOINT_URL_PATTERN((Object)a.name));
        } else {
            this.fixedUrlPatternEndpoints.put(urlPattern, a);
        }
    }

    protected ServletAdapter getTarget(HttpServletRequest request) {
        String path = request.getRequestURI().substring(request.getContextPath().length());
        ServletAdapter result = (ServletAdapter)this.fixedUrlPatternEndpoints.get(path);
        if (result == null) {
            for (ServletAdapter candidate : this.pathUrlPatternEndpoints) {
                String noSlashStar = candidate.getValidPath();
                if (!path.equals(noSlashStar) && !path.startsWith(noSlashStar + "/") && !path.startsWith(noSlashStar + "?")) continue;
                result = candidate;
                break;
            }
        }
        return result;
    }

    protected boolean checkContentType(MimeHeaders headers) {
        String[] contentTypes = headers.getHeader("Content-Type");
        return contentTypes != null && contentTypes.length >= 1 && contentTypes[0].indexOf("text/xml") != -1;
    }

    protected boolean checkContentLength(MimeHeaders headers) {
        int length;
        String[] contentLength = headers.getHeader("Content-Length");
        return contentLength != null && contentLength.length > 0 && (length = Integer.parseInt(contentLength[0])) > 0;
    }

    boolean checkForContent(MimeHeaders headers) {
        return this.checkContentType(headers) && this.checkContentLength(headers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Localizer getLocalizerFor(ServletRequest request) {
        Locale locale = request.getLocale();
        if (locale.equals(defaultLocalizer.getLocale())) {
            return defaultLocalizer;
        }
        Map map = this.localizerMap;
        synchronized (map) {
            Localizer localizer = (Localizer)this.localizerMap.get(locale);
            if (localizer == null) {
                localizer = new Localizer(locale);
                this.localizerMap.put(locale, localizer);
            }
            return localizer;
        }
    }

    private ServletAdapter getAdapter(String name) {
        for (ServletAdapter a : this.adapters) {
            if (!a.name.equals(name)) continue;
            return a;
        }
        return null;
    }

    private void writeWebServicesHtmlPage(HttpServletRequest request, HttpServletResponse response) throws IOException {
        boolean includeOpenAPIColumn = false;
        try {
            C4WSPropertiesManager manager = (C4WSPropertiesManager)this.context.getAttribute("com.infor.erpln.c4ws.util.C4WSPropertiesManager");
            includeOpenAPIColumn = manager.getProperties().isJsonSupported();
        }
        catch (Exception manager) {
            // empty catch block
        }
        if (this.publishStatusPage) {
            PrintWriter out;
            block28: {
                String query = request.getQueryString();
                boolean noRefresh = query != null && query.toLowerCase().contains("norefresh");
                String baseAddress = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
                response.setStatus(200);
                response.setContentType("text/html");
                out = response.getWriter();
                out.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">");
                out.println("<html xmlns='http://www.w3.org/1999/xhtml'>");
                out.println("<head>");
                out.println("<title>" + Messages.get((String)"productname") + " - Status</title>");
                out.println("<link href='" + baseAddress + "/css/wwwstyle.css' type='text/css' rel='stylesheet'/>");
                if (!noRefresh) {
                    out.println("<meta http-equiv='refresh' content='15'>");
                }
                out.println("<script language='javascript' src='help.js'></script>");
                out.println("</head>");
                out.println("<body>");
                out.println("<table>");
                out.println("<tbody>");
                out.print("   <tr class='header'><td class='headertext'><a href='" + baseAddress + "/services");
                if (noRefresh) {
                    out.print("'>Enable");
                } else {
                    out.print("?norefresh'>Disable");
                }
                out.println(" Auto-Refresh</a>");
                out.println("       <span style='display:inline-block; width:30px;'></span>");
                out.println("       <a href='javascript:help(\"help/helpstatus.jsp\")'>Help</a></td></tr>");
                out.println("\t<tr class='logobox'>");
                out.println("\t\t<td class='logocell'>");
                out.println("\t\t\t<a href='http://www.infor.com/'><img class='logo' src='" + baseAddress + "/images/infor_logo.gif'/></a>");
                out.println("\t\t</td>");
                out.println("\t</tr>");
                out.println("\t<tr class='topnavbox'>");
                out.println("\t\t<td class='topnavcell'>");
                out.println(Messages.get((String)"productname"));
                out.println("\t\t</td>");
                out.println("\t</tr>");
                out.println("\t<tr>");
                out.println("\t\t<td class='detail'>");
                out.println("\t\t\t<div class='detailname'>");
                out.println(Messages.get((String)"status_title"));
                out.println("\t\t\t</div>");
                try {
                    DeploymentDescriptor desc = new DeploymentDescriptor(this.context);
                    Endpoint[] endpoints = desc.listEndpoints();
                    if (endpoints.length == 0 || ServletUtils.getC4WSProperties().isCloudEnabled()) {
                        out.println("<p>There are no deployed web services.</p>");
                        break block28;
                    }
                    out.println("<table class='list'>");
                    out.println("<tr>");
                    out.println("\t<td>Service name</td>");
                    out.println("\t<td>Type</td>");
                    out.println("\t<td>ERP Server</td>");
                    out.println("\t<td>Status</td>");
                    out.println("\t<td>Requests</td>");
                    out.println("\t<td>WSDL</td>");
                    if (includeOpenAPIColumn) {
                        out.println("   <td>OpenAPI</td>");
                    }
                    out.println("\t<td>Address</td>");
                    out.println("</tr>");
                    boolean restartRequired = false;
                    ArrayList runningAdapters = new ArrayList(this.adapters);
                    for (Endpoint endpoint : endpoints) {
                        String name = endpoint.getName();
                        out.println("<tr class='listitem'>");
                        out.println("\t<td>" + this.encoder.encodeForHTML(name) + "</td>");
                        out.println("\t<td>" + this.encoder.encodeForHTML(endpoint.getType()) + "</td>");
                        String connectionPoint = this.encoder.encodeForHTML(endpoint.getConnectionPoint());
                        out.println("\t<td>" + connectionPoint + "</td>");
                        String endpointAddress = baseAddress;
                        ServletAdapter adapter = this.getAdapter(name);
                        if (adapter != null) {
                            endpointAddress = endpointAddress + adapter.getValidPath();
                            String wsdlPath = this.context.getRealPath("/" + endpoint.getWsdlFileName());
                            File wsdlFile = new File(wsdlPath);
                            if (wsdlFile.exists()) {
                                out.println("\t<td>ACTIVE</td>");
                                out.println("\t<td>" + adapter.getCount() + "</td>");
                                out.println("\t<td><a href='" + endpointAddress + "?wsdl'>WSDL</a></td>");
                            } else {
                                out.println("\t<td><font color='#FF0000'>NO WSDL</font></td>");
                                out.println("\t<td>" + adapter.getCount() + "</td>");
                                out.println("\t<td>&nbsp;</td>");
                            }
                            if (includeOpenAPIColumn) {
                                if ("BDE".equals(endpoint.getType())) {
                                    String bdeName = this.encoder.encodeForHTML(MessageConverter.getBdeName((String)name));
                                    String swaggerUiAddress = baseAddress + "/apidoc/rest/" + bdeName + "/" + connectionPoint;
                                    out.println("    <td><a href='" + swaggerUiAddress + "' target='_blank'>OpenAPI</a></td>");
                                } else {
                                    out.println("   <td>&nbsp;</td>");
                                }
                            }
                            runningAdapters.remove(adapter);
                        } else {
                            endpointAddress = endpointAddress + endpoint.getPattern();
                            out.println("\t<td><font color='#FF0000'>NOT ACTIVE</font></td>");
                            out.println("\t<td>0</td>");
                            out.println("\t<td>WSDL</td>");
                            if (includeOpenAPIColumn) {
                                out.println("\t<td>&nbsp;</td>");
                            }
                            restartRequired = true;
                        }
                        out.println("\t<td>" + this.encoder.encodeForHTML(endpointAddress) + "</td>");
                        out.println("</tr>");
                    }
                    for (ServletAdapter adapter : runningAdapters) {
                        String endpointAddress = baseAddress + adapter.getValidPath();
                        String erpServer = endpointAddress;
                        int index = erpServer.lastIndexOf(47);
                        if (index > 0) {
                            erpServer = erpServer.substring(index + 1);
                        }
                        String type = "?";
                        try {
                            String namespace = adapter.getEndpoint().getServiceName().getNamespaceURI();
                            if (namespace.startsWith("http://www.infor.com/businessinterface/")) {
                                type = "BDE";
                            } else if (namespace.startsWith("http://www.infor.com/boi_interface/")) {
                                type = "BOI";
                            }
                        }
                        catch (RuntimeException runtimeException) {
                            // empty catch block
                        }
                        out.println("<tr class='listitem'>");
                        out.println("\t<td>" + adapter.name + "</td>");
                        out.println("\t<td>" + type + "</td>");
                        out.println("\t<td>" + erpServer + "</td>");
                        out.println("\t<td><font color='#FF0000'>STILL ACTIVE</font></td>");
                        out.println("\t<td>" + adapter.getCount() + "</td>");
                        out.println("\t<td>WSDL</td>");
                        if (includeOpenAPIColumn) {
                            out.println("\t<td>&nbsp;</td>");
                        }
                        out.println("\t<td>" + endpointAddress + "</td>");
                        out.println("</tr>");
                        restartRequired = true;
                    }
                    out.println("</table>");
                    if (restartRequired) {
                        out.println("<p>You need to restart the servlet container (Tomcat) to activate all services.</p>");
                    }
                }
                catch (Exception ex) {
                    logger.severe("Could not retrieve deployed services: " + ex.getMessage());
                    out.println("<p><font color='#FF0000'>An error occured while retrieving the list of deployed web services.");
                    out.println("(See log file for details.)</font></p>");
                }
            }
            out.println("\t\t</td>");
            out.println("\t</tr>");
            out.println("\t<tr>");
            out.println("\t\t<td class='detail'>");
            out.println("\t\t\t<input type='button' value='Back' name='ButtonBack' onclick=\"location.href='index.jsp'\"/>");
            out.println("\t\t</td>");
            out.println("\t</tr>");
            out.println("\t<tr class='footerbox'>");
            out.println("\t\t<td class='footertext'>");
            out.println(Messages.get((String)"copyright"));
            out.println("\t\t</td>");
            out.println("\t</tr>");
            out.println("</tbody>");
            out.println("</table>");
            out.println("</body>");
            out.println("</html>");
        }
    }
}

