/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.soap.servlet;

import com.infor.erpln.c4ws.util.C4WSProperties;
import com.infor.erpln.c4ws.util.C4WSPropertiesManager;
import com.infor.erpln.c4ws.util.MigrationUtil;
import com.infor.erpln.c4ws.util.oauth.Authenticator;
import com.infor.erpln.ir.connector.caching.RetentionMap;
import com.infor.erpln.ir.connector.connection.RetentionCacheChecker;
import com.infor.erpln.ir.connector.reportserver.cognos.CognosReportServer;
import com.infor.erpln.jca.ConnectionFactoryImpl;
import com.infor.erpln.jca.ConnectionImpl;
import com.infor.erpln.soap.AdditionalSettings;
import com.infor.erpln.soap.DeploymentDescriptor;
import com.infor.erpln.soap.boi.BoiExplorer;
import com.infor.erpln.soap.servlet.ServletAdapter;
import com.infor.erpln.soap.servlet.ServletAdapterList;
import com.infor.erpln.soap.servlet.ServletResourceLoader;
import com.infor.erpln.soap.servlet.ServletUtils;
import com.infor.erpln.soap.servlet.WSServletContextListener;
import com.infor.erpln.soap.servlet.WSServletDelegate;
import com.infor.erpln.soap.servlet.WSServletException;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.resources.WsservletMessages;
import com.sun.xml.ws.transport.http.DeploymentDescriptorParser;
import com.sun.xml.ws.transport.http.ResourceLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.owasp.esapi.ESAPI;
import org.springframework.util.Log4jConfigurer;

public final class WSServletContextListener
implements ServletContextAttributeListener,
ServletContextListener {
    private WSServletDelegate delegate;
    private ConnectionFactoryImpl connectionFactory;
    private ServletContext context;
    private Thread fileChangeWatchdog;
    private static final String CONNECTIONPOINTSFILE = "connectionpoints.xml";
    public static final String CONNECTION_FACTORY = "com.infor.erpln.soap.connectionFactory";
    public static final String SERVLET_CONTEXT_LISTENER = "com.infor.erpln.soap.servlet.contextListener";
    public static final String C4WS_PROPERTIES_MANAGER = "com.infor.erpln.c4ws.util.C4WSPropertiesManager";
    public static final String OAUTH1_AUTHENTICATOR = "com.infor.erpln.util.oauth.Authenticator";
    private static final String LOG4J_CONFIG_LOCATION = "log4jConfigLocation";
    private static final String DTD_RESOURCE = "/WEB-INF/log4j.dtd";
    private static final String TEMPLATE_RESOURCE = "log4jtemplate.xml";
    private static final String LOG4J_XML = "log4j.xml";
    private static final String LOG4J_DTD = "log4j.dtd";
    private static final String UTF_8 = "UTF-8";
    private static final String LOGDIR_PLACEHOLDER = "##LOGDIR##";
    private static final String JAXWS_RI_RUNTIME = "/WEB-INF/sun-jaxws.xml";
    private static final Logger logger = Logger.getLogger("javax.enterprise.resource.webservices.jaxws.server.http");

    public void attributeAdded(ServletContextAttributeEvent event) {
    }

    public void attributeRemoved(ServletContextAttributeEvent event) {
    }

    public void attributeReplaced(ServletContextAttributeEvent event) {
    }

    public void contextDestroyed(ServletContextEvent event) {
        this.fileChangeWatchdog.interrupt();
        ((C4WSPropertiesManager)this.context.getAttribute(C4WS_PROPERTIES_MANAGER)).stopFileChangeWatchdog();
        Hashtable bshellConnections = (Hashtable)this.context.getAttribute("bshellConnections");
        Timer timer = (Timer)this.context.getAttribute("scheduledTasks");
        String destinationLocation = (String)this.context.getAttribute("com.infor.erpln.ir.dataFolder");
        timer.cancel();
        logger.info("IsAliveTask timer cancelled.");
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Going to destroy " + bshellConnections.size() + " connections from BSHELL connectionpool!");
        }
        int count = 0;
        Iterator i = bshellConnections.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            ++count;
            String connectionName = this.removeCRLF((String)entry.getKey());
            if (!ESAPI.validator().isValidInput("Connection name", connectionName, "JCAConnectionID", 1000, false)) {
                connectionName = String.valueOf(count);
            }
            try {
                ((ConnectionImpl)entry.getValue()).close();
                logger.info(String.format("Connection '%s' closed.", connectionName));
            }
            catch (ResourceException re) {
                logger.log(Level.SEVERE, String.format("Unable to close connection '%s'.", connectionName), re);
            }
            i.remove();
        }
        RetentionMap dataFileCache = (RetentionMap)this.context.getAttribute("datafiles");
        RetentionCacheChecker rcc = new RetentionCacheChecker(dataFileCache, destinationLocation);
        try {
            rcc.cleanTemporaryObjects(0L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.delegate != null) {
            this.delegate.destroy();
        }
        if (this.connectionFactory != null) {
            this.connectionFactory.destroy();
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info(WsservletMessages.LISTENER_INFO_DESTROY());
        }
    }

    private String removeCRLF(String str) {
        return StringUtils.replaceChars((String)str, (String)"\r\n", (String)"");
    }

    public void contextInitialized(ServletContextEvent event) {
        if (logger.isLoggable(Level.INFO)) {
            logger.info(WsservletMessages.LISTENER_INFO_INITIALIZE());
        }
        System.setProperty("com.sun.xml.ws.fault.SOAPFaultBuilder.disableCaptureStackTrace", "false");
        this.context = event.getServletContext();
        ServletUtils.init((ServletContext)this.context);
        this.context.setAttribute("bshellConnections", new Hashtable());
        this.context.setAttribute("scheduledTasks", (Object)new Timer());
        logger.info("Created the BSHELL connectionpool!");
        this.context.setAttribute("datafiles", (Object)new RetentionMap());
        logger.info("Created the datafile cache!");
        this.context.setAttribute(SERVLET_CONTEXT_LISTENER, (Object)this);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        ServletContainer container = new ServletContainer(this.context);
        try {
            String consumerKey;
            C4WSPropertiesManager propManager = new C4WSPropertiesManager(this.context);
            this.context.setAttribute(C4WS_PROPERTIES_MANAGER, (Object)propManager);
            propManager.updateProperties();
            CognosReportServer.setPropManager((C4WSPropertiesManager)propManager);
            C4WSProperties c4wsProperties = propManager.getProperties();
            String log4jConfigLocation = this.context.getInitParameter(LOG4J_CONFIG_LOCATION);
            if (log4jConfigLocation == null) {
                logger.info("No 'log4jConfigLocation' init-parameter found -- using default value.");
                log4jConfigLocation = new File(c4wsProperties.getConfigFolder(), LOG4J_XML).toURI().toString();
                this.copyLog4jConfigFiles(c4wsProperties.getConfigFolder());
                try {
                    Log4jConfigurer.initLogging((String)log4jConfigLocation);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.context.setAttribute(LOG4J_CONFIG_LOCATION, (Object)log4jConfigLocation);
            this.monitorLogConfiguration(log4jConfigLocation);
            DeploymentDescriptor desc = new DeploymentDescriptor(this.context);
            String filename = desc.getFilename();
            desc.checkWSDL();
            DeploymentDescriptorParser parser = this.createDeploymentDescriptorParser(classLoader, new ServletResourceLoader(this.context), container, new ServletAdapterList());
            FileInputStream is = new FileInputStream(filename);
            List adapters = parser.parse(filename, (InputStream)is);
            this.delegate = new WSServletDelegate(adapters, this.context);
            this.context.setAttribute("com.sun.xml.ws.server.http.servletDelegate", (Object)this.delegate);
            if (!c4wsProperties.isCloudEnabled()) {
                BoiExplorer boiExplorer = BoiExplorer.getInstance();
                boiExplorer.initialize(this.context);
            }
            this.connectionFactory = new ConnectionFactoryImpl();
            String configLocation = c4wsProperties.getConfigFolder();
            if (configLocation == null) {
                configLocation = this.context.getRealPath("/WEB-INF");
            }
            if (!configLocation.endsWith(File.separator)) {
                configLocation = configLocation + File.separator;
            }
            this.context.setAttribute(CONNECTION_FACTORY, (Object)this.connectionFactory);
            AdditionalSettings.initialize((String)configLocation);
            String storePath = c4wsProperties.getKeyStorePath();
            String storePassword = c4wsProperties.getKeyStorePassword();
            if (storePath != null) {
                this.connectionFactory.setKeyStore(storePath, storePassword);
                this.connectionFactory.setTrustStore(storePath, storePassword);
            }
            if ((consumerKey = c4wsProperties.getConsumerKey()) != null) {
                this.context.setAttribute(OAUTH1_AUTHENTICATOR, (Object)Authenticator.getInstance((String)consumerKey, (String)c4wsProperties.getConsumerSecret()));
            }
            MigrationUtil.migrateConnectionpoints((C4WSPropertiesManager)propManager);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, WsservletMessages.LISTENER_PARSING_FAILED((Object)e), e);
            this.context.removeAttribute("com.sun.xml.ws.server.http.servletDelegate");
            throw new WSServletException("listener.parsingFailed", new Object[]{e});
        }
    }

    private void monitorLogConfiguration(String log4jConfigLocation) {
        try {
            File configFile = new File(new URI(log4jConfigLocation));
            long CHECK_INTERVAL = 60000L;
            this.fileChangeWatchdog = new /* Unavailable Anonymous Inner Class!! */;
            this.fileChangeWatchdog.setDaemon(true);
            this.fileChangeWatchdog.start();
        }
        catch (URISyntaxException e) {
            logger.log(Level.SEVERE, "Log4j config file is not being watched for changes.");
        }
    }

    public void reload(ServletContext context) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        ServletContainer container = new ServletContainer(context);
        try {
            DeploymentDescriptor desc = new DeploymentDescriptor(context);
            String filename = desc.getFilename();
            DeploymentDescriptorParser parser = this.createDeploymentDescriptorParser(classLoader, new ServletResourceLoader(context), container, new ServletAdapterList());
            FileInputStream is = new FileInputStream(filename);
            List adapters = parser.parse(filename, (InputStream)is);
            this.delegate.reloadAdapters(adapters);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, WsservletMessages.LISTENER_PARSING_FAILED((Object)e), e);
            context.removeAttribute("com.sun.xml.ws.server.http.servletDelegate");
            throw new WSServletException("listener.parsingFailed", new Object[]{e});
        }
    }

    private DeploymentDescriptorParser<ServletAdapter> createDeploymentDescriptorParser(ClassLoader classLoader, ServletResourceLoader resourceLoader, ServletContainer container, ServletAdapterList adapterList) throws Exception {
        DeploymentDescriptorParser parser = null;
        int remainingAttempts = 10;
        while (parser == null && remainingAttempts > 0) {
            try {
                parser = new DeploymentDescriptorParser(classLoader, (ResourceLoader)resourceLoader, (Container)container, (DeploymentDescriptorParser.AdapterFactory)adapterList);
            }
            catch (Exception ex) {
                --remainingAttempts;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (parser == null) {
            throw new Exception("Unable to instantiate a DeploymentDescriptorParser");
        }
        return parser;
    }

    private void copyLog4jConfigFiles(String destinationFolder) {
        File xmlFile;
        File dtdFile = new File(destinationFolder, LOG4J_DTD);
        if (!dtdFile.exists()) {
            try (InputStream source = this.context.getResourceAsStream(DTD_RESOURCE);){
                if (source != null) {
                    FileUtils.copyInputStreamToFile((InputStream)source, (File)dtdFile);
                    logger.info("Copied 'log4j.dtd' to configuration folder.");
                }
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "Unable to copy 'log4j.dtd' file.", ex);
            }
        }
        if (!(xmlFile = new File(destinationFolder, LOG4J_XML)).exists()) {
            try (InputStream inputStream = this.getClass().getResourceAsStream(TEMPLATE_RESOURCE);){
                if (inputStream != null) {
                    String contents = IOUtils.toString((InputStream)inputStream, (String)UTF_8);
                    contents = contents.replace(LOGDIR_PLACEHOLDER, this.defaultLogFileDir());
                    FileUtils.writeStringToFile((File)xmlFile, (String)contents, (String)UTF_8);
                    logger.info("Copied 'log4j.xml' to configuration folder.");
                }
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "Unable to copy 'log4j.xml' file.", ex);
            }
        }
    }

    private String defaultLogFileDir() {
        try {
            if (System.getProperty("catalina.base") != null) {
                return "${catalina.base}/logs";
            }
            if (System.getProperty("jboss.server.log.dir") != null) {
                return "${jboss.server.log.dir}";
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return "${java.io.tmpdir}";
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }
}

