/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.soap.servlet;

import com.infor.erpln.soap.servlet.URLCorrectionFilter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;

public class URLCorrectionFilter
implements Filter {
    private static final Logger LOG = ESAPI.getLogger(URLCorrectionFilter.class);
    private static Set<String> validStartSegments = new HashSet();

    public void init(FilterConfig filterConfig) throws ServletException {
        String validSegments = filterConfig.getInitParameter("validStartSegments");
        if (validSegments != null) {
            String[] segmentArray;
            for (String segment : segmentArray = StringUtils.split((String)validSegments)) {
                validStartSegments.add(segment);
            }
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest;
        RequestPath requestPath;
        if (request instanceof HttpServletRequest && !(requestPath = new RequestPath(httpRequest = (HttpServletRequest)request)).isValid()) {
            String correctedPath = requestPath.getCorrectedPathInfo();
            if (LOG.isDebugEnabled()) {
                LOG.debug(Logger.EVENT_UNSPECIFIED, String.format("Using corrected pathInfo '%s' for request URI '%s'", correctedPath, httpRequest.getRequestURI()));
            }
            request.getRequestDispatcher(correctedPath).forward(request, response);
            return;
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    static /* synthetic */ Set access$000() {
        return validStartSegments;
    }
}

