/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.soap.servlet;

import com.infor.erpln.c4ws.util.C4WSProperties;
import com.infor.erpln.c4ws.util.C4WSPropertiesManager;
import com.infor.erpln.c4ws.util.oauth.Authenticator;
import com.infor.erpln.jca.ConnectionFactoryImpl;
import javax.servlet.ServletContext;
import org.apache.commons.lang.StringUtils;

public class SettingsManager {
    private static final String DUMMY = "??????????";
    private ServletContext context;
    private C4WSPropertiesManager propertiesManager;
    private String lnuiConfigFile;
    private boolean lnuiConfigFileChanged;
    private String keystoreLocation;
    private boolean keystoreLocationChanged;
    private String keystorePassword;
    private boolean keystorePasswordChanged;
    private String consumerKey;
    private boolean consumerKeyChanged;
    private String consumerSecret;
    private boolean consumerSecretChanged;
    private boolean cloudEnabled;
    private boolean cloudEnabledChanged;

    public SettingsManager(ServletContext context) {
        this.context = context;
        this.propertiesManager = (C4WSPropertiesManager)context.getAttribute("com.infor.erpln.c4ws.util.C4WSPropertiesManager");
        this.initSettings();
    }

    private void initSettings() {
        C4WSProperties properties = this.propertiesManager.getEditableProperties();
        this.lnuiConfigFile = properties.getLNUIConfigFile();
        this.keystoreLocation = properties.getKeyStorePath();
        this.keystorePassword = properties.getKeyStorePassword();
        this.consumerKey = properties.getConsumerKey();
        this.consumerSecret = properties.getConsumerSecret();
        this.cloudEnabled = properties.isCloudEnabled();
        this.lnuiConfigFileChanged = false;
        this.keystoreLocationChanged = false;
        this.keystorePasswordChanged = false;
        this.consumerKeyChanged = false;
        this.consumerSecretChanged = false;
    }

    public String getLNUIConfigFile() {
        return this.lnuiConfigFile == null ? "" : this.lnuiConfigFile;
    }

    public void setLNUIConfigFile(String path) {
        String newValue = StringUtils.trimToNull((String)path);
        this.lnuiConfigFileChanged = !StringUtils.equals((String)newValue, (String)this.lnuiConfigFile);
        this.lnuiConfigFile = newValue;
        this.reloadSettings();
    }

    private void reloadSettings() {
        C4WSProperties properties = this.propertiesManager.getEditableProperties();
        properties.changeLNUIConfigFile(this.lnuiConfigFile);
        if (!this.keystoreLocationChanged) {
            this.keystoreLocation = properties.getKeyStorePath();
        }
        if (!this.keystorePasswordChanged) {
            this.keystorePassword = properties.getKeyStorePassword();
        }
        if (!this.consumerKeyChanged) {
            this.consumerKey = properties.getConsumerKey();
        }
        if (!this.consumerSecretChanged) {
            this.consumerSecret = properties.getConsumerSecret();
        }
        if (!this.cloudEnabledChanged) {
            this.cloudEnabled = properties.isCloudEnabled();
        }
    }

    public boolean saveChanges() {
        C4WSProperties properties = this.propertiesManager.getEditableProperties();
        if (this.lnuiConfigFileChanged) {
            properties.changeLNUIConfigFile(this.lnuiConfigFile);
        }
        if (this.keystoreLocationChanged) {
            properties.setKeyStorePath(this.keystoreLocation);
        }
        if (this.keystorePasswordChanged) {
            properties.setKeyStorePassword(this.keystorePassword);
        }
        if (this.consumerKeyChanged) {
            properties.setConsumerKey(this.consumerKey);
        }
        if (this.consumerSecretChanged) {
            properties.setConsumerSecret(this.consumerSecret);
        }
        if (this.cloudEnabledChanged) {
            properties.setCloudEnabled(this.cloudEnabled);
            if (this.cloudEnabled && properties.getCloudEnvironmentID() == null) {
                String envName = properties.getFirstEnvironmentID(true);
                properties.setCloudEnvironmentID(envName);
            }
        }
        try {
            this.propertiesManager.saveProperties(properties);
        }
        catch (C4WSProperties.UpdateException e) {
            return false;
        }
        this.updateRuntimeSettings();
        return true;
    }

    private void updateRuntimeSettings() {
        ConnectionFactoryImpl factory;
        if (this.consumerKey != null) {
            this.context.setAttribute("com.infor.erpln.util.oauth.Authenticator", (Object)Authenticator.getInstance((String)this.consumerKey, (String)this.consumerSecret));
        }
        if ((factory = (ConnectionFactoryImpl)this.context.getAttribute("com.infor.erpln.soap.connectionFactory")) != null && this.keystoreLocation != null) {
            factory.setKeyStore(this.keystoreLocation, this.keystorePassword);
            factory.setTrustStore(this.keystoreLocation, this.keystorePassword);
        }
    }

    public String getKeystoreLocation() {
        return this.keystoreLocation == null ? "" : this.keystoreLocation;
    }

    public void setKeystoreLocation(String location) {
        String newValue = StringUtils.trimToNull((String)location);
        this.keystoreLocationChanged = !StringUtils.equals((String)newValue, (String)this.keystoreLocation);
        this.keystoreLocation = newValue;
    }

    public String getConsumerKey() {
        return this.consumerKey == null ? "" : this.consumerKey;
    }

    public void setConsumerKey(String key) {
        String newValue = StringUtils.trimToNull((String)key);
        this.consumerKeyChanged = !StringUtils.equals((String)newValue, (String)this.consumerKey);
        this.consumerKey = newValue;
    }

    public boolean isCloudEnabled() {
        return this.cloudEnabled;
    }

    public void setCloudEnabled(boolean enabled) {
        this.cloudEnabledChanged = enabled != this.cloudEnabled;
        this.cloudEnabled = enabled;
    }

    public String getDummyKeystorePassword() {
        return StringUtils.isEmpty((String)this.keystorePassword) ? "" : DUMMY;
    }

    public String getDummyConsumerSecret() {
        return StringUtils.isEmpty((String)this.consumerSecret) ? "" : DUMMY;
    }

    public void setKeystorePassword(String password) {
        String newValue = StringUtils.trimToNull((String)password);
        if (!StringUtils.equals((String)password, (String)DUMMY)) {
            this.keystorePasswordChanged = !StringUtils.equals((String)newValue, (String)this.keystorePassword);
            this.keystorePassword = newValue;
        }
    }

    public void setConsumerSecret(String secret) {
        String newValue = StringUtils.trimToNull((String)secret);
        if (!StringUtils.equals((String)secret, (String)DUMMY)) {
            this.consumerSecretChanged = !StringUtils.equals((String)newValue, (String)this.consumerSecret);
            this.consumerSecret = newValue;
        }
    }
}

