/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.soap.servlet;

import com.infor.erpln.soap.servlet.ServletAdapter;
import com.sun.istack.NotNull;
import com.sun.xml.ws.api.PropertySet;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.server.PortAddressResolver;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.api.server.WebServiceContextDelegate;
import com.sun.xml.ws.resources.WsservletMessages;
import com.sun.xml.ws.transport.Headers;
import com.sun.xml.ws.transport.http.HttpAdapter;
import com.sun.xml.ws.transport.http.WSHTTPConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.ws.WebServiceException;

public final class ServletConnectionImpl
extends WSHTTPConnection
implements WebServiceContextDelegate {
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final ServletContext context;
    private int status;
    private Headers requestHeaders;
    private final HttpAdapter adapter;
    private Map<String, List<String>> responseHeaders;
    private static final PropertySet.PropertyMap model = ServletConnectionImpl.parse(ServletConnectionImpl.class);

    public ServletConnectionImpl(@NotNull HttpAdapter adapter, ServletContext context, HttpServletRequest request, HttpServletResponse response) {
        this.adapter = adapter;
        this.context = context;
        this.request = request;
        this.response = response;
    }

    @PropertySet.Property(value={"javax.xml.ws.http.request.headers", "com.sun.xml.ws.api.message.packet.inbound.transport.headers"})
    @NotNull
    public Map<String, List<String>> getRequestHeaders() {
        if (this.requestHeaders == null) {
            this.requestHeaders = new Headers();
            Enumeration enums = this.request.getHeaderNames();
            while (enums.hasMoreElements()) {
                String headerName = (String)enums.nextElement();
                String headerValue = this.request.getHeader(headerName);
                ArrayList<String> values = this.requestHeaders.get((Object)headerName);
                if (values == null) {
                    values = new ArrayList<String>();
                    this.requestHeaders.put(headerName, values);
                }
                values.add(headerValue);
            }
        }
        return this.requestHeaders;
    }

    public void setResponseHeaders(Map<String, List<String>> headers) {
        this.responseHeaders = headers;
        if (headers == null) {
            return;
        }
        if (this.status != 0) {
            this.response.setStatus(this.status);
        }
        this.response.reset();
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            String name = entry.getKey();
            if (name.equalsIgnoreCase("Content-Type") || name.equalsIgnoreCase("Content-Length")) continue;
            for (String value : entry.getValue()) {
                this.response.addHeader(name, value);
            }
        }
    }

    @PropertySet.Property(value={"javax.xml.ws.http.response.headers", "com.sun.xml.ws.api.message.packet.outbound.transport.headers"})
    public Map<String, List<String>> getResponseHeaders() {
        return this.responseHeaders;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    @PropertySet.Property(value={"javax.xml.ws.http.response.code"})
    public int getStatus() {
        return this.status;
    }

    public void setContentTypeResponseHeader(@NotNull String value) {
        this.response.setContentType(value);
    }

    @NotNull
    public InputStream getInput() throws IOException {
        return this.request.getInputStream();
    }

    @NotNull
    public OutputStream getOutput() throws IOException {
        this.response.setStatus(this.status);
        return this.response.getOutputStream();
    }

    @NotNull
    public WebServiceContextDelegate getWebServiceContextDelegate() {
        return this;
    }

    public Principal getUserPrincipal(Packet p) {
        return this.request.getUserPrincipal();
    }

    public boolean isUserInRole(Packet p, String role) {
        return this.request.isUserInRole(role);
    }

    @NotNull
    public String getEPRAddress(Packet p, WSEndpoint endpoint) {
        String baseAddress = ServletAdapter.getBaseAddress((HttpServletRequest)this.request);
        PortAddressResolver resolver = this.adapter.owner.createPortAddressResolver(baseAddress);
        String address = resolver.getAddressFor(endpoint.getServiceName(), endpoint.getPortName().getLocalPart());
        if (address == null) {
            throw new WebServiceException(WsservletMessages.SERVLET_NO_ADDRESS_AVAILABLE((Object)endpoint.getPortName()));
        }
        return address;
    }

    @NotNull
    public String getBaseAddress() {
        return ServletAdapter.getBaseAddress((HttpServletRequest)this.getRequest());
    }

    public String getWSDLAddress(@NotNull Packet request, @NotNull WSEndpoint endpoint) {
        String eprAddress = this.getEPRAddress(request, endpoint);
        if (this.adapter.getEndpoint().getPort() != null) {
            return eprAddress + "?wsdl";
        }
        return null;
    }

    @PropertySet.Property(value={"javax.xml.ws.http.request.method"})
    @NotNull
    public String getRequestMethod() {
        return this.request.getMethod();
    }

    public boolean isSecure() {
        return this.request.getScheme().equals("https");
    }

    public String getRequestHeader(String headerName) {
        return this.request.getHeader(headerName);
    }

    @PropertySet.Property(value={"javax.xml.ws.http.request.querystring"})
    public String getQueryString() {
        return this.request.getQueryString();
    }

    @PropertySet.Property(value={"javax.xml.ws.http.request.pathinfo"})
    @NotNull
    public String getPathInfo() {
        return this.request.getPathInfo();
    }

    @PropertySet.Property(value={"javax.xml.ws.servlet.context"})
    public ServletContext getContext() {
        return this.context;
    }

    @PropertySet.Property(value={"javax.xml.ws.servlet.response"})
    public HttpServletResponse getResponse() {
        return this.response;
    }

    @PropertySet.Property(value={"javax.xml.ws.servlet.request"})
    public HttpServletRequest getRequest() {
        return this.request;
    }

    public String getProtocol() {
        return this.request.getProtocol();
    }

    public void setContentLengthResponseHeader(int value) {
        this.response.setContentLength(value);
    }

    protected PropertySet.PropertyMap getPropertyMap() {
        return model;
    }

    public String getServiceName() {
        try {
            return ((ServletAdapter)this.adapter).getName();
        }
        catch (Exception ex) {
            return "";
        }
    }
}

