/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.soap.servlet;

import com.infor.erpln.c4ws.util.C4WSPropertiesManager;
import com.infor.erpln.c4ws.util.ConnectionHelper;
import com.infor.erpln.c4ws.util.oauth.BaseUriUtil;
import com.infor.erpln.jca.ConnectionSpecImpl;
import com.infor.erpln.soap.WSDLImporter;
import com.infor.erpln.soap.XMLUtil;
import com.infor.erpln.soap.servlet.ServletAdapter;
import com.infor.erpln.soap.servlet.ServletAdapterList;
import com.infor.erpln.soap.servlet.ServletConnectionImpl;
import com.sun.istack.NotNull;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.server.BoundEndpoint;
import com.sun.xml.ws.api.server.DocumentAddressResolver;
import com.sun.xml.ws.api.server.Module;
import com.sun.xml.ws.api.server.PortAddressResolver;
import com.sun.xml.ws.api.server.SDDocument;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.api.server.WebModule;
import com.sun.xml.ws.resources.WsservletMessages;
import com.sun.xml.ws.transport.http.HttpAdapter;
import com.sun.xml.ws.transport.http.HttpAdapterList;
import com.sun.xml.ws.transport.http.WSHTTPConnection;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.WebServiceException;

/*
 * Exception performing whole class analysis ignored.
 */
public final class ServletAdapter
extends HttpAdapter
implements BoundEndpoint {
    final String name;
    final String urlPattern;
    private long m_count = 0L;
    private static TransformerFactory factory;
    private static final Logger LOGGER;

    protected ServletAdapter(String name, String urlPattern, WSEndpoint endpoint, ServletAdapterList owner) {
        super(endpoint, (HttpAdapterList)owner);
        this.name = name;
        this.urlPattern = urlPattern;
        Module module = (Module)endpoint.getContainer().getSPI(Module.class);
        if (module == null) {
            LOGGER.warning("Container " + endpoint.getContainer() + " doesn't support " + Module.class);
        } else {
            module.getBoundEndpoints().add(this);
        }
    }

    public boolean isMetadataQuery(String query) {
        return query != null && (query.equals("WSDL") || query.startsWith("wsdl") || query.startsWith("xsd="));
    }

    public String getName() {
        return this.name;
    }

    @NotNull
    public URI getAddress() {
        WebModule webModule = (WebModule)this.endpoint.getContainer().getSPI(WebModule.class);
        if (webModule == null) {
            throw new WebServiceException("Container " + this.endpoint.getContainer() + " doesn't support " + WebModule.class);
        }
        String adrs = webModule.getContextPath() + this.getValidPath();
        try {
            return new URI(adrs);
        }
        catch (URISyntaxException e) {
            throw new WebServiceException("Unable to compute address for " + this.endpoint, (Throwable)e);
        }
    }

    public String getValidPath() {
        if (this.urlPattern.endsWith("/*")) {
            return this.urlPattern.substring(0, this.urlPattern.length() - 2);
        }
        return this.urlPattern;
    }

    public QName getPortName() {
        WSDLPort port = this.getEndpoint().getPort();
        if (port == null) {
            return null;
        }
        return port.getName();
    }

    public long getCount() {
        return this.m_count;
    }

    public void handle(ServletContext context, HttpServletRequest request, HttpServletResponse response) throws IOException {
        ++this.m_count;
        ServletConnectionImpl connection = new ServletConnectionImpl((HttpAdapter)this, context, request, response);
        super.handle((WSHTTPConnection)connection);
    }

    public void publishWSDL(ServletContext context, HttpServletRequest request, HttpServletResponse response) throws IOException {
        ServletConnectionImpl con = new ServletConnectionImpl((HttpAdapter)this, context, request, response);
        C4WSPropertiesManager c4wsPropertiesManager = (C4WSPropertiesManager)context.getAttribute("com.infor.erpln.c4ws.util.C4WSPropertiesManager");
        if (c4wsPropertiesManager != null && c4wsPropertiesManager.getProperties().isCloudEnabled()) {
            try {
                ConnectionHelper helper = new ConnectionHelper(ConnectionHelper.Context.SOAP, null, c4wsPropertiesManager.getProperties(), request, null, null);
                ConnectionSpecImpl spec = helper.getConnectionSpec();
                String wsdl = this.downloadWSDLFromLN(spec, con);
                wsdl = ServletAdapter.replaceEndpointInWSDL((String)wsdl, (ServletConnectionImpl)con);
                this.publishWSDL(wsdl, con);
            }
            catch (Exception ex) {
                this.writeNotFoundErrorPage((WSHTTPConnection)con, "WSDL could not be obtained: " + ex.getMessage());
            }
        } else {
            this.publishWSDL((WSHTTPConnection)con);
        }
    }

    private static String replaceEndpointInWSDL(String wsdl, ServletConnectionImpl servletConn) {
        try {
            String address = BaseUriUtil.getBaseUri((HttpServletRequest)servletConn.getRequest());
            StreamSource xslSource = new StreamSource(ServletAdapter.class.getResourceAsStream("changeAddress.xsl"));
            StreamSource inputSource = new StreamSource(new StringReader(wsdl));
            StringWriter writer = new StringWriter();
            StreamResult outputTarget = new StreamResult(writer);
            Transformer transformer = factory.newTransformer(xslSource);
            transformer.setParameter("NewAddress", address);
            transformer.transform(inputSource, outputTarget);
            return writer.toString();
        }
        catch (Exception exception) {
            return wsdl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String downloadWSDLFromLN(ConnectionSpecImpl connSpec, ServletConnectionImpl servletConn) throws Exception {
        String serviceName = servletConn.getPathInfo();
        int index = serviceName.indexOf(47);
        if (index >= 0 && (index = (serviceName = serviceName.substring(index + 1)).indexOf(47)) > 0) {
            serviceName = serviceName.substring(0, index);
        }
        WSDLImporter importer = new WSDLImporter(servletConn.getContext());
        importer.initialize(connSpec);
        String wsdl = null;
        try {
            wsdl = importer.getWSDL(serviceName);
        }
        finally {
            importer.close();
        }
        return wsdl;
    }

    private void publishWSDL(String wsdl, ServletConnectionImpl con) throws IOException {
        con.setStatus(200);
        con.setContentTypeResponseHeader("text/xml;charset=\"utf-8\"");
        try (OutputStream os = con.getProtocol().contains("1.1") ? con.getOutput() : new Http10OutputStream((WSHTTPConnection)con);){
            os.write(wsdl.getBytes(StandardCharsets.UTF_8));
        }
    }

    static String getBaseAddress(HttpServletRequest request) {
        StringBuilder addrBuf = new StringBuilder();
        addrBuf.append(request.getScheme());
        addrBuf.append("://");
        addrBuf.append(request.getServerName());
        addrBuf.append(':');
        addrBuf.append(request.getServerPort());
        addrBuf.append(request.getContextPath());
        return addrBuf.toString();
    }

    public URI getAddress(String arg0) {
        return this.getAddress();
    }

    public void publishWSDL(@NotNull WSHTTPConnection con) throws IOException {
        SDDocument doc = (SDDocument)this.wsdls.get(con.getQueryString());
        if (doc == null) {
            this.writeNotFoundErrorPage(con, "Invalid Request");
            return;
        }
        con.setStatus(200);
        con.setContentTypeResponseHeader("text/xml;charset=\"utf-8\"");
        OutputStream os = con.getProtocol().contains("1.1") ? con.getOutput() : new Http10OutputStream(con);
        String address = con.getBaseAddress() + this.urlPattern;
        1 portAddressResolver = new /* Unavailable Anonymous Inner Class!! */;
        2 resolver = new /* Unavailable Anonymous Inner Class!! */;
        doc.writeTo((PortAddressResolver)portAddressResolver, (DocumentAddressResolver)resolver, os);
        os.close();
    }

    private void writeNotFoundErrorPage(WSHTTPConnection con, String message) throws IOException {
        con.setStatus(404);
        con.setContentTypeResponseHeader("text/html; charset=\"utf-8\"");
        PrintWriter out = new PrintWriter(new OutputStreamWriter(con.getOutput(), "UTF-8"));
        out.println("<html>");
        out.println("<head><title>");
        out.println(WsservletMessages.SERVLET_HTML_TITLE());
        out.println("</title></head>");
        out.println("<body>");
        out.println(WsservletMessages.SERVLET_HTML_NOT_FOUND((Object)message));
        out.println("</body>");
        out.println("</html>");
        out.close();
    }

    static {
        try {
            factory = XMLUtil.getSecureTransformerFactory();
        }
        catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
            // empty catch block
        }
        LOGGER = Logger.getLogger(ServletAdapter.class.getName());
    }
}

