/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.soap.servlet;

import com.infor.erpln.c4ws.util.C4WSProperties;
import com.infor.erpln.c4ws.util.C4WSPropertiesManager;
import com.infor.erpln.c4ws.util.LNEnvironment;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;

public class ErpServerManager {
    private static Logger LOG = ESAPI.getLogger(ErpServerManager.class);
    private C4WSPropertiesManager propertiesManager;

    public ErpServerManager(ServletContext context) {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "ErpServerManager constructor");
        this.propertiesManager = (C4WSPropertiesManager)context.getAttribute("com.infor.erpln.c4ws.util.C4WSPropertiesManager");
    }

    public String[] listConnectionPointNames() {
        Set nameSet = this.propertiesManager.getProperties().getEnvironmentMapping().keySet();
        return nameSet.toArray(new String[nameSet.size()]);
    }

    public LNEnvironment getEnvironmentForCP(String connectionpointName) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(Logger.EVENT_UNSPECIFIED, String.format("Retrieving LN environment for connection point '%s'", connectionpointName));
        }
        String environmentID = (String)this.propertiesManager.getProperties().getEnvironmentMapping().get(connectionpointName);
        LNEnvironment environment = this.propertiesManager.getProperties().getEnvironmentForID(environmentID);
        if (environment == null) {
            LOG.warning(Logger.EVENT_UNSPECIFIED, String.format("Unable to find LN environment for connection point '%s'", connectionpointName));
        }
        return environment;
    }

    public LNEnvironment getEnvironmentForID(String environmentID) {
        LNEnvironment environment;
        if (LOG.isDebugEnabled()) {
            LOG.debug(Logger.EVENT_UNSPECIFIED, String.format("Retrieving LN environment named '%s'", environmentID));
        }
        if ((environment = this.propertiesManager.getProperties().getEnvironmentForID(environmentID)) == null) {
            LOG.warning(Logger.EVENT_UNSPECIFIED, String.format("Unable to find LN environment named '%s'", environmentID));
        }
        return environment;
    }

    public void addEnvironment(String connectionpointName, LNEnvironment environment) {
        String imsEnv;
        String cloudEnv;
        String environmentID = environment.getName();
        if (LOG.isDebugEnabled()) {
            LOG.debug(Logger.EVENT_UNSPECIFIED, String.format("Adding LN environment '%s' for connection point '%s'", environmentID, connectionpointName));
        }
        C4WSProperties properties = this.propertiesManager.getEditableProperties();
        properties.setEnvironmentForID(environmentID, environment);
        properties.addEnvironmentMapping(connectionpointName, environmentID);
        if (properties.isCloudEnabled() && ((cloudEnv = properties.getCloudEnvironmentID()) == null || this.getEnvironmentForID(cloudEnv) == null)) {
            properties.setCloudEnvironmentID(environmentID);
        }
        if ((imsEnv = properties.getIMSEnvironmentID()) == null || this.getEnvironmentForID(imsEnv) == null) {
            properties.setIMSEnvironmentID(environmentID);
        }
        try {
            this.propertiesManager.saveProperties(properties);
        }
        catch (C4WSProperties.UpdateException e) {
            LOG.error(Logger.EVENT_FAILURE, "Adding LN environment failed.", (Throwable)e);
        }
    }

    public void modifyEnvironment(LNEnvironment environment) {
        String environmentID = environment.getName();
        if (LOG.isDebugEnabled()) {
            LOG.debug(Logger.EVENT_UNSPECIFIED, String.format("Modifying LN environment '%s'", environmentID));
        }
        C4WSProperties properties = this.propertiesManager.getEditableProperties();
        properties.setEnvironmentForID(environmentID, environment);
        try {
            this.propertiesManager.saveProperties(properties);
        }
        catch (C4WSProperties.UpdateException e) {
            LOG.error(Logger.EVENT_FAILURE, "Modifying LN environment failed.", (Throwable)e);
        }
    }

    public void removeEnvironment(String connectionpointName) {
        String envName;
        if (LOG.isDebugEnabled()) {
            LOG.debug(Logger.EVENT_UNSPECIFIED, String.format("Removing LN environment for connection point '%s'", connectionpointName));
        }
        C4WSProperties properties = this.propertiesManager.getEditableProperties();
        String environmentID = (String)properties.getEnvironmentMapping().get(connectionpointName);
        properties.removeEnvironment(environmentID);
        properties.removeConnectionpoint(connectionpointName);
        if (properties.isCloudEnabled() && environmentID.equals(properties.getCloudEnvironmentID())) {
            envName = properties.getFirstEnvironmentID(true);
            properties.setCloudEnvironmentID(envName);
            if (envName != null && LOG.isDebugEnabled()) {
                LOG.debug(Logger.EVENT_UNSPECIFIED, String.format("Cloud environment was removed -- Now using LN environment '%s' as Cloud environment", envName));
            }
        }
        if (environmentID.equals(properties.getIMSEnvironmentID())) {
            envName = properties.getFirstEnvironmentID(true);
            properties.setIMSEnvironmentID(envName);
            if (envName != null && LOG.isDebugEnabled()) {
                LOG.debug(Logger.EVENT_UNSPECIFIED, String.format("IMS environment was removed -- Now using LN environment '%s' as IMS environment", envName));
            }
        }
        try {
            this.propertiesManager.saveProperties(properties);
        }
        catch (C4WSProperties.UpdateException e) {
            LOG.error(Logger.EVENT_FAILURE, "Removing LN environment failed.", (Throwable)e);
        }
    }

    public String[] getUnmappedEnvironments() {
        TreeSet environmentNames = new TreeSet();
        C4WSProperties properties = this.propertiesManager.getProperties();
        environmentNames.addAll(properties.getAllEnvironments());
        environmentNames.removeAll(properties.getEnvironmentMapping().values());
        return environmentNames.toArray(new String[environmentNames.size()]);
    }

    public String getEnvironmentIDForCP(String connectionpointName) {
        C4WSProperties properties = this.propertiesManager.getProperties();
        String envID = (String)properties.getEnvironmentMapping().get(connectionpointName);
        if (envID == null) {
            envID = connectionpointName;
            List existingEnvironments = properties.getAllEnvironments();
            int i = 1;
            while (existingEnvironments.contains(envID)) {
                envID = String.format("%s_%d", connectionpointName, i);
                ++i;
            }
        }
        return envID;
    }

    public String getCPForEnvironmentID(String environmentID) {
        C4WSProperties properties = this.propertiesManager.getProperties();
        SortedMap environmentMapping = properties.getEnvironmentMapping();
        for (String key : environmentMapping.keySet()) {
            if (!((String)environmentMapping.get(key)).equals(environmentID)) continue;
            return key;
        }
        String cpName = environmentID.replace(' ', '_');
        int i = 1;
        while (environmentMapping.containsKey(cpName)) {
            cpName = String.format("%s_%d", environmentID.replace(' ', '_'), i);
            ++i;
        }
        return cpName;
    }

    public String getCloudEnvironmentID() {
        C4WSProperties properties = this.propertiesManager.getProperties();
        String id = properties.getCloudEnvironmentID();
        return id;
    }

    public void setCloudEnvironmentID(String id) {
        C4WSProperties properties = this.propertiesManager.getEditableProperties();
        properties.setCloudEnvironmentID(id);
        try {
            this.propertiesManager.saveProperties(properties);
        }
        catch (C4WSProperties.UpdateException e) {
            LOG.error(Logger.EVENT_FAILURE, "Setting Cloud environment failed.", (Throwable)e);
        }
    }

    public String getIMSEnvironmentID() {
        C4WSProperties properties = this.propertiesManager.getProperties();
        String id = properties.getIMSEnvironmentID();
        return id;
    }

    public void setIMSEnvironmentID(String id) {
        C4WSProperties properties = this.propertiesManager.getEditableProperties();
        properties.setIMSEnvironmentID(id);
        try {
            this.propertiesManager.saveProperties(properties);
        }
        catch (C4WSProperties.UpdateException e) {
            LOG.error(Logger.EVENT_FAILURE, "Setting IMS environment failed.", (Throwable)e);
        }
    }

    public boolean isCloudEnabled() {
        C4WSProperties properties = this.propertiesManager.getProperties();
        return properties.isCloudEnabled();
    }
}

