/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.soap.diagnostics;

import com.infor.erpln.soap.diagnostics.IDiagnostics;
import com.sun.xml.ws.util.Version;
import java.io.InputStream;

public class JAXWSVersionCheck
implements IDiagnostics {
    private static final String JAXWS_VERSIONFILE1 = "/com/sun/xml/ws/version.properties";
    private static final String JAXWS_VERSIONFILE2 = "/com/sun/xml/ws/util/version.properties";
    private String m_message;

    public boolean check() {
        try {
            InputStream is = Version.class.getResourceAsStream(JAXWS_VERSIONFILE1);
            if (is == null) {
                is = Version.class.getResourceAsStream(JAXWS_VERSIONFILE2);
            }
            Version version = Version.create((InputStream)is);
            this.m_message = "Version: " + version.MAJOR_VERSION + " (" + version.BUILD_VERSION + ")";
            is.close();
            return true;
        }
        catch (Throwable e) {
            this.m_message = "Cannot get version information, the JAXWS runtime is probably not installed correctly or is not found in classpath.";
            return false;
        }
    }

    public String getMessage() {
        return this.m_message;
    }
}

