/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.soap.diagnostics;

import com.infor.erpln.soap.diagnostics.IDiagnostics;
import javax.xml.bind.JAXBContext;

public class JAXBVersionCheck
implements IDiagnostics {
    private String m_message;

    public boolean check() {
        try {
            Class<?> jaxbContextClass = JAXBContext.newInstance((Class[])new Class[0]).getClass();
            this.m_message = "JAXBContext implementation: " + jaxbContextClass.getName();
            Package p = jaxbContextClass.getPackage();
            if (p != null) {
                if (p.getSpecificationVersion() != null) {
                    this.m_message = this.m_message + "<br/>Specification Version : " + p.getSpecificationVersion();
                }
                if (p.getImplementationVersion() != null) {
                    this.m_message = this.m_message + "<br/>Implementation Version : " + p.getImplementationVersion();
                }
            }
            return true;
        }
        catch (Throwable e) {
            this.m_message = "Cannot get version information, JAXB is probably not installed correctly or is not found in classpath.";
            return false;
        }
    }

    public String getMessage() {
        return this.m_message;
    }
}

