/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.soap.conversion;

import com.infor.erpln.soap.XMLUtil;
import com.infor.erpln.soap.conversion.IXslRepository;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;
import org.w3c.dom.Document;

public class XslRepository
implements IXslRepository {
    private static final Object DEFAULT_XSL = "_default_";
    private static final Logger LOG = ESAPI.getLogger(XslRepository.class);
    private static DocumentBuilder s_docBuilder;
    private static XslRepository s_instance;
    private File m_xslFolder;
    private Map<String, Document> m_serviceXslElements = new HashMap();

    private XslRepository(File xslFolder) {
        assert (xslFolder != null);
        this.m_xslFolder = xslFolder;
        this.synchronize();
    }

    public static XslRepository getInstance() {
        return s_instance;
    }

    public static XslRepository getOrCreateInstance(File xslFolder) {
        if (s_instance == null) {
            s_instance = new XslRepository(xslFolder);
        }
        return s_instance;
    }

    public final void synchronize() {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "Synchronizing the XSL documents with the folder contents");
        this.m_serviceXslElements.clear();
        String[] xslFiles = this.m_xslFolder.list((FilenameFilter)new /* Unavailable Anonymous Inner Class!! */);
        for (int i = 0; i < xslFiles.length; ++i) {
            String fileName = xslFiles[i];
            String serviceName = fileName.substring(0, fileName.length() - 4);
            File xslFile = new File(this.m_xslFolder, fileName);
            Document xslElement = this.readFromFile(xslFile);
            if (xslElement == null) continue;
            LOG.debug(Logger.EVENT_UNSPECIFIED, "Added XSL document for service " + serviceName);
            this.m_serviceXslElements.put(serviceName, xslElement);
        }
    }

    public Document getXSL(String serviceName) {
        Document result = (Document)this.m_serviceXslElements.get(serviceName);
        if (result == null) {
            result = (Document)this.m_serviceXslElements.get(DEFAULT_XSL);
        }
        if (result == null) {
            LOG.warning(Logger.EVENT_UNSPECIFIED, "Could not find an XSL file for service " + serviceName);
        }
        return result;
    }

    public List<String> getServices() {
        return new ArrayList<String>(this.m_serviceXslElements.keySet());
    }

    private Document readFromFile(File xslFile) {
        Document result = null;
        try {
            result = s_docBuilder.parse(xslFile);
        }
        catch (Exception e) {
            LOG.error(Logger.EVENT_FAILURE, "Error when trying to parse XSL file " + xslFile.getPath(), (Throwable)e);
        }
        return result;
    }

    static {
        try {
            DocumentBuilderFactory docFactory = XMLUtil.getSecureDocumentBuilderFactory();
            docFactory.setNamespaceAware(true);
            s_docBuilder = docFactory.newDocumentBuilder();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

