/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.soap.conversion;

import com.infor.erpln.soap.XMLUtil;
import com.infor.erpln.soap.conversion.IMessageConverter;
import com.infor.erpln.soap.conversion.IXslRepository;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * Exception performing whole class analysis ignored.
 */
public class MessageConverter
implements IMessageConverter {
    private static final Pattern BDE_WITH_NUMBER = Pattern.compile("^(\\S+)_\\d+$");
    private static final Logger LOG = ESAPI.getLogger(MessageConverter.class);
    private static TransformerFactory factory = XMLUtil.getSecureTransformerFactory();
    private IXslRepository xslRepository;

    public MessageConverter(IXslRepository xslRepository) {
        this.xslRepository = xslRepository;
    }

    public Document convert(Element message, String serviceName) {
        Document stylesheet;
        if (LOG.isDebugEnabled()) {
            LOG.debug(Logger.EVENT_UNSPECIFIED, "Transforming XML message for service " + serviceName);
            LOG.debug(Logger.EVENT_UNSPECIFIED, "Before transformation: " + XMLUtil.XmlToString((Node)message));
        }
        if ((stylesheet = this.xslRepository.getXSL(serviceName)) != null) {
            DOMSource xslSource = new DOMSource(stylesheet);
            DOMSource messageSource = new DOMSource(message);
            try {
                Transformer transformer = factory.newTransformer(xslSource);
                transformer.setParameter("BdeName", MessageConverter.getBdeName((String)serviceName));
                DOMResult outputTarget = new DOMResult();
                transformer.transform(messageSource, outputTarget);
                Document outputDocument = (Document)outputTarget.getNode();
                if (LOG.isDebugEnabled()) {
                    LOG.debug(Logger.EVENT_UNSPECIFIED, "After transformation: " + XMLUtil.XmlToString((Node)outputDocument));
                }
                return outputDocument;
            }
            catch (TransformerConfigurationException e) {
                LOG.error(Logger.EVENT_FAILURE, "Error when creating an XML Transformer", (Throwable)e);
            }
            catch (TransformerException e) {
                LOG.error(Logger.EVENT_FAILURE, "Error during transformation of XML message", (Throwable)e);
            }
        }
        LOG.info(Logger.EVENT_FAILURE, "Transformation of XML message failed for service " + serviceName);
        return null;
    }

    public static String getBdeName(String serviceName) {
        Matcher matcher = BDE_WITH_NUMBER.matcher(serviceName);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return serviceName;
    }
}

