/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.soap.boi;

import com.baan.b3.boi1.metadata.IManagerMetadata;
import com.infor.erpln.soap.diagnostics.C4WSVersionCheck;
import freemarker.template.Configuration;
import freemarker.template.SimpleHash;
import freemarker.template.Template;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Date;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;

public class WSDLGenerator {
    private static Logger LOG = ESAPI.getLogger(WSDLGenerator.class);

    public String generateWSDL(String boiName, String boiClass, boolean allMembersOptional) throws Exception {
        LOG.info(Logger.EVENT_UNSPECIFIED, "Generate WSDL for " + boiName + " and class " + boiClass);
        Configuration config = new Configuration();
        config.setClassicCompatible(false);
        config.setClassForTemplateLoading(WSDLGenerator.class, "/templates");
        Template template = config.getTemplate("wsdl.ftl");
        Class<?> cls = Class.forName(boiClass);
        Object obj = cls.newInstance();
        Method retrieveMetadata = cls.getMethod("retrieveMetadata", new Class[0]);
        IManagerMetadata metadata = (IManagerMetadata)retrieveMetadata.invoke(obj, new Object[0]);
        C4WSVersionCheck version = new C4WSVersionCheck();
        boolean versionOK = version.check();
        SimpleHash root = new SimpleHash();
        root.put("generatorname", (Object)"BOI WSDL Generator");
        root.put("generatorversion", (Object)(versionOK ? version.getMessage() : "Version: internal"));
        root.put("today", (Object)new Date(System.currentTimeMillis()));
        root.put("boiname", (Object)boiName);
        root.put("allOptional", allMembersOptional);
        root.put("metadata", (Object)metadata);
        StringWriter writer = new StringWriter();
        template.process((Object)root, (Writer)writer);
        String result = writer.getBuffer().toString();
        if (LOG.isDebugEnabled()) {
            LOG.debug(Logger.EVENT_SUCCESS, "WSDL: " + result);
        }
        return result;
    }
}

