/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.soap.boi;

import com.baan.b3.boi1.BusinessObjectManager;
import com.infor.erpln.soap.boi.BoiExplorer;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.servlet.ServletContext;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;

public class BoiExplorer {
    private static Logger LOG = ESAPI.getLogger(BoiExplorer.class);
    private static BoiExplorer theInstance = new BoiExplorer();
    private boolean m_initialized = false;
    private ServletContext m_context;
    private List<Boi> m_bois = new ArrayList();
    private HashSet<String> m_boiNames = new HashSet();
    private static HashSet<String> s_skipJars = new HashSet();

    public static BoiExplorer getInstance() {
        return theInstance;
    }

    private BoiExplorer() {
    }

    public void initialize(ServletContext context) {
        if (!this.m_initialized) {
            LOG.debug(Logger.EVENT_UNSPECIFIED, "Start initialization thread");
            this.m_context = context;
            new Thread((Runnable)new FindBois(this, null)).start();
        }
    }

    private synchronized void waitForInitialization() {
        while (!this.m_initialized) {
            try {
                LOG.debug(Logger.EVENT_UNSPECIFIED, "Wait for initialization");
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private synchronized void initializeReady() {
        this.m_initialized = true;
        LOG.debug(Logger.EVENT_UNSPECIFIED, "BoiExplorer initialized");
        this.notifyAll();
    }

    public List<Boi> getBois() {
        this.waitForInitialization();
        return this.m_bois;
    }

    public List<String> getBoiClasses() {
        this.waitForInitialization();
        ArrayList<String> classNames = new ArrayList<String>();
        for (Boi boi : this.m_bois) {
            classNames.add(boi.getClassName());
        }
        return classNames;
    }

    public String getBoiName(String className) {
        this.waitForInitialization();
        for (Boi boi : this.m_bois) {
            if (!boi.getClassName().equals(className)) continue;
            return boi.getName();
        }
        return null;
    }

    public String getClassName(String boiName) {
        this.waitForInitialization();
        for (Boi boi : this.m_bois) {
            if (!boi.getName().equals(boiName)) continue;
            return boi.getClassName();
        }
        return null;
    }

    private void findBois() {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "BoiExplorer start scan");
        String location = this.m_context.getRealPath("/WEB-INF/lib");
        LOG.debug(Logger.EVENT_UNSPECIFIED, "findBois in " + location);
        File pathentry = new File(location);
        if (pathentry.isDirectory()) {
            String[] files = pathentry.list();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].endsWith(".jar") || s_skipJars.contains(files[i].toLowerCase())) continue;
                LOG.debug(Logger.EVENT_UNSPECIFIED, "scan " + files[i]);
                String jarFile = location + File.separator + files[i];
                try {
                    JarFile jf = new JarFile(jarFile);
                    Enumeration<JarEntry> _enum = jf.entries();
                    while (_enum.hasMoreElements()) {
                        JarEntry je = _enum.nextElement();
                        String name = je.getName();
                        if (!name.endsWith(".class")) continue;
                        String className = name.substring(0, name.length() - 6);
                        className = className.replace('/', '.');
                        try {
                            Class<?> cls = Class.forName(className);
                            if (!BusinessObjectManager.class.isAssignableFrom(cls) || cls == BusinessObjectManager.class) continue;
                            this.addBoi(className);
                        }
                        catch (Throwable e) {
                            LOG.debug(Logger.EVENT_FAILURE, "Failed to read class " + className);
                        }
                    }
                    jf.close();
                    continue;
                }
                catch (Exception e) {
                    LOG.error(Logger.EVENT_FAILURE, "Failed to read jar file " + jarFile, (Throwable)e);
                }
            }
        }
        LOG.debug(Logger.EVENT_UNSPECIFIED, "nr of bois: " + this.m_bois.size());
    }

    private void addBoi(String className) {
        int cmp;
        int index = className.lastIndexOf(46);
        String boiName = index > 0 ? className.substring(index + 1) : className;
        if (boiName.endsWith("Manager")) {
            boiName = boiName.substring(0, boiName.length() - 7);
        }
        for (index = 0; index < this.m_bois.size() && (cmp = className.compareTo(((Boi)this.m_bois.get(index)).getClassName())) >= 0; ++index) {
            if (cmp != 0) continue;
            return;
        }
        boiName = this.makeUniqueName(boiName);
        this.m_boiNames.add(boiName);
        this.m_bois.add(index, new Boi(this, boiName, className));
    }

    private String makeUniqueName(String base) {
        String name = base;
        int nr = 1;
        boolean exists = this.m_boiNames.contains(name);
        while (exists) {
            name = base + "_" + ++nr;
            exists = this.m_boiNames.contains(name);
        }
        return name;
    }

    static /* synthetic */ void access$100(BoiExplorer x0) {
        x0.findBois();
    }

    static /* synthetic */ void access$200(BoiExplorer x0) {
        x0.initializeReady();
    }

    static /* synthetic */ Logger access$300() {
        return LOG;
    }

    static {
        s_skipJars.add("activation.jar");
        s_skipJars.add("aws-java-sdk-1.11.125.jar");
        s_skipJars.add("axis.jar");
        s_skipJars.add("axiscognosclient.jar");
        s_skipJars.add("commons-codec-1.5.jar");
        s_skipJars.add("commons-collections-3.2.1.jar");
        s_skipJars.add("commons-configuration-1.8.jar");
        s_skipJars.add("commons-discovery-0.2.jar");
        s_skipJars.add("commons-fileupload-1.2.jar");
        s_skipJars.add("commons-io-2.1.jar");
        s_skipJars.add("commons-jxpath-1.3.jar");
        s_skipJars.add("commons-lang-2.6.jar");
        s_skipJars.add("commons-logging-1.1.3.jar");
        s_skipJars.add("compress-j2me.lzc_0.3.jar");
        s_skipJars.add("esapi-2.1.0.jar");
        s_skipJars.add("fastinfoset.jar");
        s_skipJars.add("freemarker.jar");
        s_skipJars.add("geronimo-spec-j2ee-connector-1.5-rc4.jar");
        s_skipJars.add("http.jar");
        s_skipJars.add("httpclient-4.5.2.jar");
        s_skipJars.add("httpcore-4.4.4.jar");
        s_skipJars.add("icepdf-core.jar");
        s_skipJars.add("jackson-annotations-2.6.0.jar");
        s_skipJars.add("jackson-core-2.6.6.jar");
        s_skipJars.add("jackson-core-2.9.3.jar");
        s_skipJars.add("jackson-databind-2.6.6.jar");
        s_skipJars.add("jaxb-api.jar");
        s_skipJars.add("jaxb-impl.jar");
        s_skipJars.add("jaxb-xjc.jar");
        s_skipJars.add("jaxrpc.jar");
        s_skipJars.add("jaxws-api.jar");
        s_skipJars.add("jaxws-rt.jar");
        s_skipJars.add("jaxws-tools.jar");
        s_skipJars.add("jcaadapter4erpln.jar");
        s_skipJars.add("jcaboiwrapper.jar");
        s_skipJars.add("jcarestclient.jar");
        s_skipJars.add("joda-time-2.8.1.jar");
        s_skipJars.add("json-simple-1.1.1.jar");
        s_skipJars.add("json4bde.jar");
        s_skipJars.add("jsr173_api.jar");
        s_skipJars.add("jsr181-api.jar");
        s_skipJars.add("jsr250-api.jar");
        s_skipJars.add("jstl.jar");
        s_skipJars.add("log4j-1.2.17.jar");
        s_skipJars.add("log4jconfiguration.jar");
        s_skipJars.add("mimepull.jar");
        s_skipJars.add("ognl-2.6.9.jar");
        s_skipJars.add("pngencoder-1.0.jar");
        s_skipJars.add("qrcode.jar");
        s_skipJars.add("raztec.jar");
        s_skipJars.add("rbarcode.jar");
        s_skipJars.add("resolver.jar");
        s_skipJars.add("saaj-api.jar");
        s_skipJars.add("saaj-impl.jar");
        s_skipJars.add("serializer-2.7.1.jar");
        s_skipJars.add("sjsxp.jar");
        s_skipJars.add("spring.jar");
        s_skipJars.add("spring-binding-1.0.6.jar");
        s_skipJars.add("standard.jar");
        s_skipJars.add("stax-ex.jar");
        s_skipJars.add("staxon-1.3.jar");
        s_skipJars.add("staxon-jackson-1.3.jar");
        s_skipJars.add("streambuffer.jar");
        s_skipJars.add("wsdl4j-1.6.2.jar");
        s_skipJars.add("xalan.jar");
        s_skipJars.add("xercesimpl.jar");
        s_skipJars.add("xml-apis.jar");
    }
}

