/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.soap;

import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * Exception performing whole class analysis ignored.
 */
public class XMLUtil {
    private static Logger LOG = ESAPI.getLogger(XMLUtil.class);

    public static DocumentBuilderFactory getSecureDocumentBuilderFactory() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setExpandEntityReferences(false);
        factory.setXIncludeAware(false);
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        return factory;
    }

    public static TransformerFactory getSecureTransformerFactory() {
        TransformerFactory factory = TransformerFactory.newInstance();
        try {
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (TransformerConfigurationException e) {
            LOG.fatal(Logger.SECURITY_FAILURE, "TransformerFactory does not support secure processing");
            return null;
        }
        return factory;
    }

    public static Document SourceToDocument(Source source) throws Exception {
        try {
            DOMResult result = new DOMResult();
            Transformer transformer = XMLUtil.getSecureTransformerFactory().newTransformer();
            transformer.setOutputProperty("indent", "no");
            transformer.transform(source, result);
            Document document = (Document)result.getNode();
            return document;
        }
        catch (TransformerException e) {
            LOG.error(Logger.EVENT_FAILURE, "SourceToDocument failed", (Throwable)e);
            throw e;
        }
    }

    public static Document StringToDocument(String str) throws Exception {
        StringReader reader = new StringReader(str);
        StreamSource source = new StreamSource(reader);
        return XMLUtil.SourceToDocument((Source)source);
    }

    public static String XmlToString(Node node) {
        try {
            DOMSource source = new DOMSource(node);
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            Transformer transformer = XMLUtil.getSecureTransformerFactory().newTransformer();
            transformer.transform(source, result);
            return sw.toString();
        }
        catch (TransformerException e) {
            LOG.error(Logger.EVENT_FAILURE, "XmlToString failed", (Throwable)e);
            return "Invalid XML data: " + e.getMessage();
        }
    }

    public static Element createElement(String name, String namespaceURI) throws Exception {
        DocumentBuilderFactory factory = XMLUtil.getSecureDocumentBuilderFactory();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();
        Element element = document.createElementNS(namespaceURI, name);
        document.appendChild(element);
        return element;
    }

    public static Element createElement(String name) throws Exception {
        DocumentBuilderFactory factory = XMLUtil.getSecureDocumentBuilderFactory();
        factory.setNamespaceAware(false);
        factory.setValidating(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();
        Element element = document.createElement(name);
        document.appendChild(element);
        return element;
    }

    public static Element getFirstChildElement(Node node) {
        Node child;
        for (child = node.getFirstChild(); child != null && child.getNodeType() != 1; child = child.getNextSibling()) {
        }
        return (Element)child;
    }

    public static Element getNextSiblingElement(Node node) {
        Node child;
        for (child = node.getNextSibling(); child != null && child.getNodeType() != 1; child = child.getNextSibling()) {
        }
        return (Element)child;
    }
}

