/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.soap;

import com.infor.erpln.c4ws.util.C4WSProperties;
import com.infor.erpln.c4ws.util.C4WSPropertiesManager;
import com.infor.erpln.jca.ConnectionFactoryImpl;
import com.infor.erpln.jca.ConnectionSpecImpl;
import com.infor.erpln.jca.bdeclient.BdeElementIterator;
import com.infor.erpln.jca.bdeclient.BdeException;
import com.infor.erpln.jca.bdeclient.BdeFilter;
import com.infor.erpln.jca.bdeclient.BdeSelection;
import com.infor.erpln.jca.bdeclient.JcaBdeManager;
import com.infor.erpln.soap.WSDLImporter;
import com.infor.erpln.soap.XMLUtil;
import java.util.ArrayList;
import java.util.Arrays;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionSpec;
import javax.servlet.ServletContext;
import javax.xml.parsers.DocumentBuilder;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSDLImporter {
    private static Logger LOG = ESAPI.getLogger(WSDLImporter.class);
    private ServletContext m_context;
    private String m_connectionPoint;
    private Connection m_jcaConnection = null;

    public WSDLImporter(ServletContext context) {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "constructor");
        this.m_context = context;
        this.m_connectionPoint = null;
    }

    public void initialize(String connectionPoint) throws Exception {
        if (LOG.isInfoEnabled()) {
            LOG.debug(Logger.EVENT_UNSPECIFIED, "initialize WSDL importer for connection point " + connectionPoint);
        }
        try {
            ConnectionFactoryImpl factory = (ConnectionFactoryImpl)this.m_context.getAttribute("com.infor.erpln.soap.connectionFactory");
            if (factory == null) {
                throw new ResourceException("no connection factory");
            }
            C4WSPropertiesManager man = (C4WSPropertiesManager)this.m_context.getAttribute("com.infor.erpln.c4ws.util.C4WSPropertiesManager");
            C4WSProperties properties = man.getProperties();
            ConnectionSpecImpl connectionSpec = properties.getConnectionSpec(connectionPoint);
            this.m_jcaConnection = factory.getConnection((ConnectionSpec)connectionSpec);
            if (this.m_jcaConnection == null) {
                throw new ResourceException("no connection");
            }
            this.m_connectionPoint = connectionPoint;
            if (LOG.isInfoEnabled()) {
                LOG.debug(Logger.EVENT_SUCCESS, "connection created for " + this.m_connectionPoint);
            }
        }
        catch (ResourceException e) {
            LOG.error(Logger.EVENT_FAILURE, "create connection failed", (Throwable)e);
            throw e;
        }
    }

    public void initialize(ConnectionSpecImpl connectionSpec) throws Exception {
        this.m_connectionPoint = connectionSpec.getConnectionPoint();
        if (this.m_connectionPoint == null) {
            this.m_connectionPoint = "[Cloud]";
        }
        if (LOG.isInfoEnabled()) {
            LOG.debug(Logger.EVENT_UNSPECIFIED, "Initialize WSDL importer for connectionSpec " + this.m_connectionPoint);
        }
        try {
            ConnectionFactoryImpl factory = (ConnectionFactoryImpl)this.m_context.getAttribute("com.infor.erpln.soap.connectionFactory");
            if (factory == null) {
                throw new ResourceException("no connection factory");
            }
            this.m_jcaConnection = factory.getConnection((ConnectionSpec)connectionSpec);
            if (this.m_jcaConnection == null) {
                throw new ResourceException("no connection");
            }
            if (LOG.isInfoEnabled()) {
                LOG.debug(Logger.EVENT_SUCCESS, "connection created for " + this.m_connectionPoint);
            }
        }
        catch (ResourceException e) {
            LOG.error(Logger.EVENT_FAILURE, "create connection failed", (Throwable)e);
        }
    }

    public void close() throws Exception {
        if (LOG.isInfoEnabled()) {
            LOG.debug(Logger.EVENT_UNSPECIFIED, "close connection for " + this.m_connectionPoint);
        }
        this.m_connectionPoint = null;
        try {
            this.m_jcaConnection.close();
            LOG.debug(Logger.EVENT_SUCCESS, "connection closed");
        }
        catch (ResourceException e) {
            LOG.error(Logger.EVENT_FAILURE, "failed to close connection", (Throwable)e);
            throw e;
        }
    }

    public String[] listWSDL() throws Exception {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "list WSDL");
        this.checkInit();
        try {
            JcaBdeManager jcaManager = new JcaBdeManager(this.m_jcaConnection);
            BdeSelection bdeSelection = null;
            bdeSelection = jcaManager.createBdeSelection();
            bdeSelection.addSelection("businessInterfaceDefinition");
            BdeFilter bdeFilter = jcaManager.createBdeFilter();
            BdeFilter.Expression comparisonNotEqual = bdeFilter.createComparisonNotEqual("BusinessInterfaceImplementationRuntime.wsdlStructure", null);
            bdeFilter.setExpression(comparisonNotEqual);
            BdeElementIterator bdeIterator = jcaManager.executeList("BusinessInterfaceImplementationRuntime", "List", bdeSelection, bdeFilter, -1);
            ArrayList<String> list = new ArrayList<String>();
            while (bdeIterator.hasNext()) {
                Element e = bdeIterator.nextElement();
                try {
                    Node nBusinessInterfaceImplementationRuntime = e.getFirstChild();
                    Node nbusinessInterfaceDefinition = nBusinessInterfaceImplementationRuntime.getFirstChild();
                    list.add(nbusinessInterfaceDefinition.getNodeValue());
                }
                catch (Exception exception) {}
            }
            String[] array = list.toArray(new String[0]);
            Arrays.sort(array, new StringComparator(this, null));
            if (LOG.isInfoEnabled()) {
                LOG.debug(Logger.EVENT_SUCCESS, "listWSDL returns " + array.length + " services");
            }
            return array;
        }
        catch (BdeException e) {
            LOG.error(Logger.EVENT_FAILURE, "failed to list WSDL services", (Throwable)e);
            throw e;
        }
    }

    public String getWSDL(String name) throws Exception {
        if (LOG.isInfoEnabled()) {
            LOG.debug(Logger.EVENT_UNSPECIFIED, "getWSDL for service " + name);
        }
        this.checkInit();
        try {
            JcaBdeManager jcaManager = new JcaBdeManager(this.m_jcaConnection);
            DocumentBuilder db = XMLUtil.getSecureDocumentBuilderFactory().newDocumentBuilder();
            Document d = db.newDocument();
            Element dt = d.createElement("BusinessInterfaceImplementationRuntime");
            Element i = (Element)dt.appendChild(d.createElement("businessInterfaceDefinition"));
            i.appendChild(d.createTextNode(name));
            Element eReply = jcaManager.executeMethod(dt, "Show");
            NodeList nl = eReply.getElementsByTagName("wsdlStructure");
            Node nWSDL = nl.item(0);
            String wsdl = null;
            if (nWSDL != null) {
                StringBuffer sb = new StringBuffer();
                for (Node child = nWSDL.getFirstChild(); child != null; child = child.getNextSibling()) {
                    if (child.getNodeType() != 3) continue;
                    sb.append(child.getNodeValue());
                }
                wsdl = sb.toString();
            }
            if (wsdl == null || wsdl.length() == 0) {
                LOG.error(Logger.EVENT_FAILURE, "response does not contain WSDL data");
                throw new Exception("There is no WSDL document available for " + name);
            }
            LOG.debug(Logger.EVENT_SUCCESS, "return WSDL string");
            return wsdl;
        }
        catch (BdeException e) {
            LOG.error(Logger.EVENT_FAILURE, "failed to get WSDL for service " + name, (Throwable)e);
            throw e;
        }
    }

    private void checkInit() throws Exception {
        if (this.m_connectionPoint == null) {
            LOG.error(Logger.EVENT_FAILURE, "WSDLImporter not initialized");
            throw new Exception("WSDLImporter not initialized");
        }
        if (this.m_jcaConnection == null) {
            LOG.error(Logger.EVENT_FAILURE, "WSDLImporter not connected");
            throw new Exception("WSDLImporter not connected");
        }
    }
}

