/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.soap;

import com.baan.b3.boi1.BoiException;
import com.baan.b3.boi1.BusinessObject;
import com.baan.b3.boi1.BusinessObjectManager;
import com.baan.b3.boi1.Iterator;
import com.baan.b3.boi1.metadata.IBusinessObjectMetadata;
import com.baan.b3.boi1.metadata.IIteratorMetadata;
import com.baan.b3.boi1.metadata.IManagerMetadata;
import com.baan.b3.boi1.metadata.IManagerMethodMetadata;
import com.baan.b3.boi1.metadata.IObjectMetadata;
import com.baan.b3.boi1.metadata.IParameterMetadata;
import com.infor.erpln.c4ws.util.C4WSProperties;
import com.infor.erpln.c4ws.util.C4WSPropertiesManager;
import com.infor.erpln.c4ws.util.ConnectionHelper;
import com.infor.erpln.jca.ConnectionFactoryImpl;
import com.infor.erpln.jca.bdeclient.JcaBdeManager;
import com.infor.erpln.jca.bdeclient.JcaBdeResultException;
import com.infor.erpln.soap.AdditionalSettings;
import com.infor.erpln.soap.XMLUtil;
import com.infor.erpln.soap.boi.BoiExplorer;
import com.infor.erpln.soap.conversion.IMessageConverter;
import com.infor.erpln.soap.conversion.IXslRepository;
import com.infor.erpln.soap.conversion.MessageConverter;
import com.infor.erpln.soap.conversion.XslRepository;
import com.infor.erpln.soap.servlet.ServletConnectionImpl;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.server.WebServiceContextDelegate;
import com.sun.xml.ws.server.InvokerTube;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.ws.Provider;
import javax.xml.ws.Service;
import javax.xml.ws.ServiceMode;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceProvider;
import javax.xml.ws.soap.SOAPFaultException;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * Exception performing whole class analysis ignored.
 */
@ServiceMode(value=Service.Mode.PAYLOAD)
@WebServiceProvider
public class ProviderImpl
implements Provider<Source> {
    private static Logger LOG = ESAPI.getLogger(ProviderImpl.class);
    private static final String NAMESPACE_BDE = "http://www.infor.com/businessinterface/";
    private static final String NAMESPACE_BOI = "http://www.infor.com/boi_interface/";
    private static final Pattern PATHINFO_PATTERN = Pattern.compile("/(\\w+)(/(\\w+))?");
    private IMessageConverter m_messageConverter;
    private IXslRepository m_xslRepository;

    public Source invoke(Source requestSource) {
        String namespaceURI = "";
        Connection connection = null;
        try {
            String service2;
            String boName;
            int index;
            LOG.debug(Logger.EVENT_UNSPECIFIED, "invoke()");
            Document document = XMLUtil.SourceToDocument((Source)requestSource);
            Element request = document.getDocumentElement();
            if (LOG.isDebugEnabled()) {
                LOG.debug(Logger.EVENT_UNSPECIFIED, "SOAP (Content) Request: " + XMLUtil.XmlToString((Node)request));
            }
            if ((namespaceURI = request.getNamespaceURI()) == null) {
                namespaceURI = "";
            }
            if ((index = (boName = namespaceURI).lastIndexOf(47)) >= 0) {
                boName = boName.substring(index + 1);
            }
            boolean conversionRequired = !namespaceURI.startsWith("http://www.infor.com/businessinterface/") && !namespaceURI.startsWith("http://www.infor.com/boi_interface/");
            String methodName = request.getLocalName();
            if (conversionRequired) {
                LOG.debug(Logger.EVENT_UNSPECIFIED, "Received non-LN Request \"" + methodName + "\", namespace: " + namespaceURI);
            } else {
                LOG.debug(Logger.EVENT_UNSPECIFIED, "Received Request for " + boName + " : method " + methodName);
            }
            Packet requestPacket = InvokerTube.getCurrentPacket();
            WebServiceContextDelegate delegate = requestPacket.webServiceContextDelegate;
            ServletConnectionImpl con = (ServletConnectionImpl)delegate;
            ServletContext context = con.getContext();
            con.getRequest().getSession();
            ConnectionFactoryImpl connectionFactory = (ConnectionFactoryImpl)context.getAttribute("com.infor.erpln.soap.connectionFactory");
            if (connectionFactory == null) {
                throw new Exception("no JCA connection factory");
            }
            String pathInfo = con.getPathInfo();
            Matcher matcher = PATHINFO_PATTERN.matcher(pathInfo);
            String connectionPoint = null;
            String service = null;
            if (matcher.matches()) {
                service = matcher.group(1);
                connectionPoint = matcher.group(3);
            }
            if (connectionPoint != null && (service2 = con.getServiceName()).length() > 1 && !service2.equals(service)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(Logger.EVENT_UNSPECIFIED, String.format("Service name (%1s) differs from BDE/BOI name (%2s)", service2, service));
                }
                service = service2;
            }
            connection = ConnectionHelper.getSOAPConnection((String)connectionPoint, (HttpServletRequest)con.getRequest(), (Message)requestPacket.getMessage());
            if (conversionRequired) {
                this.initMessageConverter(context);
                request = this.convertRequest(request, service);
                boName = MessageConverter.getBdeName((String)service);
                methodName = request.getLocalName();
            }
            String tag = methodName + "Response";
            Element response = XMLUtil.createElement((String)tag, (String)namespaceURI);
            if (namespaceURI.startsWith("http://www.infor.com/businessinterface/") || conversionRequired) {
                this.invokeBDE(boName, methodName, request, response, connection);
            } else if (namespaceURI.startsWith("http://www.infor.com/boi_interface/")) {
                boolean ignoreMetadata = AdditionalSettings.isIgnoreMetadata((String)service);
                this.invokeBOI(boName, methodName, request, response, connection, ignoreMetadata);
            }
            if (conversionRequired) {
                response = this.convertResponse(response, service);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(Logger.EVENT_SUCCESS, "SOAP (Content) Response: " + XMLUtil.XmlToString((Node)response));
            }
            DOMSource dOMSource = new DOMSource(response);
            return dOMSource;
        }
        catch (Throwable t) {
            LOG.error(Logger.EVENT_FAILURE, "Error in Provider invoke", t);
            SOAPFault fault = null;
            try {
                SOAPFactory factory = SOAPFactory.newInstance();
                String message = t.getMessage();
                fault = factory.createFault(message, new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server"));
                Detail detail = fault.addDetail();
                if (t instanceof BoiException) {
                    SOAPElement child = detail.addChildElement(new QName(namespaceURI, "BoiException"));
                    child.setTextContent(message);
                } else if (t instanceof JcaBdeResultException) {
                    SOAPElement result = detail.addChildElement(new QName(namespaceURI, "Result"));
                    Document doc = fault.getOwnerDocument();
                    Element resultElement = ((JcaBdeResultException)t).getResultElement();
                    Node copyResult = doc.importNode(resultElement, true);
                    Node resultChild = copyResult.getFirstChild();
                    while (resultChild != null) {
                        Node nextChild = resultChild.getNextSibling();
                        result.appendChild(resultChild);
                        resultChild = nextChild;
                    }
                } else {
                    Document doc = fault.getOwnerDocument();
                    while (t != null) {
                        String data = ProviderImpl.protectSpecialCharacters((String)t.getMessage());
                        if (data != null) {
                            SOAPElement child = detail.addChildElement(new QName(namespaceURI, "Exception"));
                            child.appendChild((Node)doc.createTextNode(data));
                        }
                        t = t.getCause();
                    }
                }
            }
            catch (Exception e) {
                LOG.fatal(Logger.EVENT_FAILURE, "Failed to create SOAP Fault element", (Throwable)e);
                throw new WebServiceException(t);
            }
            throw new SOAPFaultException(fault);
        }
        finally {
            if (connection != null) {
                LOG.debug(Logger.EVENT_UNSPECIFIED, "Closing JCA connection");
                try {
                    connection.close();
                }
                catch (ResourceException e) {
                    LOG.debug(Logger.EVENT_FAILURE, "Close failed: " + e.getMessage());
                }
            }
        }
    }

    private static C4WSProperties getC4WSProperties(ServletContext context) {
        C4WSPropertiesManager c4wsPropertiesManager = (C4WSPropertiesManager)context.getAttribute("com.infor.erpln.c4ws.util.C4WSPropertiesManager");
        return c4wsPropertiesManager != null ? c4wsPropertiesManager.getProperties() : null;
    }

    public static String protectSpecialCharacters(String originalUnprotectedString) {
        if (originalUnprotectedString == null) {
            return null;
        }
        boolean anyCharactersProtected = false;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < originalUnprotectedString.length(); ++i) {
            boolean characterWithSpecialMeaningInXML;
            char ch = originalUnprotectedString.charAt(i);
            boolean controlCharacter = ch < ' ';
            boolean unicodeButNotAscii = ch > '~';
            boolean bl = characterWithSpecialMeaningInXML = ch == '<' || ch == '&' || ch == '>';
            if (characterWithSpecialMeaningInXML || unicodeButNotAscii || controlCharacter) {
                stringBuffer.append("&#" + ch + ";");
                anyCharactersProtected = true;
                continue;
            }
            stringBuffer.append(ch);
        }
        if (!anyCharactersProtected) {
            return originalUnprotectedString;
        }
        return stringBuffer.toString();
    }

    private void invokeBDE(String boName, String methodName, Element request, Element response, Connection connection) throws Exception {
        Element bdeData = XMLUtil.getFirstChildElement((Node)request);
        if (bdeData == null) {
            throw new Exception("no BDE data in request");
        }
        JcaBdeManager manager = new JcaBdeManager(connection, true);
        Element result = manager.doBdeCall(boName, methodName, bdeData);
        Node importedNode = response.getOwnerDocument().importNode(result, true);
        response.appendChild(importedNode);
    }

    private void invokeBOI(String boName, String methodName, Element request, Element response, Connection connection, boolean ignoreMetadata) throws Exception {
        Object result;
        BusinessObject bo;
        String className = BoiExplorer.getInstance().getClassName(boName);
        if (className == null) {
            throw new Exception("Unknown BOI name " + boName);
        }
        Class<?> cls = Class.forName(className);
        Method retrieveMetadataMethod = cls.getMethod("retrieveMetadata", new Class[0]);
        Object metaDataObj = retrieveMetadataMethod.invoke(null, new Object[0]);
        IManagerMetadata managerMetadata = (IManagerMetadata)metaDataObj;
        IManagerMethodMetadata[] methods = managerMetadata.getMethods2();
        IManagerMethodMetadata method = null;
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(methodName)) continue;
            method = methods[i];
            break;
        }
        if (method == null) {
            throw new Exception("Unknown method " + methodName);
        }
        Constructor<?> constructor = cls.getConstructor(new Class[0]);
        Object obj = constructor.newInstance(new Object[0]);
        if (!(obj instanceof BusinessObjectManager)) {
            throw new Exception("'" + cls.toString() + "' is not a BusinessObjectManager");
        }
        BusinessObjectManager boiManager = (BusinessObjectManager)obj;
        IParameterMetadata[] parametersMetadata = method.getParameters();
        Element parameterElement = XMLUtil.getFirstChildElement((Node)request);
        ArrayList<String> parameters = new ArrayList<String>();
        for (int i = 0; i < parametersMetadata.length; ++i) {
            IParameterMetadata parameterMetadata = parametersMetadata[i];
            if (parameterMetadata.getScope().equals(IParameterMetadata.SCOPE_OUT)) continue;
            IObjectMetadata parameterType = parameterMetadata.getType();
            if (parameterElement == null) {
                throw new Exception("Invalid number of parameters, expected " + parametersMetadata.length);
            }
            if (parameterType.isPrimal()) {
                String parameterValue = parameterElement.getTextContent();
                parameters.add(parameterValue);
            } else {
                IBusinessObjectMetadata boMetadata = parameterType.getBusinessObjectMetadata();
                bo = (BusinessObject)boMetadata.newInstance();
                bo.setXMLContent(parameterElement, ignoreMetadata);
                parameters.add((String)bo);
            }
            parameterElement = XMLUtil.getNextSiblingElement((Node)parameterElement);
        }
        if (parameterElement != null) {
            throw new Exception("Invalid number of parameters");
        }
        boiManager.attachConnection(connection);
        try {
            result = method.invokeWithStrings((Object)boiManager, parameters.toArray());
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw new Exception(t);
        }
        boiManager.detachConnection();
        Document responseDoc = response.getOwnerDocument();
        IParameterMetadata returnMetadata = method.getReturnType();
        IObjectMetadata returnType = returnMetadata.getType();
        if (returnType instanceof IBusinessObjectMetadata) {
            if (result != null) {
                bo = (BusinessObject)result;
                Element returnElement = bo.getXMLContent(responseDoc);
                response.appendChild(returnElement);
            }
        } else if (returnType instanceof IIteratorMetadata) {
            IBusinessObjectMetadata itemMetadata = ((IIteratorMetadata)returnType).getBusinessObjectType();
            String iteratorName = itemMetadata.getProxyName() + "List";
            Element iteratorElement = responseDoc.createElement(iteratorName);
            response.appendChild(iteratorElement);
            if (result != null) {
                Iterator iter = (Iterator)result;
                while (iter.hasMoreElements()) {
                    BusinessObject bo2 = iter.nextElement();
                    Element returnElement = bo2.getXMLContent(responseDoc);
                    iteratorElement.appendChild(returnElement);
                }
            }
        } else {
            throw new Exception("Internal error");
        }
    }

    private Element convertRequest(Element request, String service) {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "Trying to convert non-LN request into BDE request");
        Document document = this.m_messageConverter.convert(request, service);
        if (document != null) {
            return document.getDocumentElement();
        }
        LOG.debug(Logger.EVENT_FAILURE, "Conversion was unsuccessful. Request has not been changed.");
        return request;
    }

    private Element convertResponse(Element response, String service) {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "Converting BDE response into non-LN response");
        Document document = this.m_messageConverter.convert(response, service);
        if (document != null) {
            return document.getDocumentElement();
        }
        LOG.debug(Logger.EVENT_FAILURE, "Conversion was unsuccessful. Response has not been changed.");
        return response;
    }

    private void initMessageConverter(ServletContext context) {
        if (this.m_messageConverter == null) {
            C4WSProperties c4wsProperties = ProviderImpl.getC4WSProperties((ServletContext)context);
            String configFolder = c4wsProperties.getConfigFolder();
            File xslFolder = new File(configFolder, "wsdl");
            this.m_xslRepository = XslRepository.getOrCreateInstance((File)xslFolder);
            this.m_messageConverter = new MessageConverter(this.m_xslRepository);
        }
    }
}

