/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.soap;

import com.infor.erpln.soap.conversion.MessageConverter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.w3c.dom.Element;

public class Endpoint {
    private String m_name;
    private String m_wsdlFileName;
    private String m_implementation;
    private String m_pattern;
    private String m_serviceName;
    private String m_portName;

    public Endpoint() {
    }

    public Endpoint(Element element) {
        this.m_name = element.getAttribute("name");
        this.m_implementation = element.getAttribute("implementation");
        this.m_wsdlFileName = element.getAttribute("wsdl");
        this.m_serviceName = element.getAttribute("service");
        this.m_portName = element.getAttribute("port");
        this.m_pattern = element.getAttribute("url-pattern");
    }

    public String getName() {
        return this.m_name;
    }

    public String getBDEName() {
        return MessageConverter.getBdeName((String)this.m_name);
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getWsdlFileName() {
        return this.m_wsdlFileName;
    }

    public void setWsdlFileName(String wsdlFileName) {
        this.m_wsdlFileName = wsdlFileName;
    }

    public String getImplementation() {
        return this.m_implementation;
    }

    public void setImplementation(String implementation) {
        this.m_implementation = implementation;
    }

    public String getPattern() {
        return this.m_pattern;
    }

    public void setPattern(String pattern) {
        this.m_pattern = pattern;
    }

    public String getServiceName() {
        return this.m_serviceName;
    }

    public void setServiceName(String name) {
        this.m_serviceName = name;
    }

    public String getPortName() {
        return this.m_portName;
    }

    public void setPortName(String name) {
        this.m_portName = name;
    }

    public String getConnectionPoint() {
        String pattern;
        try {
            pattern = URLDecoder.decode(this.m_pattern, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            pattern = this.m_pattern;
        }
        int index = pattern.lastIndexOf(47);
        if (index > 0) {
            return pattern.substring(index + 1);
        }
        return pattern;
    }

    public String getType() {
        if (this.m_serviceName.startsWith("{http://www.infor.com/businessinterface/")) {
            return "BDE";
        }
        if (this.m_serviceName.startsWith("{http://www.infor.com/boi_interface/")) {
            return "BOI";
        }
        return "?";
    }
}

