/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.soap;

import com.infor.erpln.c4ws.util.C4WSPropertiesManager;
import com.infor.erpln.soap.AdditionalSettings;
import com.infor.erpln.soap.DeploymentDescriptor;
import com.infor.erpln.soap.Endpoint;
import com.infor.erpln.soap.XMLUtil;
import com.infor.erpln.soap.servlet.WSServletContextListener;
import com.sun.xml.ws.wsdl.parser.WSDLConstants;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import javax.servlet.ServletContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DeploymentDescriptor {
    private static Logger LOG = ESAPI.getLogger(DeploymentDescriptor.class);
    private static final String JAXWS_RI_RUNTIME = "sun-jaxws.xml";
    private static final String CLOUD_DESCRIPTOR_FILE = "cloud-jaxws.xml";
    private ServletContext m_context = null;
    private String m_wsdlBackupFolder = null;
    private String m_filename;
    private boolean m_configInWebInf;

    public DeploymentDescriptor(ServletContext context) {
        String configLocation;
        LOG.debug(Logger.EVENT_UNSPECIFIED, "constructor");
        this.m_context = context;
        C4WSPropertiesManager c4wsPropertiesManager = (C4WSPropertiesManager)context.getAttribute("com.infor.erpln.c4ws.util.C4WSPropertiesManager");
        boolean cloudEnabled = c4wsPropertiesManager != null && c4wsPropertiesManager.getProperties().isCloudEnabled();
        String defaultLocation = context.getRealPath("/WEB-INF");
        if (!defaultLocation.endsWith(File.separator)) {
            defaultLocation = defaultLocation + File.separator;
        }
        String string = configLocation = c4wsPropertiesManager != null ? c4wsPropertiesManager.getProperties().getConfigFolder() : null;
        if (configLocation == null) {
            configLocation = defaultLocation;
            this.m_configInWebInf = true;
        } else {
            if (!configLocation.endsWith(File.separator)) {
                configLocation = configLocation + File.separator;
            }
            this.m_configInWebInf = false;
        }
        String fileNameWithoutPath = cloudEnabled ? CLOUD_DESCRIPTOR_FILE : JAXWS_RI_RUNTIME;
        this.m_filename = configLocation + fileNameWithoutPath;
        if (LOG.isDebugEnabled()) {
            LOG.debug(Logger.EVENT_UNSPECIFIED, "Deployment descriptor file: " + this.m_filename);
        }
        if (!this.m_configInWebInf) {
            File file;
            this.m_wsdlBackupFolder = configLocation + "wsdl";
            File backupFolder = new File(this.m_wsdlBackupFolder);
            if (!backupFolder.exists()) {
                backupFolder.mkdirs();
            }
            if (!(file = new File(this.m_filename)).exists()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(Logger.EVENT_UNSPECIFIED, "File " + fileNameWithoutPath + " is missing, copy from WEB-INF");
                }
                File sourceFile = new File(defaultLocation + fileNameWithoutPath);
                this.copyFile(sourceFile, file);
            }
        }
    }

    public String getFilename() {
        return this.m_filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Endpoint[] listEndpoints() throws Exception {
        String string = JAXWS_RI_RUNTIME;
        synchronized (JAXWS_RI_RUNTIME) {
            LOG.debug(Logger.EVENT_UNSPECIFIED, "listEndpoints called");
            ArrayList<Endpoint> result = new ArrayList<Endpoint>();
            Document doc = this.readFile();
            Element root = doc.getDocumentElement();
            if (!root.getTagName().equals("endpoints")) {
                throw new Exception("Deployment descriptor does not contain endpoints");
            }
            for (Node child = root.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNodeType() != 1 || !child.getNodeName().equals("endpoint")) continue;
                Endpoint endpoint = new Endpoint((Element)child);
                result.add(endpoint);
            }
            Endpoint[] array = result.toArray(new Endpoint[0]);
            Arrays.sort(array, new EndpointComparator(this, null));
            if (LOG.isDebugEnabled()) {
                LOG.debug(Logger.EVENT_SUCCESS, "listEndpoints returns " + array.length + " endpoints");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return array;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Endpoint getEndpoint(String name) throws Exception {
        String string = JAXWS_RI_RUNTIME;
        synchronized (JAXWS_RI_RUNTIME) {
            Document doc;
            Element element;
            if (LOG.isDebugEnabled()) {
                LOG.debug(Logger.EVENT_UNSPECIFIED, "getEndpoint called for name " + name);
            }
            if ((element = this.findEndpoint(doc = this.readFile(), name)) != null) {
                LOG.debug(Logger.EVENT_SUCCESS, "returned endpoint");
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return new Endpoint(element);
            }
            LOG.debug(Logger.EVENT_SUCCESS, "endpoint not found, returns null");
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Endpoint endpoint) throws Exception {
        String string = JAXWS_RI_RUNTIME;
        synchronized (JAXWS_RI_RUNTIME) {
            String portName;
            Document doc;
            Element element;
            String name = endpoint.getName();
            if (LOG.isDebugEnabled()) {
                LOG.debug(Logger.EVENT_UNSPECIFIED, "add endpoint " + name);
            }
            if ((element = this.findEndpoint(doc = this.readFile(), name)) != null) {
                LOG.debug(Logger.EVENT_UNSPECIFIED, "endpoint already present, update it");
            } else {
                element = doc.createElementNS("http://java.sun.com/xml/ns/jax-ws/ri/runtime", "endpoint");
                Element root = doc.getDocumentElement();
                root.appendChild(element);
            }
            element.setAttribute("name", endpoint.getName());
            element.setAttribute("implementation", endpoint.getImplementation());
            element.setAttribute("wsdl", endpoint.getWsdlFileName());
            element.setAttribute("url-pattern", endpoint.getPattern());
            String serviceName = endpoint.getServiceName();
            if (serviceName != null) {
                element.setAttribute("service", serviceName);
            }
            if ((portName = endpoint.getPortName()) != null) {
                element.setAttribute("port", portName);
            }
            this.writeFile(doc);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public String add(String name, Document wsdl, String connectionpoint) throws Exception {
        String uname = this.makeUniqueName(name, connectionpoint);
        Endpoint endpoint = new Endpoint();
        endpoint.setName(uname);
        endpoint.setImplementation("com.infor.erpln.soap.ProviderImpl");
        endpoint.setWsdlFileName("WEB-INF/wsdl/" + name + ".wsdl");
        endpoint.setPattern("/services/" + this.encode(name) + "/" + this.encode(connectionpoint));
        endpoint.setServiceName(this.getServiceName(wsdl));
        endpoint.setPortName(this.getPortName(wsdl));
        this.add(endpoint);
        try {
            File wsdlFolder = new File(this.m_context.getRealPath("/WEB-INF/wsdl"));
            if (!wsdlFolder.exists()) {
                wsdlFolder.mkdir();
            }
            this.writeFile(wsdl, this.m_context.getRealPath("/" + endpoint.getWsdlFileName()));
        }
        catch (Exception ex) {
            this.remove(endpoint);
            throw ex;
        }
        if (this.m_wsdlBackupFolder != null) {
            this.writeFile(wsdl, this.m_wsdlBackupFolder + File.separator + name + ".wsdl");
        }
        return uname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Endpoint endpoint) throws Exception {
        String string = JAXWS_RI_RUNTIME;
        synchronized (JAXWS_RI_RUNTIME) {
            Document doc;
            Element element;
            String name = endpoint.getName();
            if (LOG.isDebugEnabled()) {
                LOG.debug(Logger.EVENT_UNSPECIFIED, "remove endpoint " + name);
            }
            if ((element = this.findEndpoint(doc = this.readFile(), name)) != null) {
                Node sibling = element.getNextSibling();
                if (sibling != null && sibling.getNodeType() == 3) {
                    sibling.getParentNode().removeChild(sibling);
                }
                element.getParentNode().removeChild(element);
                this.writeFile(doc);
            } else {
                LOG.debug(Logger.EVENT_UNSPECIFIED, "endpoint not found, file not changed");
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void remove(String name) throws Exception {
        Endpoint endpoint = this.getEndpoint(name);
        if (endpoint != null) {
            this.remove(endpoint);
            if (this.canRemoveWsdl(endpoint.getWsdlFileName())) {
                this.removeFile(this.m_context.getRealPath("/" + endpoint.getWsdlFileName()));
                if (this.m_wsdlBackupFolder != null) {
                    this.removeFile(this.m_wsdlBackupFolder + File.separator + endpoint.getName() + ".wsdl");
                }
            }
            if (AdditionalSettings.removeIgnoreMetadata((String)name)) {
                AdditionalSettings.save();
            }
        } else {
            LOG.debug(Logger.EVENT_UNSPECIFIED, "endpoint not found, file not changed");
        }
    }

    public void reload() throws Exception {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "reload the servlet");
        WSServletContextListener listener = (WSServletContextListener)this.m_context.getAttribute("com.infor.erpln.soap.servlet.contextListener");
        listener.reload(this.m_context);
    }

    public void checkWSDL() {
        File backupFolder;
        if (this.m_wsdlBackupFolder != null && (backupFolder = new File(this.m_wsdlBackupFolder)).exists() && backupFolder.isDirectory()) {
            File[] wsdlFiles;
            String destinationPath;
            if (LOG.isDebugEnabled()) {
                LOG.debug(Logger.EVENT_UNSPECIFIED, "checkWSDL backup folder is " + this.m_wsdlBackupFolder);
            }
            if (!(destinationPath = this.m_context.getRealPath("/WEB-INF/wsdl/")).endsWith(File.separator)) {
                destinationPath = destinationPath + File.separator;
            }
            if ((wsdlFiles = backupFolder.listFiles((FilenameFilter)new /* Unavailable Anonymous Inner Class!! */)) != null) {
                for (File sourceFile : wsdlFiles) {
                    String name = sourceFile.getName();
                    File destinationFile = new File(destinationPath + name);
                    if (destinationFile.exists()) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(Logger.EVENT_UNSPECIFIED, "File " + name + " is missing, copy from backup");
                    }
                    this.copyFile(sourceFile, destinationFile);
                }
            }
        }
    }

    public boolean isConnectionPointInUse(String connectionPoint) {
        try {
            Endpoint[] endpoints = this.listEndpoints();
            for (int i = 0; i < endpoints.length; ++i) {
                Endpoint endpoint = endpoints[i];
                if (!endpoint.getConnectionPoint().equals(connectionPoint)) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private String makeUniqueName(String name, String connectionPoint) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(Logger.EVENT_UNSPECIFIED, "makeUniqueName called for name=" + name + " and connectionPoint=" + connectionPoint);
        }
        try {
            Endpoint endpoint = this.getEndpoint(name);
            if (endpoint != null) {
                String base = name;
                int nr = 1;
                while (!endpoint.getConnectionPoint().equals(connectionPoint)) {
                    name = base + "_" + ++nr;
                    endpoint = this.getEndpoint(name);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(Logger.EVENT_SUCCESS, "makeUniqueName returns name=" + name);
        }
        return name;
    }

    private boolean canRemoveWsdl(String path) {
        try {
            Endpoint[] endpoints = this.listEndpoints();
            for (int i = 0; i < endpoints.length; ++i) {
                Endpoint endpoint = endpoints[i];
                if (!endpoint.getWsdlFileName().equals(path)) continue;
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    private void copyFile(File src, File dst) {
        try {
            int len;
            if (LOG.isDebugEnabled()) {
                LOG.debug(Logger.EVENT_UNSPECIFIED, "Copy from " + src + " to " + dst);
            }
            if (!dst.getParentFile().exists()) {
                LOG.debug(Logger.EVENT_UNSPECIFIED, "Creating destination folder");
                dst.getParentFile().mkdirs();
            }
            FileInputStream in = new FileInputStream(src);
            FileOutputStream out = new FileOutputStream(dst);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
        catch (Exception ex) {
            LOG.error(Logger.EVENT_FAILURE, "Failed to copy from " + src + " to " + dst, (Throwable)ex);
        }
    }

    private Document readFile() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug(Logger.EVENT_UNSPECIFIED, "readFile " + this.m_filename);
        }
        FileInputStream is = new FileInputStream(this.m_filename);
        DocumentBuilderFactory docFactory = XMLUtil.getSecureDocumentBuilderFactory();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.parse(is);
        ((InputStream)is).close();
        LOG.debug(Logger.EVENT_SUCCESS, "readFile completed");
        return doc;
    }

    private void writeFile(Document doc) throws Exception {
        this.writeFile(doc, this.m_filename);
    }

    private void writeFile(Document doc, String filename) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug(Logger.EVENT_UNSPECIFIED, "writeFile " + filename);
        }
        DOMSource source = new DOMSource(doc);
        FileOutputStream os = new FileOutputStream(filename);
        StreamResult result = new StreamResult(os);
        TransformerFactory factory = XMLUtil.getSecureTransformerFactory();
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("version", "1.0");
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(source, result);
        ((OutputStream)os).close();
        LOG.debug(Logger.EVENT_SUCCESS, "writeFile completed");
    }

    private void removeFile(String filename) throws Exception {
        File f = new File(filename);
        f.delete();
    }

    private Element findEndpoint(Document doc, String name) throws Exception {
        Element root = doc.getDocumentElement();
        if (!root.getTagName().equals("endpoints")) {
            throw new Exception("Deployment descriptor does not contain endpoints");
        }
        for (Node child = root.getFirstChild(); child != null; child = child.getNextSibling()) {
            Element element;
            String attrname;
            if (child.getNodeType() != 1 || !child.getNodeName().equals("endpoint") || !name.equals(attrname = (element = (Element)child).getAttribute("name"))) continue;
            return element;
        }
        return null;
    }

    private String encode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return s;
        }
    }

    private String getServiceName(Document wsdl) throws Exception {
        Element definitions = wsdl.getDocumentElement();
        QName n = new QName(definitions.getNamespaceURI(), definitions.getLocalName());
        if (!n.equals(WSDLConstants.QNAME_DEFINITIONS)) {
            throw new Exception("Invalid WSDL file");
        }
        String namespace = definitions.getAttribute("targetNamespace");
        NodeList services = definitions.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "service");
        if (services.getLength() != 1) {
            throw new Exception("Invalid WSDL file: does not contain 1 <service>");
        }
        Element service = (Element)services.item(0);
        return "{" + namespace + "}" + service.getAttribute("name");
    }

    private String getPortName(Document wsdl) throws Exception {
        Element definitions = wsdl.getDocumentElement();
        QName n = new QName(definitions.getNamespaceURI(), definitions.getLocalName());
        if (!n.equals(WSDLConstants.QNAME_DEFINITIONS)) {
            throw new Exception("Invalid WSDL file: does not contain <definitions>");
        }
        String namespace = definitions.getAttribute("targetNamespace");
        NodeList services = definitions.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "service");
        if (services.getLength() != 1) {
            throw new Exception("Invalid WSDL file: <definitions> does not contain 1 <service>");
        }
        Element service = (Element)services.item(0);
        NodeList ports = service.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "port");
        if (ports.getLength() != 1) {
            throw new Exception("Invalid WSDL file: <service> does not contain 1 <port>");
        }
        Element port = (Element)ports.item(0);
        return "{" + namespace + "}" + port.getAttribute("name");
    }
}

