/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.soap;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class AdditionalSettings {
    private static Logger LOG = ESAPI.getLogger(AdditionalSettings.class);
    private static final String FILENAME = "extra.properties";
    private static final String FILE_COMMENTS = "C4WS additional settings.";
    private static final String IGNOREMETADATA_PREFIX = "ignoremetadata.";
    private static Properties properties;
    private static File settingsFile;

    public static void initialize(String configLocation) {
        properties = new Properties();
        settingsFile = new File(configLocation + File.separator + "extra.properties");
        if (settingsFile.exists()) {
            FileInputStream inStream = null;
            try {
                inStream = new FileInputStream(settingsFile);
                properties.load(inStream);
            }
            catch (IOException e) {
                LOG.warning(Logger.EVENT_UNSPECIFIED, "Could not load additional settings", (Throwable)e);
            }
            finally {
                if (inStream != null) {
                    try {
                        ((InputStream)inStream).close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean save() {
        FileOutputStream outStream = null;
        try {
            outStream = new FileOutputStream(settingsFile);
            properties.store(outStream, "C4WS additional settings.");
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            LOG.error(Logger.EVENT_FAILURE, "Could not save additional settings", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (outStream != null) {
                try {
                    ((OutputStream)outStream).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String getProperty(String name) {
        return properties.getProperty(name);
    }

    public static void setProperty(String name, String value) {
        properties.setProperty(name, name);
    }

    public static boolean removeProperty(String name) {
        Object removed = properties.remove(name);
        return removed != null;
    }

    public static boolean getBooleanProperty(String name) {
        return Boolean.parseBoolean(properties.getProperty(name));
    }

    public static void setBooleanProperty(String name, boolean value) {
        properties.setProperty(name, String.valueOf(value));
    }

    public static boolean isIgnoreMetadata(String serviceName) {
        return AdditionalSettings.getBooleanProperty((String)("ignoremetadata." + serviceName));
    }

    public static void setIgnoreMetadata(String serviceName, boolean ignore) {
        AdditionalSettings.setBooleanProperty((String)("ignoremetadata." + serviceName), (boolean)ignore);
    }

    public static boolean removeIgnoreMetadata(String serviceName) {
        return AdditionalSettings.removeProperty((String)("ignoremetadata." + serviceName));
    }
}

