/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.rest.ims.multipart;

import com.infor.erpln.rest.ims.multipart.InMemoryItemFactory;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;

public class MultipartRequest {
    private static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    private static final String APPLICATION_JSON = "application/json";
    private static final Logger LOG = ESAPI.getLogger(MultipartRequest.class);
    private static final FileItemFactory factory = new InMemoryItemFactory();
    private boolean valid;
    private byte[] parameters;
    private byte[] payload;

    public MultipartRequest(HttpServletRequest request) {
        this.parse(request);
    }

    public byte[] getParameters() {
        return this.parameters;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public boolean isValid() {
        return this.valid;
    }

    private void parse(HttpServletRequest request) {
        try {
            List itemList = new ServletFileUpload(factory).parseRequest(request);
            for (FileItem item : itemList) {
                String contentType = item.getContentType();
                if (contentType == null) continue;
                if (contentType.startsWith(APPLICATION_OCTET_STREAM)) {
                    this.payload = item.get();
                    continue;
                }
                if (contentType.startsWith(APPLICATION_JSON)) {
                    this.parameters = item.get();
                    continue;
                }
                LOG.warning(Logger.EVENT_FAILURE, "multipartMessage contains unknown part: Content-Type = " + contentType);
            }
            this.valid = this.payload != null && this.parameters != null;
        }
        catch (FileUploadException ex) {
            LOG.error(Logger.EVENT_FAILURE, "Could not parse the multipart message", (Throwable)ex);
        }
        catch (Throwable t) {
            LOG.error(Logger.EVENT_FAILURE, "Unexpected error when parsing the multipart message", t);
        }
    }
}

