/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.rest.ims.multipart;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.fileupload.FileItem;

public class InMemoryItem
implements FileItem {
    private static final long serialVersionUID = 1L;
    private String fieldName;
    private String contentType;
    private boolean isFormField;
    private String fileName;
    private ByteArrayOutputStream memoryStream = new ByteArrayOutputStream();

    public InMemoryItem(String fieldName, String contentType, boolean isFormField, String fileName) {
        this.fieldName = fieldName;
        this.contentType = contentType;
        this.isFormField = isFormField;
        this.fileName = fileName;
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.memoryStream.toByteArray());
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getName() {
        return this.fileName;
    }

    public boolean isInMemory() {
        return true;
    }

    public long getSize() {
        return this.memoryStream.size();
    }

    public byte[] get() {
        return this.memoryStream.toByteArray();
    }

    public String getString(String encoding) throws UnsupportedEncodingException {
        return this.memoryStream.toString(encoding);
    }

    public String getString() {
        return this.memoryStream.toString();
    }

    public void write(File file) throws IOException {
        try (FileOutputStream out = new FileOutputStream(file);){
            out.write(this.memoryStream.toByteArray());
        }
    }

    public void delete() {
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String name) {
        this.fieldName = name;
    }

    public boolean isFormField() {
        return this.isFormField;
    }

    public void setFormField(boolean state) {
        this.isFormField = state;
    }

    public OutputStream getOutputStream() {
        return this.memoryStream;
    }
}

