/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.rest.ims;

import com.infor.erpln.c4ws.util.ConnectionHelper;
import com.infor.erpln.jca.BODResponse;
import com.infor.erpln.jca.ConnectionImpl;
import com.infor.erpln.jca.dllclient.BaanDLLCall;
import com.infor.erpln.jca.dllclient.BaanDLLCallException;
import com.infor.erpln.rest.ims.HttpXmlDispatchCall;
import com.infor.erpln.rest.ims.HttpXmlRequest;
import com.infor.erpln.rest.ims.HttpXmlResponse;
import com.infor.erpln.rest.ims.IMSv2Servlet;
import com.infor.erpln.rest.ims.multipart.MultipartRequest;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.HTTPUtilities;
import org.owasp.esapi.Logger;
import org.owasp.esapi.Validator;

/*
 * Exception performing whole class analysis ignored.
 */
public class IMSv2Servlet
extends HttpServlet {
    private static final String OPERATION_DISCOVERY = "/discovery";
    private static final String OPERATION_MULTIPART_MESSAGE = "/multipartMessage";
    private static final String OPERATION_PING = "/ping";
    private static final String OPERATION_PROTOCOL = "/protocol";
    private static final String METHOD_GET = "GET";
    private static final String METHOD_POST = "POST";
    private static final String CONTENT_TYPE = "Content-Type";
    static final String CONTENT_TYPE_JSON_UTF8 = "application/json;charset=UTF-8";
    private static final String PING_RESPONSE = "{\"status\":\"OK\",\"code\":200}";
    private static final String HTTP_XML_REQUEST_VERSION = "1.0";
    private static final String HTTP_XML_BASE_URI = "/es_server/management/v2/ionims/service";
    private static final String HTTP_XML_SERVICE = "ION_IMS_V2";
    private static final Logger LOG = ESAPI.getLogger(IMSv2Servlet.class);
    private static final Validator VALIDATOR = ESAPI.validator();
    private static final HTTPUtilities HTTP_UTILS = ESAPI.httpUtilities();
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RequestComponents components;
        if (LOG.isDebugEnabled()) {
            LOG.debug(Logger.EVENT_UNSPECIFIED, "REST request: GET " + request.getRequestURI());
        }
        if (!(components = RequestComponents.create((HttpServletRequest)request)).isOk()) {
            LOG.error(Logger.EVENT_FAILURE, String.format("Unknown GET request '%s'", request.getRequestURI()));
            response.setStatus(400);
        } else if (components.getVersion() != null) {
            LOG.error(Logger.EVENT_FAILURE, String.format("Unsupported GET request '%s'", request.getRequestURI()));
            response.setStatus(400);
        } else if ("/ping".equals(components.getOperation())) {
            this.handlePing(request, response);
        } else if ("/protocol".equals(components.getOperation())) {
            this.handleProtocol(request, response);
        } else {
            LOG.error(Logger.EVENT_FAILURE, String.format("Unknown GET request '/%s'", components.getOperation()));
            response.setStatus(400);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RequestComponents components;
        if (LOG.isDebugEnabled()) {
            LOG.debug(Logger.EVENT_UNSPECIFIED, "REST request: POST " + request.getRequestURI());
        }
        if (!(components = RequestComponents.create((HttpServletRequest)request)).isOk() || components.getVersion() == null) {
            LOG.error(Logger.EVENT_FAILURE, String.format("Unsupported POST request '%s'", request.getRequestURI()));
            response.setStatus(400);
        } else if (!components.isSupportedVersion()) {
            LOG.error(Logger.EVENT_FAILURE, String.format("Unsupported version number '%s' in request URI", components.getVersion()));
            response.setStatus(400);
        } else if ("/discovery".equals(components.getOperation())) {
            this.handleDiscovery(request, response, components);
        } else if ("/multipartMessage".equals(components.getOperation())) {
            this.handleMultipartMessage(request, response, components);
        } else {
            LOG.error(Logger.EVENT_FAILURE, String.format("Unknown POST request '/v2/%s'", components.getOperation()));
            response.setStatus(400);
        }
    }

    private void handlePing(HttpServletRequest request, HttpServletResponse response) {
        try {
            Connection connection = ConnectionHelper.getIMSFarmConnection((HttpServletRequest)request);
            connection.close();
            response.setContentType("application/json;charset=UTF-8");
            try (PrintWriter writer = response.getWriter();){
                writer.write("{\"status\":\"OK\",\"code\":200}");
            }
            catch (IOException e) {
                response.setStatus(500);
            }
        }
        catch (ConnectionHelper.OAuthValidationException ex) {
            LOG.error(Logger.EVENT_FAILURE, String.format("OAuth validation failed with error code %d: %s", ex.getStatus().getErrorCode(), ex.getStatus().getErrorMessage()));
            response.setStatus(401);
        }
        catch (ResourceException ex) {
            LOG.error(Logger.EVENT_FAILURE, String.format("Connection could not be established: %s", ex.getMessage()));
            response.setStatus(500);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleProtocol(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Connection connection = null;
        try {
            connection = ConnectionHelper.getIMSFarmConnection((HttpServletRequest)request);
            String httpVersion = this.getHttpProtocolVersion(request);
            Map headers = this.getAllHeaders(request);
            HttpXmlRequest xmlRequest = new HttpXmlRequest("1.0", "GET", "/es_server/management/v2/ionims/service" + request.getPathInfo(), httpVersion, "ION_IMS_V2", headers, null);
            HttpXmlDispatchCall call = new HttpXmlDispatchCall(new BaanDLLCall(connection, null));
            HttpXmlResponse xmlResponse = call.doCall(xmlRequest);
            this.processResponse(xmlResponse, response);
        }
        catch (ConnectionHelper.OAuthValidationException ex) {
            LOG.error(Logger.EVENT_FAILURE, String.format("OAuth validation failed with error code %d: %s", ex.getStatus().getErrorCode(), ex.getStatus().getErrorMessage()));
            response.setStatus(401);
        }
        catch (ResourceException ex) {
            LOG.error(Logger.EVENT_FAILURE, String.format("Connection could not be established: %s", ex.getMessage()));
            response.setStatus(500);
        }
        catch (BaanDLLCallException ex) {
            LOG.error(Logger.EVENT_FAILURE, String.format("Failed to execute DLL call: %s", ex.getMessage()));
            response.setStatus(500);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (ResourceException e) {
                    LOG.warning(Logger.EVENT_UNSPECIFIED, e.getMessage());
                }
            }
        }
    }

    private String getHttpProtocolVersion(HttpServletRequest request) {
        String version = request.getProtocol();
        version = version.substring(version.indexOf(47) + 1);
        return version;
    }

    private Map<String, String> getAllHeaders(HttpServletRequest request) {
        HashMap<String, String> headers = new HashMap<String, String>();
        Enumeration names = request.getHeaderNames();
        if (names != null) {
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                String value = request.getHeader(name);
                headers.put(name.toLowerCase(), value);
            }
        }
        return headers;
    }

    private String getBodyData(HttpServletRequest request) throws IOException {
        StringWriter writer = new StringWriter();
        if (request.getReader() != null) {
            IOUtils.copy((Reader)request.getReader(), (Writer)writer);
        }
        return writer.toString();
    }

    private void processResponse(HttpXmlResponse xmlResponse, HttpServletResponse httpResponse) throws IOException {
        httpResponse.setStatus(xmlResponse.getStatusCode());
        Map headers = xmlResponse.getHeaders();
        for (Map.Entry entry : headers.entrySet()) {
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (name.equalsIgnoreCase("Content-Type")) {
                if (!VALIDATOR.isValidInput("Content-Type", value, "HTTPHeaderValue", 100, false, false)) continue;
                httpResponse.setContentType(value);
                continue;
            }
            HTTP_UTILS.addHeader(httpResponse, name, value);
        }
        if (xmlResponse.hasBody()) {
            String body = xmlResponse.getBody();
            httpResponse.setCharacterEncoding(StandardCharsets.UTF_8.name());
            try (PrintWriter writer = httpResponse.getWriter();){
                IOUtils.copy((Reader)new StringReader(body), (Writer)writer);
            }
        }
    }

    private String createErrorResponse(int errorCode, List<String> errorMessages) {
        JSONObject errorResponse = new JSONObject();
        errorResponse.put((Object)"status", (Object)"FAIL");
        errorResponse.put((Object)"code", (Object)errorCode);
        JSONArray errorsArray = new JSONArray();
        for (String message : errorMessages) {
            errorsArray.add((Object)message);
        }
        errorResponse.put((Object)"errors", (Object)errorsArray);
        return errorResponse.toJSONString();
    }

    private String createErrorResponse(int errorCode, Exception ex) {
        ArrayList<String> errorMessages = new ArrayList<String>();
        String message = ex.getClass().getSimpleName();
        errorMessages.add(message);
        for (Throwable th = ex; th != null; th = th.getCause()) {
            message = th.getMessage();
            if (message == null) continue;
            errorMessages.add(message);
        }
        return this.createErrorResponse(errorCode, errorMessages);
    }

    private void writeErrorResponse(int errorCode, Exception ex, HttpServletResponse response) {
        String jsonString = this.createErrorResponse(errorCode, ex);
        response.setStatus(errorCode);
        response.setContentType("application/json;charset=UTF-8");
        try (PrintWriter writer = response.getWriter();){
            writer.write(jsonString);
        }
        catch (IOException e) {
            LOG.error(Logger.EVENT_FAILURE, "Unexpected error when writing the HTTP response", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDiscovery(HttpServletRequest request, HttpServletResponse response, RequestComponents components) throws IOException {
        Connection connection = null;
        try {
            connection = ConnectionHelper.getIMSTenantConnection((HttpServletRequest)request, (String)components.getTenant(), (int)0);
            String httpVersion = this.getHttpProtocolVersion(request);
            Map headers = this.getAllHeaders(request);
            String body = this.getBodyData(request);
            HttpXmlRequest xmlRequest = new HttpXmlRequest("1.0", "POST", "/es_server/management/v2/ionims/service" + request.getPathInfo(), httpVersion, "ION_IMS_V2", headers, body);
            HttpXmlDispatchCall call = new HttpXmlDispatchCall(new BaanDLLCall(connection, null));
            HttpXmlResponse xmlResponse = call.doCall(xmlRequest);
            this.processResponse(xmlResponse, response);
        }
        catch (ConnectionHelper.OAuthValidationException ex) {
            LOG.error(Logger.EVENT_FAILURE, String.format("OAuth validation failed with error code %d: %s", ex.getStatus().getErrorCode(), ex.getStatus().getErrorMessage()));
            response.setStatus(401);
        }
        catch (ResourceException ex) {
            LOG.error(Logger.EVENT_FAILURE, String.format("Connection could not be established: %s", ex.getMessage()));
            this.writeErrorResponse(500, (Exception)((Object)ex), response);
        }
        catch (BaanDLLCallException ex) {
            LOG.error(Logger.EVENT_FAILURE, String.format("Failed to execute DLL call: %s", ex.getMessage()));
            this.writeErrorResponse(500, (Exception)((Object)ex), response);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (ResourceException e) {
                    LOG.warning(Logger.EVENT_UNSPECIFIED, e.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMultipartMessage(HttpServletRequest request, HttpServletResponse response, RequestComponents components) throws IOException {
        Connection connection = null;
        try {
            MultipartRequest mpRequest;
            int company = components.getCompany();
            if (company < 0) {
                company = 0;
            }
            if (!(mpRequest = new MultipartRequest(request)).isValid()) {
                LOG.error(Logger.EVENT_FAILURE, "Multipart request does not have the expected format");
                response.setStatus(400);
                return;
            }
            byte[] jsonHeader = mpRequest.getParameters();
            byte[] xmlBod = mpRequest.getPayload();
            connection = ConnectionHelper.getIMSTenantConnection((HttpServletRequest)request, (String)components.getTenant(), (int)company);
            BODResponse bodResponse = ((ConnectionImpl)connection).executeBODV2(jsonHeader, xmlBod);
            response.setStatus(bodResponse.getHTTPStatusCode());
            byte[] responseBody = bodResponse.getResponse();
            response.setContentType("application/json;charset=UTF-8");
            try (ServletOutputStream output = response.getOutputStream();){
                output.write(responseBody);
            }
        }
        catch (ConnectionHelper.OAuthValidationException ex) {
            LOG.error(Logger.EVENT_FAILURE, String.format("OAuth validation failed with error code %d: %s", ex.getStatus().getErrorCode(), ex.getStatus().getErrorMessage()));
            response.setStatus(401);
        }
        catch (ResourceException ex) {
            LOG.error(Logger.EVENT_FAILURE, String.format("Connection could not be established: %s", ex.getMessage()));
            this.writeErrorResponse(500, (Exception)((Object)ex), response);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (ResourceException e) {
                    LOG.warning(Logger.EVENT_UNSPECIFIED, e.getMessage());
                }
            }
        }
    }

    static /* synthetic */ Logger access$000() {
        return LOG;
    }
}

