/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.rest.ims;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class HttpXmlResponse {
    private String m_version;
    private int m_statusCode;
    private String m_httpVersion;
    private Map<String, String> m_headers;
    private String m_body;

    public void setVersion(String version) {
        this.m_version = version;
    }

    public String getVersion() {
        return this.m_version;
    }

    public void setStatusCode(int statusCode) {
        this.m_statusCode = statusCode;
    }

    public int getStatusCode() {
        return this.m_statusCode;
    }

    public void setHttpVersion(String httpVersion) {
        this.m_httpVersion = httpVersion;
    }

    public String getHttpVersion() {
        return this.m_httpVersion;
    }

    public void setHeaders(Map<String, String> headers) {
        this.m_headers = headers;
    }

    public Map<String, String> getHeaders() {
        if (this.m_headers == null) {
            return Collections.emptyMap();
        }
        return this.m_headers;
    }

    public void setBody(String body) {
        this.m_body = body;
    }

    public String getBody() {
        return this.m_body;
    }

    public boolean hasBody() {
        return this.m_body != null && !this.m_body.isEmpty();
    }

    public static HttpXmlResponse createInternalServerError(String message) {
        return HttpXmlResponse.createResponseWithError((int)500, (String)message);
    }

    public static HttpXmlResponse createBadRequest(String message) {
        return HttpXmlResponse.createResponseWithError((int)400, (String)message);
    }

    private static HttpXmlResponse createResponseWithError(int code, String message) {
        HttpXmlResponse errorResponse = new HttpXmlResponse();
        errorResponse.addHeader("Content-Type", "application/json");
        errorResponse.setStatusCode(code);
        errorResponse.setBody(String.format("{ \"code\": %d, \"message\": \"%s\" }", code, message));
        return errorResponse;
    }

    private void addHeader(String key, String value) {
        if (this.m_headers == null) {
            this.m_headers = new HashMap();
        }
        this.m_headers.put(key, value);
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append("HttpXmlResponse[").append(this.getStatusCode()).append("]");
        if (this.hasBody()) {
            text.append(" \"").append(StringUtils.abbreviate((String)this.m_body, (int)40)).append("\"");
        }
        return text.toString();
    }
}

