/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.rest.ims;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ApiStatus {
    private static final String OK_STATUS = "OK";
    private static final String FAILURE_STATUS = "FAIL";
    private int code;
    private List<String> errorMessages = Collections.emptyList();
    private String json;

    public ApiStatus() {
        this.code = 200;
    }

    public ApiStatus(int code, String ... messages) {
        this.code = code;
        if (messages != null && messages.length > 0) {
            this.errorMessages = Arrays.asList(messages);
        }
    }

    public int getCode() {
        return this.code;
    }

    public List<String> getErrorMessages() {
        return this.errorMessages;
    }

    public boolean isOK() {
        return this.code == 200;
    }

    public String toJSON() {
        if (this.json == null) {
            StringBuilder builder = new StringBuilder("{\"status\":\"");
            builder.append(this.isOK() ? OK_STATUS : FAILURE_STATUS);
            builder.append("\",\"code\":").append(String.valueOf(this.code));
            builder.append(",\"errors\":[");
            if (!this.isOK()) {
                boolean first = true;
                for (String message : this.errorMessages) {
                    if (first) {
                        first = false;
                    } else {
                        builder.append(",");
                    }
                    builder.append("\"").append(message.replace("\"", "\\\"")).append("\"");
                }
            }
            builder.append("]}");
            this.json = builder.toString();
        }
        return this.json;
    }
}

