/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.rest.bde;

import com.infor.erpln.c4ws.util.C4WSPropertiesManager;
import com.infor.erpln.rest.bde.BdeRegistry;
import com.infor.erpln.rest.bde.ErrorHandler;
import com.infor.erpln.rest.bde.JsonBdeException;
import com.infor.erpln.rest.bde.JsonBdeRequestHandler;
import com.infor.erpln.rest.bde.JsonBdeServlet;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;

public class JsonBdeServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String JSON_CONTENTTYPE = "application/json";
    private static final String JSON_CONTENTTYPE_PLUS_CHARSET = "application/json; charset=utf-8";
    private static final String HEADER_CONTENTTYPE = "Content-Type";
    private static final String HEADER_ACCEPT = "Accept";
    private static final String ACCEPT_ALL = "*/*";
    private static final Logger LOG = ESAPI.getLogger(JsonBdeRequestHandler.class);
    private ErrorHandler errorHandler = new ErrorHandler();
    private JsonBdeRequestHandler requestHandler = new JsonBdeRequestHandler();
    private boolean jsonAllowed = false;

    public void init() throws ServletException {
        C4WSPropertiesManager propertiesManager = (C4WSPropertiesManager)this.getServletContext().getAttribute("com.infor.erpln.c4ws.util.C4WSPropertiesManager");
        this.jsonAllowed = propertiesManager.getProperties().isJsonSupported();
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.jsonAllowed) {
            response.setStatus(404);
            return;
        }
        String method = request.getMethod();
        int status = 200;
        response.setContentType(JSON_CONTENTTYPE_PLUS_CHARSET);
        try {
            if (!method.equals("POST")) {
                throw JsonBdeException.get((JsonBdeException.Error)JsonBdeException.Error.INVALID_HTTP_METHOD).format(new Object[]{method});
            }
            status = this.handlePost(request, response);
        }
        catch (JsonBdeException e) {
            status = this.errorHandler.handleError(e, (OutputStream)response.getOutputStream());
        }
        response.setStatus(status);
    }

    private int handlePost(HttpServletRequest request, HttpServletResponse response) throws JsonBdeException {
        HttpSession session = request.getSession();
        if (LOG.isDebugEnabled()) {
            String id = session.getId();
            if (session.isNew()) {
                LOG.debug(Logger.EVENT_UNSPECIFIED, "Starting new HTTP session " + id);
            } else {
                LOG.debug(Logger.EVENT_UNSPECIFIED, "Using existing HTTP session " + id);
            }
        }
        RequestInfo info = new RequestInfo(request);
        this.validateRequest(info);
        return this.requestHandler.handleRequest(info.getBdeName(), info.getBdeMethod(), info.getBackend(), request, response);
    }

    private void validateRequest(RequestInfo info) throws JsonBdeException {
        if (!info.isValid()) {
            throw JsonBdeException.get((JsonBdeException.Error)JsonBdeException.Error.INVALID_ENDPOINT).format(new Object[]{info.getRequest().getRequestURI()});
        }
        String contentType = info.getRequest().getHeader(HEADER_CONTENTTYPE);
        if (contentType != null && !contentType.contains(JSON_CONTENTTYPE)) {
            throw JsonBdeException.get((JsonBdeException.Error)JsonBdeException.Error.WRONG_CONTENT_TYPE).format(new Object[]{contentType});
        }
        String acceptType = info.getRequest().getHeader(HEADER_ACCEPT);
        if (acceptType != null && !acceptType.contains(ACCEPT_ALL) && !acceptType.contains(JSON_CONTENTTYPE)) {
            throw JsonBdeException.get((JsonBdeException.Error)JsonBdeException.Error.NOT_ACCEPTABLE).format(new Object[]{acceptType});
        }
        boolean mtCloudMode = false;
        try {
            C4WSPropertiesManager manager = (C4WSPropertiesManager)this.getServletContext().getAttribute("com.infor.erpln.c4ws.util.C4WSPropertiesManager");
            mtCloudMode = manager.getProperties().isCloudEnabled();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!mtCloudMode && !BdeRegistry.getInstance().contains(info.getBdeName(), info.getBackend())) {
            throw JsonBdeException.get((JsonBdeException.Error)JsonBdeException.Error.BDE_NOT_DEPLOYED).format(new Object[]{info.getBdeName(), info.getBackend()});
        }
    }
}

