/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.rest.bde;

import com.infor.erpln.c4ws.util.ConnectionHelper;
import com.infor.erpln.jca.ConnectionImpl;
import com.infor.erpln.json4bde.JsonBdeHandler;
import com.infor.erpln.rest.bde.JsonBdeException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.resource.ResourceException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;

public class JsonBdeRequestHandler {
    private static final Logger LOG = ESAPI.getLogger(JsonBdeRequestHandler.class);

    public int handleRequest(String bdeName, String bdeMethod, String backend, HttpServletRequest request, HttpServletResponse response) throws JsonBdeException {
        ConnectionImpl connection = null;
        try {
            connection = (ConnectionImpl)ConnectionHelper.getRESTConnection((String)backend, (HttpServletRequest)request);
            JsonBdeHandler jsonBdeHandler = JsonBdeHandler.getInstance((ConnectionImpl)connection);
            int success = jsonBdeHandler.executeBDE(bdeName, bdeMethod, (InputStream)request.getInputStream(), (OutputStream)response.getOutputStream());
            if (success != 0 && LOG.isDebugEnabled()) {
                LOG.debug(Logger.EVENT_FAILURE, "BDE execution returned an error response from LN");
            }
            int n = success == 0 ? 200 : 500;
            return n;
        }
        catch (Throwable ex) {
            LOG.error(Logger.EVENT_FAILURE, "Failed to execute BDE", ex);
            throw new JsonBdeException(500, ex);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (ResourceException e) {
                    LOG.warning(Logger.EVENT_UNSPECIFIED, e.getMessage());
                }
            }
        }
    }
}

