/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.rest.bde;

import com.infor.erpln.rest.bde.JsonBdeException;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class JsonBdeException
extends Exception {
    private static final long serialVersionUID = 1L;
    private int status;
    private String template;
    private String message;

    public JsonBdeException(int status, String message) {
        this(status, message, null);
    }

    public JsonBdeException(int status, Throwable cause) {
        this(status, cause.getMessage(), cause);
    }

    private JsonBdeException(int status, String message, Throwable cause) {
        super(cause);
        this.template = message;
        this.message = message;
        this.status = status;
    }

    public static JsonBdeException get(Error error) {
        return new JsonBdeException(error.getStatus(), error.getMessageTemplate());
    }

    public JsonBdeException format(Object ... formatInfo) {
        this.message = String.format(this.template, formatInfo);
        return this;
    }

    public int getStatus() {
        return this.status;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public String toJsonString() {
        JSONObject errorObject = new JSONObject();
        errorObject.put((Object)"message", (Object)this.message);
        if (this.getCause() != null) {
            JSONArray causes = new JSONArray();
            errorObject.put((Object)"cause", (Object)causes);
            for (Throwable t = this.getCause(); t != null; t = t.getCause()) {
                JSONObject detail = new JSONObject();
                detail.put((Object)"type", (Object)t.getClass().getSimpleName());
                if (t.getMessage() != null) {
                    detail.put((Object)"message", (Object)t.getMessage());
                }
                causes.add((Object)detail);
            }
        }
        JSONObject result = new JSONObject();
        result.put((Object)"error", (Object)errorObject);
        return result.toJSONString();
    }
}

