/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.rest.bde;

import com.infor.erpln.rest.bde.JsonBdeException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;

public class ErrorHandler {
    private static final Logger LOG = ESAPI.getLogger(ErrorHandler.class);

    public int handleError(JsonBdeException error, OutputStream out) {
        try {
            String errorString = error.toJsonString();
            LOG.debug(Logger.EVENT_UNSPECIFIED, "Handling error: " + error.getMessage());
            out.write(errorString.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException ex) {
            LOG.error(Logger.EVENT_FAILURE, "Could not write error message", (Throwable)ex);
        }
        return error.getStatus();
    }
}

