/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.rest.bde;

import com.infor.erpln.rest.bde.BdeRegistry;
import com.infor.erpln.soap.XMLUtil;
import com.infor.erpln.soap.servlet.ServletUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class BdeRegistry {
    private static final String JAXWS_FILE = "sun-jaxws.xml";
    private static final String URL_PATTERN_XPATH = "/endpoints/endpoint/@url-pattern";
    private static final String URL_PREFIX = "/services/";
    private static final int PREFIX_LENGTH = "/services/".length();
    private static final Logger LOG = ESAPI.getLogger(BdeRegistry.class);
    private static BdeRegistry instance = new BdeRegistry();
    private Set<String> registeredBDEs = new HashSet();
    private ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private Lock readLock = this.rwLock.readLock();
    private Lock writeLock = this.rwLock.writeLock();
    private File jaxwsFile;
    private long fileDate = -1L;
    private long lastCheckTime = -1L;
    private long checkInterval = 120000L;

    private BdeRegistry() {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "Initializing BdeRegistry");
        String configFolder = ServletUtils.getC4WSProperties().getConfigFolder();
        this.jaxwsFile = new File(configFolder, JAXWS_FILE);
        this.readFromFile();
        this.lastCheckTime = System.currentTimeMillis();
    }

    public static BdeRegistry getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(String bdeName, String backend) {
        long now = System.currentTimeMillis();
        if (now > this.lastCheckTime + this.checkInterval) {
            this.startUpdateCheck();
            this.lastCheckTime = now;
        }
        this.readLock.lock();
        try {
            boolean bl = this.registeredBDEs.contains(bdeName + "/" + backend);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void reload() {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "Reload requested");
        this.readFromFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFromFile() {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "Start reading 'sun-jaxws.xml'");
        this.fileDate = this.jaxwsFile.lastModified();
        try {
            DocumentBuilderFactory factory = XMLUtil.getSecureDocumentBuilderFactory();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document configDoc = builder.parse(this.jaxwsFile);
            XPath xpath = XPathFactory.newInstance().newXPath();
            NodeList configuredUrls = (NodeList)xpath.evaluate(URL_PATTERN_XPATH, configDoc, XPathConstants.NODESET);
            this.writeLock.lock();
            try {
                this.registeredBDEs.clear();
                for (int i = 0; i < configuredUrls.getLength(); ++i) {
                    String urlPattern = configuredUrls.item(i).getNodeValue();
                    if (!urlPattern.startsWith(URL_PREFIX)) continue;
                    String bdeAndBackend = urlPattern.substring(PREFIX_LENGTH);
                    this.registeredBDEs.add(bdeAndBackend);
                    LOG.debug(Logger.EVENT_UNSPECIFIED, "Added BDE/backend combination: " + bdeAndBackend);
                }
            }
            finally {
                this.writeLock.unlock();
            }
        }
        catch (ParserConfigurationException ex) {
            LOG.fatal(Logger.EVENT_FAILURE, "Could not create DocumentBuilder", (Throwable)ex);
        }
        catch (SAXException ex) {
            LOG.fatal(Logger.EVENT_FAILURE, "Could not parse 'sun-jaxws.xml'", (Throwable)ex);
        }
        catch (IOException ex) {
            LOG.fatal(Logger.EVENT_FAILURE, "Could not read 'sun-jaxws.xml'", (Throwable)ex);
        }
        catch (XPathExpressionException ex) {
            LOG.fatal(Logger.EVENT_FAILURE, "Unexpected error in XPath expression", (Throwable)ex);
        }
    }

    private void startUpdateCheck() {
        1 updateChecker = new /* Unavailable Anonymous Inner Class!! */;
        updateChecker.setDaemon(true);
        updateChecker.start();
    }

    static /* synthetic */ File access$000(BdeRegistry x0) {
        return x0.jaxwsFile;
    }

    static /* synthetic */ long access$100(BdeRegistry x0) {
        return x0.fileDate;
    }

    static /* synthetic */ void access$200(BdeRegistry x0) {
        x0.readFromFile();
    }
}

