/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.rest.apidoc.openapi;

import com.infor.erpln.rest.apidoc.openapi.Scopes;
import com.infor.erpln.rest.apidoc.openapi.SecurityScheme;
import org.json.simple.JSONAware;
import org.json.simple.JSONObject;

public class SecurityScheme
implements JSONAware {
    private static final String PROP_TYPE = "type";
    private static final String PROP_DESCRIPTION = "description";
    private static final String PROP_NAME = "name";
    private static final String PROP_IN = "in";
    private static final String PROP_FLOW = "flow";
    private static final String PROP_AUTHORIZATION_URL = "authorizationUrl";
    private static final String PROP_TOKEN_URL = "tokenUrl";
    private static final String PROP_SCOPES = "scopes";
    private JSONObject scheme = new JSONObject();

    public SecurityScheme(Type type) {
        this.scheme.put((Object)PROP_TYPE, (Object)type.name());
    }

    public static SecurityScheme createBasicSecurityScheme(String description) {
        SecurityScheme result = new SecurityScheme(Type.basic);
        if (description != null) {
            result.setDescription(description);
        }
        return result;
    }

    public static SecurityScheme createApiKeySecurityScheme(String name, In location, String description) {
        SecurityScheme result = new SecurityScheme(Type.apiKey);
        result.setName(name);
        result.setIn(location);
        if (description != null) {
            result.setDescription(description);
        }
        return result;
    }

    public static SecurityScheme createOAuth2SecurityScheme(Flow flow, String description) {
        SecurityScheme result = new SecurityScheme(Type.oauth2);
        result.setFlow(flow);
        if (description != null) {
            result.setDescription(description);
        }
        return result;
    }

    public void setDescription(String description) {
        this.scheme.put((Object)PROP_DESCRIPTION, (Object)description);
    }

    public void setName(String name) {
        this.scheme.put((Object)PROP_NAME, (Object)name);
    }

    public void setIn(In location) {
        this.scheme.put((Object)PROP_IN, (Object)location.name());
    }

    public void setFlow(Flow flow) {
        this.scheme.put((Object)PROP_FLOW, (Object)flow.name());
    }

    public void setAuthorizationUrl(String authUrl) {
        this.scheme.put((Object)PROP_AUTHORIZATION_URL, (Object)authUrl);
    }

    public void setTokenUrl(String tokenUrl) {
        this.scheme.put((Object)PROP_TOKEN_URL, (Object)tokenUrl);
    }

    public void setScopes(Scopes scopes) {
        this.scheme.put((Object)PROP_SCOPES, (Object)scopes);
    }

    public String toJSONString() {
        return this.scheme.toJSONString();
    }
}

