/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.rest.apidoc.openapi;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONAware;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class Schema
implements JSONAware {
    private static final String PROP_REF = "$ref";
    private static final String PROP_TYPE = "type";
    private static final String PROP_FORMAT = "format";
    private static final String PROP_TITLE = "title";
    private static final String PROP_DESCRIPTION = "description";
    private static final String PROP_DEFAULT = "default";
    private static final String PROP_MULTIPLE_OF = "multipleOf";
    private static final String PROP_MAXIMUM = "maximum";
    private static final String PROP_EXCLUSIVE_MAXIMUM = "exclusiveMaximum";
    private static final String PROP_MINIMUM = "minimum";
    private static final String PROP_EXCLUSIVE_MINIMUM = "exclusiveMinimum";
    private static final String PROP_MAX_LENGTH = "maxLength";
    private static final String PROP_MIN_LENGTH = "minLength";
    private static final String PROP_PATTERN = "pattern";
    private static final String PROP_MAX_ITEMS = "maxItems";
    private static final String PROP_MIN_ITEMS = "minItems";
    private static final String PROP_UNIQUE_ITEMS = "uniqueItems";
    private static final String PROP_MAX_PROPERTIES = "maxProperties";
    private static final String PROP_MIN_PROPERTIES = "minProperties";
    private static final String PROP_REQUIRED = "required";
    private static final String PROP_ENUM = "enum";
    private static final String PROP_ITEMS = "items";
    private static final String PROP_ALL_OF = "allOf";
    private static final String PROP_PROPERTIES = "properties";
    private static final String PROP_ADDITIONAL_PROPERTIES = "additionalProperties";
    private static final String PROP_READ_ONLY = "readOnly";
    private JSONObject schema;

    public Schema() {
        this.schema = new JSONObject();
    }

    public Schema(String jsonString) {
        try {
            this.schema = (JSONObject)JSONValue.parseWithException((String)jsonString);
        }
        catch (Exception e) {
            this.schema = new JSONObject();
        }
    }

    public void setReference(String ref) {
        this.schema.put((Object)PROP_REF, (Object)ref);
    }

    public void setType(String type) {
        this.schema.put((Object)PROP_TYPE, (Object)type);
    }

    public void setFormat(String format) {
        this.schema.put((Object)PROP_FORMAT, (Object)format);
    }

    public void setTitle(String title) {
        this.schema.put((Object)PROP_TITLE, (Object)title);
    }

    public void setDescription(String description) {
        this.schema.put((Object)PROP_DESCRIPTION, (Object)description);
    }

    public String getDescription() {
        if (this.schema.containsKey((Object)PROP_DESCRIPTION)) {
            return (String)this.schema.get((Object)PROP_DESCRIPTION);
        }
        return null;
    }

    public void setDefault(Object value) {
        this.schema.put((Object)PROP_DEFAULT, value);
    }

    public void setMultipleOf(Number multipleOf) {
        this.schema.put((Object)PROP_MULTIPLE_OF, (Object)multipleOf);
    }

    public void setMaximum(Number maximum) {
        this.schema.put((Object)PROP_MAXIMUM, (Object)maximum);
    }

    public void setExclusiveMaximum(boolean exclusiveMaximum) {
        this.schema.put((Object)PROP_EXCLUSIVE_MAXIMUM, (Object)exclusiveMaximum);
    }

    public void setMinimum(Number minimum) {
        this.schema.put((Object)PROP_MINIMUM, (Object)minimum);
    }

    public void setExclusiveMinimum(boolean exclusiveMinimum) {
        this.schema.put((Object)PROP_EXCLUSIVE_MINIMUM, (Object)exclusiveMinimum);
    }

    public void setMaxLength(int maxLength) {
        this.schema.put((Object)PROP_MAX_LENGTH, (Object)maxLength);
    }

    public void setMinLength(int minLength) {
        this.schema.put((Object)PROP_MIN_LENGTH, (Object)minLength);
    }

    public void setPattern(String pattern) {
        this.schema.put((Object)PROP_PATTERN, (Object)pattern);
    }

    public void setMaxItems(int maxItems) {
        this.schema.put((Object)PROP_MAX_ITEMS, (Object)maxItems);
    }

    public void setMinItems(int minItems) {
        this.schema.put((Object)PROP_MIN_ITEMS, (Object)minItems);
    }

    public void setUniqueItems(boolean uniqueItems) {
        this.schema.put((Object)PROP_UNIQUE_ITEMS, (Object)uniqueItems);
    }

    public void setMaxProperties(int maxProperties) {
        this.schema.put((Object)PROP_MAX_PROPERTIES, (Object)maxProperties);
    }

    public void setMinProperties(int minProperties) {
        this.schema.put((Object)PROP_MIN_PROPERTIES, (Object)minProperties);
    }

    public void setRequired(String[] properties) {
        if (properties.length > 0) {
            JSONArray propArray = new JSONArray();
            for (String property : properties) {
                propArray.add((Object)property);
            }
            this.schema.put((Object)PROP_REQUIRED, (Object)propArray);
        }
    }

    public void setRequired(List<String> properties) {
        if (properties != null && !properties.isEmpty()) {
            JSONArray propArray = new JSONArray();
            for (String property : properties) {
                propArray.add((Object)property);
            }
            this.schema.put((Object)PROP_REQUIRED, (Object)propArray);
        }
    }

    public List<String> getRequired() {
        if (this.schema.containsKey((Object)PROP_REQUIRED)) {
            return (List)this.schema.get((Object)PROP_REQUIRED);
        }
        return Collections.emptyList();
    }

    public void setEnum(List<?> enumValues) {
        this.schema.put((Object)PROP_ENUM, enumValues);
    }

    public void setItems(Schema itemSchema) {
        this.schema.put((Object)PROP_ITEMS, (Object)itemSchema);
    }

    public void setItems(Schema[] itemSchemas) {
        JSONArray schemaArray = new JSONArray();
        for (Schema itemSchema : itemSchemas) {
            schemaArray.add((Object)itemSchema);
        }
        this.schema.put((Object)PROP_ITEMS, (Object)schemaArray);
    }

    public void setAllOf(List<Schema> allOf) {
        this.schema.put((Object)PROP_ALL_OF, allOf);
    }

    public void setProperties(Map<String, Schema> properties) {
        this.schema.put((Object)PROP_PROPERTIES, properties);
    }

    public void addProperty(String propertyName, Schema propertySchema) {
        Map<String, Schema> properties = null;
        if (this.schema.containsKey((Object)PROP_PROPERTIES)) {
            properties = (Map)this.schema.get((Object)PROP_PROPERTIES);
        } else {
            properties = new LinkedHashMap();
            this.schema.put((Object)PROP_PROPERTIES, properties);
        }
        properties.put(propertyName, propertySchema);
    }

    public Map<String, Schema> getProperties() {
        if (this.schema.containsKey((Object)PROP_PROPERTIES)) {
            return (Map)this.schema.get((Object)PROP_PROPERTIES);
        }
        return Collections.emptyMap();
    }

    public void setAdditionalProperties(boolean additionalPropertiesAllowed) {
        this.schema.put((Object)PROP_ADDITIONAL_PROPERTIES, (Object)additionalPropertiesAllowed);
    }

    public void setAdditionalProperties(Schema additionalProperties) {
        this.schema.put((Object)PROP_ADDITIONAL_PROPERTIES, (Object)additionalProperties);
    }

    public void setReadOnly(boolean readOnly) {
        this.schema.put((Object)PROP_READ_ONLY, (Object)readOnly);
    }

    public String toJSONString() {
        return this.schema.toJSONString();
    }
}

