/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.rest.apidoc;

import com.infor.erpln.rest.apidoc.WSDLConverter;
import com.infor.erpln.rest.apidoc.openapi.Definitions;
import com.infor.erpln.rest.apidoc.openapi.IResponse;
import com.infor.erpln.rest.apidoc.openapi.Info;
import com.infor.erpln.rest.apidoc.openapi.Operation;
import com.infor.erpln.rest.apidoc.openapi.OperationParameter;
import com.infor.erpln.rest.apidoc.openapi.PathItem;
import com.infor.erpln.rest.apidoc.openapi.Paths;
import com.infor.erpln.rest.apidoc.openapi.Reference;
import com.infor.erpln.rest.apidoc.openapi.Response;
import com.infor.erpln.rest.apidoc.openapi.Responses;
import com.infor.erpln.rest.apidoc.openapi.ResponsesDefinitions;
import com.infor.erpln.rest.apidoc.openapi.Schema;
import com.infor.erpln.rest.apidoc.openapi.SecurityDefinitions;
import com.infor.erpln.rest.apidoc.openapi.SecurityRequirement;
import com.infor.erpln.rest.apidoc.openapi.SecurityScheme;
import com.infor.erpln.rest.apidoc.openapi.Specification;
import com.infor.erpln.rest.apidoc.openapi.Tag;
import com.infor.erpln.soap.XMLUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.wsdl.PortType;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.ws.commons.schema.XmlSchemaAll;
import org.apache.ws.commons.schema.XmlSchemaAllMember;
import org.apache.ws.commons.schema.XmlSchemaAny;
import org.apache.ws.commons.schema.XmlSchemaAttribute;
import org.apache.ws.commons.schema.XmlSchemaAttributeOrGroupRef;
import org.apache.ws.commons.schema.XmlSchemaChoice;
import org.apache.ws.commons.schema.XmlSchemaChoiceMember;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaComplexContent;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaContent;
import org.apache.ws.commons.schema.XmlSchemaContentModel;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaEnumerationFacet;
import org.apache.ws.commons.schema.XmlSchemaFacet;
import org.apache.ws.commons.schema.XmlSchemaFractionDigitsFacet;
import org.apache.ws.commons.schema.XmlSchemaGroup;
import org.apache.ws.commons.schema.XmlSchemaGroupRef;
import org.apache.ws.commons.schema.XmlSchemaLengthFacet;
import org.apache.ws.commons.schema.XmlSchemaMaxExclusiveFacet;
import org.apache.ws.commons.schema.XmlSchemaMaxInclusiveFacet;
import org.apache.ws.commons.schema.XmlSchemaMaxLengthFacet;
import org.apache.ws.commons.schema.XmlSchemaMinExclusiveFacet;
import org.apache.ws.commons.schema.XmlSchemaMinInclusiveFacet;
import org.apache.ws.commons.schema.XmlSchemaMinLengthFacet;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaPatternFacet;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaSequenceMember;
import org.apache.ws.commons.schema.XmlSchemaSimpleContent;
import org.apache.ws.commons.schema.XmlSchemaSimpleContentExtension;
import org.apache.ws.commons.schema.XmlSchemaSimpleContentRestriction;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeContent;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeList;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeRestriction;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeUnion;
import org.apache.ws.commons.schema.XmlSchemaTotalDigitsFacet;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.apache.ws.commons.schema.XmlSchemaWhiteSpaceFacet;
import org.apache.ws.commons.schema.constants.Constants;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;
import org.w3c.dom.Document;

public class WSDLConverter {
    private static final Logger LOG = ESAPI.getLogger(WSDLConverter.class);
    private static final String DEFAULT_API_VERSION = "1.0";
    private static final String DEFAULT_TAG = "Operations";
    private static final String DEFAULT_TAG_DESCRIPTION = "Invoke BDE functionality";
    private static final String API_DEESCRIPTION = "API for the **%s** BDE";
    private static final String METHOD_DESCRIPTION = "Invoke the **%s** method of the **%s** BDE";
    private static final String MIME_TYPE_JSON = "application/json";
    private static final String JSON_TYPE_ARRAY = "array";
    private static final String JSON_TYPE_INTEGER = "integer";
    private static final String JSON_TYPE_NUMBER = "number";
    private static final String JSON_TYPE_OBJECT = "object";
    private static final String JSON_TYPE_STRING = "string";
    private static final String JSON_FORMAT_BYTE = "byte";
    private static final String JSON_FORMAT_DATETIME = "date-time";
    private static final String JSON_FORMAT_DATE = "date";
    private static final String JSON_FORMAT_INT32 = "int32";
    private static final String JSON_FORMAT_INT64 = "int64";
    private static final String SECURITY_SCHEME_BASIC = "basic";
    private static final String SECURITY_SCHEME_OAUTH1 = "oauth1";
    private static final String HTTP_HEADER_AUTHORIZATION = "Authorization";
    private static final List<String> UNSUPPORTED_METHODS = Arrays.asList("SubscribeList", "SubscribeEvent", "UnSubscribeEvent", "OnEvent", "SupportsProcessingScope", "SupportsReferentialIntegrity", "CreateRef", "DeleteRef");
    private static final List<String> UNSUPPORTED_PROPERTIES = Arrays.asList("iteratorID", "iteratorFetchSize");
    private static final Map<String, String> GENERIC_BDE_TYPE_DEFINITIONS = new HashMap();
    private static TransformerFactory transformerFactory;
    private static WSDLFactory wsdlFactory;
    private static final String SIMPLE_TYPE_ANYSIMPLETYPE;
    private static final String SIMPLE_TYPE_ANYTYPE;
    private static final String SIMPLE_TYPE_ANYURI;
    private static final String SIMPLE_TYPE_BASE64;
    private static final String SIMPLE_TYPE_BOOLEAN;
    private static final String SIMPLE_TYPE_BYTE;
    private static final String SIMPLE_TYPE_DATE;
    private static final String SIMPLE_TYPE_DATETIME;
    private static final String SIMPLE_TYPE_DECIMAL;
    private static final String SIMPLE_TYPE_DOUBLE;
    private static final String SIMPLE_TYPE_FLOAT;
    private static final String SIMPLE_TYPE_HEXBIN;
    private static final String SIMPLE_TYPE_INT;
    private static final String SIMPLE_TYPE_INTEGER;
    private static final String SIMPLE_TYPE_LANGUAGE;
    private static final String SIMPLE_TYPE_LONG;
    private static final String SIMPLE_TYPE_NEGATIVEINTEGER;
    private static final String SIMPLE_TYPE_NONNEGATIVEINTEGER;
    private static final String SIMPLE_TYPE_NONPOSITIVEINTEGER;
    private static final String SIMPLE_TYPE_NORMALIZEDSTRING;
    private static final String SIMPLE_TYPE_POSITIVEINTEGER;
    private static final String SIMPLE_TYPE_STRING;
    private static final String SIMPLE_TYPE_TOKEN;
    private String wsdlString;
    private Definition wsdlDefinition;
    private XmlSchemaCollection schemaCollection;
    private String bdeName;
    private String connectionpoint;
    private String basePath;
    private String hostAndPort;
    private Set<QName> usedTypes = new HashSet();

    public WSDLConverter(String wsdlString) {
        this.wsdlString = wsdlString;
    }

    public void setConnectionpoint(String connectionpoint) {
        this.connectionpoint = connectionpoint;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public void setHostAndPort(String hostAndPort) {
        this.hostAndPort = hostAndPort;
    }

    public Specification convert() throws WSDLConversionException {
        Document wsdlDoc;
        LOG.debug(Logger.EVENT_UNSPECIFIED, "Start conversion");
        try {
            wsdlDoc = XMLUtil.StringToDocument((String)this.wsdlString);
        }
        catch (Exception e) {
            throw new WSDLConversionException("WSDL string could not be converted to XML Document", (Throwable)e);
        }
        this.wsdlDefinition = this.parseWsdlDocument(wsdlDoc);
        this.schemaCollection = this.parseSchemaFromWsdlDocument(wsdlDoc);
        Specification openAPISpec = this.createSpecification();
        LOG.debug(Logger.EVENT_UNSPECIFIED, "Conversion completed successfully");
        return openAPISpec;
    }

    private Definition parseWsdlDocument(Document wsdlDoc) throws WSDLConversionException {
        WSDLReader reader = wsdlFactory.newWSDLReader();
        try {
            return reader.readWSDL(null, wsdlDoc);
        }
        catch (WSDLException e) {
            throw new WSDLConversionException("WSDL Document could not be parsed", (Throwable)e);
        }
    }

    private XmlSchemaCollection parseSchemaFromWsdlDocument(Document wsdlDoc) throws WSDLConversionException {
        XmlSchemaCollection collection = new XmlSchemaCollection();
        try (InputStream xsltStream = this.getClass().getResourceAsStream("extractSchema.xsl");){
            Transformer transformer = transformerFactory.newTransformer(new StreamSource(xsltStream));
            DOMResult domResult = new DOMResult();
            transformer.transform(new DOMSource(wsdlDoc), domResult);
            Document schemaDoc = (Document)domResult.getNode();
            collection.read(schemaDoc);
        }
        catch (IOException e) {
            LOG.error(Logger.EVENT_FAILURE, "Unexpected error", (Throwable)e);
        }
        catch (TransformerException e) {
            throw new WSDLConversionException("XSD could not be extracted from WSDL Document", (Throwable)e);
        }
        return collection;
    }

    private Specification createSpecification() {
        QName qName = this.wsdlDefinition.getQName();
        this.bdeName = qName.getLocalPart();
        Specification spec = new Specification();
        Info info = spec.createInfo(this.bdeName, DEFAULT_API_VERSION);
        info.setDescription(String.format(API_DEESCRIPTION, this.bdeName));
        spec.setConsumes(new String[]{MIME_TYPE_JSON});
        spec.setProduces(new String[]{MIME_TYPE_JSON});
        if (this.basePath != null) {
            spec.setBasePath(this.basePath);
        }
        if (this.hostAndPort != null) {
            spec.setHost(this.hostAndPort);
        }
        spec.setTags(new Tag[]{new Tag(DEFAULT_TAG, DEFAULT_TAG_DESCRIPTION)});
        Paths paths = spec.createPaths();
        this.addPaths(paths);
        Definitions definitions = spec.createDefinitions();
        this.addTypes(definitions);
        ResponsesDefinitions responsesDefinitions = spec.createResponsesDefinitions();
        this.addGenericResponses(responsesDefinitions);
        return spec;
    }

    private void addGenericResponses(ResponsesDefinitions definitions) {
        Response response = new Response("Error response/result");
        Schema objectSchema = new Schema();
        objectSchema.setType(JSON_TYPE_OBJECT);
        objectSchema.setProperties(Collections.EMPTY_MAP);
        response.setSchema(objectSchema);
        definitions.addDefinition("errorResponse", response);
    }

    private void addStandardSecurityEntries(Specification specification) {
        SecurityDefinitions securityDefinitions = specification.createSecurityDefinitions();
        SecurityScheme basicScheme = SecurityScheme.createBasicSecurityScheme((String)"HTTP Basic Authentication. Supply LN username/password.");
        SecurityScheme oauth1Scheme = SecurityScheme.createApiKeySecurityScheme((String)HTTP_HEADER_AUTHORIZATION, (SecurityScheme.In)SecurityScheme.In.header, (String)"OAuth 1.0a Authentication. Supply the OAuth data in the \"Authorization\" header.");
        securityDefinitions.addSecurityScheme(SECURITY_SCHEME_BASIC, basicScheme);
        securityDefinitions.addSecurityScheme(SECURITY_SCHEME_OAUTH1, oauth1Scheme);
        SecurityRequirement basicReq = new SecurityRequirement();
        basicReq.addScheme(SECURITY_SCHEME_BASIC, new String[0]);
        SecurityRequirement oauth1Req = new SecurityRequirement();
        oauth1Req.addScheme(SECURITY_SCHEME_OAUTH1, new String[0]);
        specification.setSecurity(new SecurityRequirement[]{basicReq, oauth1Req});
    }

    private void addTypes(Definitions definitions) {
        this.addGenericTypes(definitions);
        this.usedTypes.add(new QName(this.wsdlDefinition.getTargetNamespace(), "filterAttributeListDT"));
        for (QName typeName : this.usedTypes) {
            if (this.isGenericType(typeName)) continue;
            XmlSchemaType type = this.schemaCollection.getTypeByQName(typeName);
            definitions.addDefinition(typeName.getLocalPart(), this.createSchema(type));
        }
    }

    private boolean isGenericType(QName typeName) {
        if (typeName != null && this.wsdlDefinition.getQName().getNamespaceURI().equals(typeName.getNamespaceURI())) {
            String name = typeName.getLocalPart();
            return GENERIC_BDE_TYPE_DEFINITIONS.containsKey(name);
        }
        return false;
    }

    private void addGenericTypes(Definitions definitions) {
        for (Map.Entry entry : GENERIC_BDE_TYPE_DEFINITIONS.entrySet()) {
            definitions.addDefinition((String)entry.getKey(), new Schema((String)entry.getValue()));
        }
    }

    private void addPaths(Paths paths) {
        PortType portType = (PortType)this.wsdlDefinition.getPortTypes().get(this.wsdlDefinition.getQName());
        List operations = portType.getOperations();
        for (javax.wsdl.Operation op : operations) {
            String name = op.getName();
            if (UNSUPPORTED_METHODS.contains(name)) continue;
            StringBuilder path = new StringBuilder("/");
            path.append(this.bdeName).append("/").append(op.getName());
            if (this.connectionpoint != null) {
                path.append("/{backend}");
            }
            paths.addItem(path.toString(), this.createPathItem(op));
        }
    }

    private PathItem createPathItem(javax.wsdl.Operation operation) {
        PathItem item = new PathItem();
        String operationName = operation.getName();
        Operation apiOperation = item.newOperation(Operation.Method.post, operationName);
        apiOperation.setTags(new String[]{DEFAULT_TAG});
        apiOperation.setDescription(String.format(METHOD_DESCRIPTION, operationName, this.bdeName));
        Message inputMessage = operation.getInput().getMessage();
        String requestName = inputMessage.getQName().getLocalPart();
        Part requestPart = inputMessage.getPart(requestName);
        QName requestTypeName = requestPart.getTypeName();
        OperationParameter requestParam = new OperationParameter(OperationParameter.Location.body, requestName);
        requestParam.setRequired(true);
        if (requestTypeName != null) {
            this.usedTypes.add(requestTypeName);
            Schema requestSchema = new Schema();
            requestSchema.setType(JSON_TYPE_OBJECT);
            requestSchema.addProperty(requestName, this.createReference(requestTypeName));
            requestParam.setSchema(requestSchema);
        }
        if (this.connectionpoint != null) {
            OperationParameter backendParam = new OperationParameter(OperationParameter.Location.path, "backend");
            backendParam.setType(JSON_TYPE_STRING);
            backendParam.setDescription("Name of the connectionpoint for the LN backend. (Defined as \"ERP Server\" in C4WS.)\n_Example: \"" + this.connectionpoint + "\"._");
            apiOperation.setParameters(new OperationParameter[]{backendParam, requestParam});
        } else {
            apiOperation.setParameters(new OperationParameter[]{requestParam});
        }
        Message outputMessage = operation.getOutput().getMessage();
        String responseName = outputMessage.getQName().getLocalPart();
        Part responsePart = outputMessage.getPart(responseName);
        QName responseTypeName = responsePart.getTypeName();
        Response okResponse = new Response("Successful response");
        if (responseTypeName != null) {
            this.usedTypes.add(responseTypeName);
            Schema responseSchema = new Schema();
            responseSchema.setType(JSON_TYPE_OBJECT);
            responseSchema.addProperty(responseName, this.createReference(responseTypeName));
            okResponse.setSchema(responseSchema);
        }
        Reference errorResponse = new Reference("#/responses/errorResponse");
        Responses responses = apiOperation.createResponses();
        responses.addResponse("200", (IResponse)okResponse);
        responses.addResponse("500", (IResponse)errorResponse);
        return item;
    }

    private Schema createSchema(XmlSchemaType type) {
        Schema schema = null;
        if (this.isGenericType(type.getQName())) {
            schema = this.createReference(type.getQName());
        } else if (type instanceof XmlSchemaSimpleType) {
            schema = this.createSchemaForSimpleType((XmlSchemaSimpleType)type);
        } else if (type instanceof XmlSchemaComplexType) {
            schema = this.createSchemaForComplexType((XmlSchemaComplexType)type);
        }
        return schema;
    }

    private Schema createReference(QName typeName) {
        Schema schema = new Schema();
        schema.setReference("#/definitions/" + typeName.getLocalPart());
        return schema;
    }

    private Schema createSchemaForComplexType(XmlSchemaComplexType type) {
        Schema schema = null;
        XmlSchemaParticle particle = type.getParticle();
        XmlSchemaContentModel contentModel = type.getContentModel();
        if (particle instanceof XmlSchemaSequence) {
            schema = this.createSchemaForSequence((XmlSchemaSequence)particle);
        } else if (particle instanceof XmlSchemaChoice) {
            schema = this.createSchemaForChoice((XmlSchemaChoice)particle);
        } else if (particle instanceof XmlSchemaElement) {
            schema = this.createSchemaForElement((XmlSchemaElement)particle);
        } else if (particle instanceof XmlSchemaAny) {
            schema = new Schema("{\"description\":\"Any type of object is allowed\"}");
        } else if (particle instanceof XmlSchemaAll) {
            schema = this.createSchemaForAll((XmlSchemaAll)particle);
        } else if (particle instanceof XmlSchemaGroupRef) {
            this.notSupported("<xsd:group ref=...> within <xsd:complexType>");
        } else if (contentModel instanceof XmlSchemaSimpleContent) {
            schema = this.createSchemaForSimpleContent((XmlSchemaSimpleContent)contentModel);
        } else if (contentModel instanceof XmlSchemaComplexContent) {
            this.notSupported("<xsd:complexContent> within <xsd:complexType>");
        }
        if (schema != null && !type.getAttributes().isEmpty()) {
            this.addAttributePropertiesToSchema(schema, type.getAttributes());
        }
        if (particle != null && particle.getMaxOccurs() > 1L) {
            schema = this.wrapInArray(schema);
        }
        return schema;
    }

    private void addAttributePropertiesToSchema(Schema schema, List<XmlSchemaAttributeOrGroupRef> attributes) {
        for (XmlSchemaAttributeOrGroupRef attribute : attributes) {
            if (attribute instanceof XmlSchemaAttribute) {
                String name = "@" + ((XmlSchemaAttribute)attribute).getName();
                QName schemaTypeName = ((XmlSchemaAttribute)attribute).getSchemaTypeName();
                XmlSchemaType schemaType = this.schemaCollection.getTypeByQName(schemaTypeName);
                Schema attributeSchema = this.createSchema(schemaType);
                String defaultValue = ((XmlSchemaAttribute)attribute).getDefaultValue();
                if (defaultValue != null) {
                    attributeSchema.setDefault((Object)defaultValue);
                }
                schema.addProperty(name, attributeSchema);
                continue;
            }
            this.notSupported("<xsd:attributeGroup ref=...> within <xsd:complexType>");
        }
    }

    private Schema createSchemaForSimpleContent(XmlSchemaSimpleContent contentModel) {
        XmlSchemaSimpleContentRestriction restriction;
        List attributes;
        Schema schema = new Schema();
        XmlSchemaContent content = contentModel.getContent();
        if (content instanceof XmlSchemaSimpleContentExtension) {
            XmlSchemaSimpleContentExtension extension = (XmlSchemaSimpleContentExtension)content;
            List attributes2 = extension.getAttributes();
            if (!attributes2.isEmpty()) {
                XmlSchemaType baseSchemaType = this.schemaCollection.getTypeByQName(extension.getBaseTypeName());
                Schema baseSchema = this.createSchema(baseSchemaType);
                schema.addProperty("$", baseSchema);
                this.addAttributePropertiesToSchema(schema, attributes2);
            }
        } else if (content instanceof XmlSchemaSimpleContentRestriction && !(attributes = (restriction = (XmlSchemaSimpleContentRestriction)content).getAttributes()).isEmpty()) {
            XmlSchemaType baseSchemaType = this.schemaCollection.getTypeByQName(restriction.getBaseTypeName());
            Schema baseSchema = this.createSchema(baseSchemaType);
            this.addFacetsToSchema(baseSchema, restriction.getFacets());
            schema.addProperty("$", baseSchema);
            this.addAttributePropertiesToSchema(schema, attributes);
        }
        return schema;
    }

    private Schema wrapInArray(Schema schema) {
        Schema arraySchema = new Schema();
        arraySchema.setType(JSON_TYPE_ARRAY);
        arraySchema.setItems(schema);
        return arraySchema;
    }

    private Schema createSchemaForAll(XmlSchemaAll allElement) {
        Schema schema = new Schema();
        LinkedHashMap<String, Schema> properties = new LinkedHashMap<String, Schema>();
        schema.setProperties(properties);
        List items = allElement.getItems();
        for (XmlSchemaAllMember item : items) {
            if (item instanceof XmlSchemaElement) {
                XmlSchemaElement element = (XmlSchemaElement)item;
                String elementName = element.getName();
                if (UNSUPPORTED_PROPERTIES.contains(elementName)) continue;
                Schema elementSchema = this.createSchemaForElement(element);
                properties.put(elementName, elementSchema);
                continue;
            }
            if (item instanceof XmlSchemaAny) {
                this.notSupported("<xsd:any> within <xsd:all>");
                continue;
            }
            if (item instanceof XmlSchemaGroup) {
                this.notSupported("<xsd:group> within <xsd:all>");
                continue;
            }
            if (!(item instanceof XmlSchemaGroupRef)) continue;
            this.notSupported("<xsd:group ref=...> within <xsd:all>");
        }
        return schema;
    }

    private Schema createSchemaForElement(XmlSchemaElement element) {
        Schema schema = null;
        XmlSchemaType schemaType = element.getSchemaType();
        if (schemaType == null) {
            QName schemaTypeName = element.getSchemaTypeName();
            String description = schemaTypeName != null ? schemaTypeName.getLocalPart() : "unknown";
            schema = new Schema();
            schema.setDescription(description);
        } else {
            schema = this.createSchema(schemaType);
        }
        if (element.getDefaultValue() != null) {
            schema.setDefault((Object)element.getDefaultValue());
        }
        if (element.getMaxOccurs() > 1L) {
            schema = this.wrapInArray(schema);
        }
        return schema;
    }

    private Schema createSchemaForSequence(XmlSchemaSequence sequence) {
        Schema schema = new Schema();
        List items = sequence.getItems();
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        ArrayList<String> requiredProperties = new ArrayList<String>();
        schema.setProperties(properties);
        for (XmlSchemaSequenceMember item : items) {
            Schema nested;
            if (item instanceof XmlSchemaElement) {
                XmlSchemaElement element = (XmlSchemaElement)item;
                String elementName = element.getName();
                if (UNSUPPORTED_PROPERTIES.contains(elementName)) continue;
                Schema elementSchema = this.createSchemaForElement(element);
                properties.put(elementName, elementSchema);
                if (element.getMinOccurs() != 1L) continue;
                requiredProperties.add(elementName);
                continue;
            }
            if (item instanceof XmlSchemaAny) {
                this.notSupported("<xsd:any> within <xsd:sequence>");
                continue;
            }
            if (item instanceof XmlSchemaChoice) {
                nested = this.createSchemaForChoice((XmlSchemaChoice)item);
                for (Map.Entry entry : nested.getProperties().entrySet()) {
                    properties.put((String)entry.getKey(), entry.getValue());
                }
                continue;
            }
            if (item instanceof XmlSchemaGroup) {
                this.notSupported("<xsd:group> within <xsd:sequence>");
                continue;
            }
            if (item instanceof XmlSchemaGroupRef) {
                this.notSupported("<xsd:group ref=...> within <xsd:sequence>");
                continue;
            }
            if (!(item instanceof XmlSchemaSequence)) continue;
            nested = this.createSchemaForSequence((XmlSchemaSequence)item);
            for (Map.Entry entry : nested.getProperties().entrySet()) {
                properties.put((String)entry.getKey(), entry.getValue());
            }
            for (String required : nested.getRequired()) {
                requiredProperties.add(required);
            }
        }
        schema.setRequired(requiredProperties);
        return schema;
    }

    private Schema createSchemaForChoice(XmlSchemaChoice choice) {
        Schema schema = new Schema();
        List items = choice.getItems();
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        schema.setProperties(properties);
        for (XmlSchemaChoiceMember item : items) {
            Schema nested;
            if (item instanceof XmlSchemaElement) {
                XmlSchemaElement element = (XmlSchemaElement)item;
                String elementName = element.getName();
                if (UNSUPPORTED_PROPERTIES.contains(elementName)) continue;
                Schema elementSchema = this.createSchemaForElement(element);
                properties.put(elementName, elementSchema);
                continue;
            }
            if (item instanceof XmlSchemaAny) {
                this.notSupported("<xsd:any> within <xsd:choice>");
                continue;
            }
            if (item instanceof XmlSchemaChoice) {
                nested = this.createSchemaForChoice((XmlSchemaChoice)item);
                for (Map.Entry entry : nested.getProperties().entrySet()) {
                    properties.put((String)entry.getKey(), entry.getValue());
                }
                continue;
            }
            if (item instanceof XmlSchemaGroup) {
                this.notSupported("<xsd:group> within <xsd:choice>");
                continue;
            }
            if (item instanceof XmlSchemaGroupRef) {
                this.notSupported("<xsd:group ref=...> within <xsd:choice>");
                continue;
            }
            if (!(item instanceof XmlSchemaSequence)) continue;
            nested = this.createSchemaForSequence((XmlSchemaSequence)item);
            for (Map.Entry entry : nested.getProperties().entrySet()) {
                properties.put((String)entry.getKey(), entry.getValue());
            }
        }
        return schema;
    }

    private Schema createSchemaForSimpleType(XmlSchemaSimpleType type) {
        Schema schema = new Schema();
        QName typeQName = type.getQName();
        if (!this.trySetSchemaType(schema, typeQName)) {
            XmlSchemaSimpleTypeContent content = type.getContent();
            if (content instanceof XmlSchemaSimpleTypeRestriction) {
                XmlSchemaSimpleTypeRestriction restriction = (XmlSchemaSimpleTypeRestriction)content;
                typeQName = restriction.getBaseTypeName();
                if (this.trySetSchemaType(schema, typeQName)) {
                    this.addFacetsToSchema(schema, restriction.getFacets());
                } else {
                    this.notSupported("Simple Type with QName " + typeQName.toString());
                }
            } else if (content instanceof XmlSchemaSimpleTypeList) {
                this.notSupported("<xsd:list>");
            } else if (content instanceof XmlSchemaSimpleTypeUnion) {
                this.notSupported("<xsd:union>");
            }
        }
        return schema;
    }

    private void addFacetsToSchema(Schema schema, List<XmlSchemaFacet> facets) {
        ArrayList<String> enumValues = new ArrayList<String>();
        ArrayList<String> unsupportedFacets = new ArrayList<String>();
        for (XmlSchemaFacet facet : facets) {
            Number value;
            if (facet instanceof XmlSchemaEnumerationFacet) {
                enumValues.add(String.valueOf(facet.getValue()));
                continue;
            }
            if (facet instanceof XmlSchemaMaxExclusiveFacet) {
                schema.setMaximum(this.asNumber(facet.getValue()));
                schema.setExclusiveMaximum(true);
                continue;
            }
            if (facet instanceof XmlSchemaMaxInclusiveFacet) {
                schema.setMaximum(this.asNumber(facet.getValue()));
                continue;
            }
            if (facet instanceof XmlSchemaMinExclusiveFacet) {
                schema.setMinimum(this.asNumber(facet.getValue()));
                schema.setExclusiveMaximum(true);
                continue;
            }
            if (facet instanceof XmlSchemaMinInclusiveFacet) {
                schema.setMinimum(this.asNumber(facet.getValue()));
                continue;
            }
            if (facet instanceof XmlSchemaFractionDigitsFacet) {
                unsupportedFacets.add("fractionDigits = " + this.asNumber(facet.getValue()));
                continue;
            }
            if (facet instanceof XmlSchemaLengthFacet) {
                unsupportedFacets.add("length = " + this.asNumber(facet.getValue()));
                continue;
            }
            if (facet instanceof XmlSchemaMaxLengthFacet) {
                value = this.asNumber(facet.getValue());
                schema.setMaxLength(value.intValue());
                continue;
            }
            if (facet instanceof XmlSchemaMinLengthFacet) {
                value = this.asNumber(facet.getValue());
                schema.setMinLength(value.intValue());
                continue;
            }
            if (facet instanceof XmlSchemaTotalDigitsFacet) {
                unsupportedFacets.add("totalDigits = " + this.asNumber(facet.getValue()));
                continue;
            }
            if (facet instanceof XmlSchemaPatternFacet) {
                schema.setPattern(String.valueOf(facet.getValue()));
                continue;
            }
            if (!(facet instanceof XmlSchemaWhiteSpaceFacet)) continue;
            unsupportedFacets.add("whitespace = " + String.valueOf(facet.getValue()));
        }
        if (!enumValues.isEmpty()) {
            schema.setEnum(enumValues);
        }
        if (!unsupportedFacets.isEmpty()) {
            String desc = schema.getDescription();
            StringBuilder builder = new StringBuilder();
            if (desc != null) {
                builder.append(desc).append("\n");
            }
            builder.append("Restrictions: ");
            boolean first = true;
            for (String restriction : unsupportedFacets) {
                if (first) {
                    first = false;
                } else {
                    builder.append(" ; ");
                }
                builder.append(restriction);
            }
            schema.setDescription(builder.toString());
        }
    }

    private Number asNumber(Object value) {
        if (value instanceof Number) {
            return (Number)value;
        }
        if (value instanceof String) {
            String stringValue = (String)value;
            try {
                return Long.valueOf(stringValue);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    return Double.valueOf(stringValue);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private boolean trySetSchemaType(Schema schema, QName typeName) {
        if (typeName == null) {
            return false;
        }
        if (typeName.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
            String name = typeName.getLocalPart();
            if (name.equals(SIMPLE_TYPE_STRING) || name.equals(SIMPLE_TYPE_BOOLEAN)) {
                schema.setType(name);
                return true;
            }
            if (name.equals(SIMPLE_TYPE_TOKEN) || name.equals(SIMPLE_TYPE_NORMALIZEDSTRING) || name.equals(SIMPLE_TYPE_LANGUAGE)) {
                schema.setType(JSON_TYPE_STRING);
                schema.setDescription(name);
                return true;
            }
            if (name.equals(SIMPLE_TYPE_INTEGER) || name.equals(SIMPLE_TYPE_INT)) {
                schema.setType(JSON_TYPE_INTEGER);
                schema.setFormat(JSON_FORMAT_INT32);
                return true;
            }
            if (name.equals(SIMPLE_TYPE_LONG)) {
                schema.setType(JSON_TYPE_INTEGER);
                schema.setFormat(JSON_FORMAT_INT64);
                return true;
            }
            if (name.equals(SIMPLE_TYPE_BYTE)) {
                schema.setType(JSON_TYPE_INTEGER);
                schema.setFormat(JSON_FORMAT_BYTE);
                return true;
            }
            if (name.equals(SIMPLE_TYPE_POSITIVEINTEGER)) {
                schema.setType(JSON_TYPE_INTEGER);
                schema.setMinimum((Number)0);
                schema.setExclusiveMinimum(true);
                return true;
            }
            if (name.equals(SIMPLE_TYPE_NEGATIVEINTEGER)) {
                schema.setType(JSON_TYPE_INTEGER);
                schema.setMaximum((Number)0);
                schema.setExclusiveMinimum(true);
                return true;
            }
            if (name.equals(SIMPLE_TYPE_NONNEGATIVEINTEGER)) {
                schema.setType(JSON_TYPE_INTEGER);
                schema.setMinimum((Number)0);
                schema.setExclusiveMinimum(false);
                return true;
            }
            if (name.equals(SIMPLE_TYPE_NONPOSITIVEINTEGER)) {
                schema.setType(JSON_TYPE_INTEGER);
                schema.setMaximum((Number)0);
                schema.setExclusiveMinimum(false);
                return true;
            }
            if (name.equals(SIMPLE_TYPE_FLOAT) || name.equals(SIMPLE_TYPE_DOUBLE) || name.equals(SIMPLE_TYPE_DECIMAL)) {
                schema.setType(JSON_TYPE_NUMBER);
                schema.setFormat(name);
                return true;
            }
            if (name.equals(SIMPLE_TYPE_BASE64) || name.equals(SIMPLE_TYPE_HEXBIN)) {
                schema.setType(JSON_TYPE_STRING);
                schema.setDescription(name);
                return true;
            }
            if (name.equals(SIMPLE_TYPE_DATE)) {
                schema.setType(JSON_TYPE_STRING);
                schema.setFormat(JSON_FORMAT_DATE);
                return true;
            }
            if (name.equals(SIMPLE_TYPE_DATETIME)) {
                schema.setType(JSON_TYPE_STRING);
                schema.setFormat(JSON_FORMAT_DATETIME);
                return true;
            }
            if (name.equals(SIMPLE_TYPE_ANYURI)) {
                schema.setType(JSON_TYPE_STRING);
                schema.setDescription(name);
                return true;
            }
            if (name.equals(SIMPLE_TYPE_ANYTYPE)) {
                schema.setDescription(name);
                return true;
            }
            if (name.equals(SIMPLE_TYPE_ANYSIMPLETYPE)) {
                schema.setDescription(name);
                return true;
            }
        }
        return false;
    }

    private void notSupported(String message) {
        String errorMessage = String.format("WSDLConverter does not support the XSD structure: '%s'", message);
        LOG.error(Logger.EVENT_FAILURE, errorMessage);
    }

    public static void main(String[] args) {
        String inputFile = null;
        String outputFile = null;
        PrintStream outStream = System.out;
        boolean argsOK = true;
        if (args.length > 0 && !new File(inputFile = args[0]).exists()) {
            argsOK = false;
        }
        if (argsOK && args.length > 1) {
            outputFile = args[1];
            try {
                outStream = new PrintStream(outputFile);
            }
            catch (FileNotFoundException e) {
                argsOK = false;
            }
        }
        if (args.length == 0 || !argsOK) {
            System.err.println("Usage: java com.infor.erpln.rest.apidoc.WSDLConverter WSDLfile [JSONfile]\n");
            System.err.println("  WSDLfile = path to WSDL to be converted");
            System.err.println("  JSONfile = (optional) output file for conversion result");
            System.exit(1);
        }
        try {
            byte[] bytes = Files.readAllBytes(java.nio.file.Paths.get(inputFile, new String[0]));
            String wsdlString = new String(bytes, StandardCharsets.UTF_8);
            WSDLConverter converter = new WSDLConverter(wsdlString);
            Specification specification = converter.convert();
            outStream.println(specification.toJSONString());
            outStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        try {
            wsdlFactory = WSDLFactory.newInstance();
        }
        catch (WSDLException e) {
            LOG.error(Logger.EVENT_FAILURE, "Error when creating WSDLFactory", (Throwable)e);
        }
        try {
            transformerFactory = XMLUtil.getSecureTransformerFactory();
        }
        catch (TransformerFactoryConfigurationError e) {
            LOG.error(Logger.EVENT_FAILURE, "Error when creating TransformerFactory", (Throwable)e);
        }
        GENERIC_BDE_TYPE_DEFINITIONS.put("FilterType", "{\"description\":\"Filter for limiting the amount of returned data\n\nSupply either a **LogicalExpression** or a **ComparisonExpression**\",\"properties\":{\"LogicalExpression\":{\"$ref\":\"#/definitions/LogicalExpressionType\"},\"ComparisonExpression\":{\"$ref\":\"#/definitions/ComparisonExpressionType\"}}}");
        GENERIC_BDE_TYPE_DEFINITIONS.put("LogicalExpressionType", "{\"description\":\"Combines two expressions using the 'and' or 'or' operator. The order of the properties in the JSON object is important: first the 'logicalOperator', next the left and right expression. If both expressions are of the same type, they need to be supplied in an array.\",\"properties\":{\"logicalOperator\":{\"type\":\"string\",\"enum\":[\"and\",\"or\"]},\"LogicalExpression\":{\"type\":\"array\",\"items\":{\"$ref\":\"#/definitions/LogicalExpressionType\"}},\"ComparisonExpression\":{\"type\":\"array\",\"items\":{\"$ref\":\"#/definitions/ComparisonExpressionType\"}}}}");
        GENERIC_BDE_TYPE_DEFINITIONS.put("ComparisonExpressionType", "{\"description\":\"Expression for comparing an attribute value to another attribute value, or to a fixed value, or to an empty value. The order of the properties in the JSON object is important: first the 'comparisonOperator', next the 'attributeName' to be tested, finally the 'attributeName' or 'instanceValue' or 'emptyValue' to be tested against. When comparing an attribute to another attribute, both 'attributeName' values need to be supplied in an array.\",\"properties\":{\"comparisonOperator\":{\"type\":\"string\",\"enum\":[\"le\",\"lt\",\"ge\",\"gt\",\"ne\",\"eq\",\"like\"]},\"attributeName\":{\"type\":\"array\",\"items\":{\"$ref\":\"#/definitions/filterAttributeListDT\"}},\"emptyValue\":{\"type\":\"null\"},\"instanceValue\":{\"type\":\"string\"}}}");
        GENERIC_BDE_TYPE_DEFINITIONS.put("InformationMessage", "{\"properties\":{\"@ID\":{\"type\":\"string\", \"description\":\"Required 'ID' of the message\"},\"messageIndex\":{\"type\":\"integer\"},\"messageType\":{\"type\":\"string\",\"enum\":[\"Error\",\"Warning\",\"Information\"]},\"messageText\":{\"type\":\"string\"},\"messageSource\":{\"type\":\"string\"},\"MessageDetails\":{\"type\":\"array\",\"items\":{\"$ref\":\"#/definitions/DetailMessage\"}},\"messageCorrectiveAction\":{\"type\":\"string\"},\"messageAdditionalHelpText\":{\"type\":\"string\"},\"messageAdditionalHelpURI\":{\"type\":\"string\"},\"MessageReference\":{\"properties\":{\"messageReferenceType\":{\"type\":\"string\"},\"messageReferenceInfo\":{\"description\":\"Object matching the 'messageReferenceType'\"}}}},\"required\":[\"@ID\"]}");
        GENERIC_BDE_TYPE_DEFINITIONS.put("DetailMessage", "{\"properties\":{\"@ID\":{\"type\":\"string\", \"description\":\"Optional 'ID' of the message\"},\"messageIndex\":{\"type\":\"integer\"},\"messageType\":{\"type\":\"string\",\"enum\":[\"Error\",\"Warning\",\"Information\"]},\"messageText\":{\"type\":\"string\"},\"messageSource\":{\"type\":\"string\"},\"MessageDetails\":{\"type\":\"array\",\"items\":{\"$ref\":\"#/definitions/DetailMessage\"}},\"messageCorrectiveAction\":{\"type\":\"string\"},\"messageAdditionalHelpText\":{\"type\":\"string\"},\"messageAdditionalHelpURI\":{\"type\":\"string\"},\"MessageReference\":{\"properties\":{\"messageReferenceType\":{\"type\":\"string\"},\"messageReferenceInfo\":{\"description\":\"Object matching the 'messageReferenceType'\"}}}}}");
        SIMPLE_TYPE_ANYSIMPLETYPE = Constants.XSD_ANYSIMPLETYPE.getLocalPart();
        SIMPLE_TYPE_ANYTYPE = Constants.XSD_ANYTYPE.getLocalPart();
        SIMPLE_TYPE_ANYURI = Constants.XSD_ANYURI.getLocalPart();
        SIMPLE_TYPE_BASE64 = Constants.XSD_BASE64.getLocalPart();
        SIMPLE_TYPE_BOOLEAN = Constants.XSD_BOOLEAN.getLocalPart();
        SIMPLE_TYPE_BYTE = Constants.XSD_BYTE.getLocalPart();
        SIMPLE_TYPE_DATE = Constants.XSD_DATE.getLocalPart();
        SIMPLE_TYPE_DATETIME = Constants.XSD_DATETIME.getLocalPart();
        SIMPLE_TYPE_DECIMAL = Constants.XSD_DECIMAL.getLocalPart();
        SIMPLE_TYPE_DOUBLE = Constants.XSD_DOUBLE.getLocalPart();
        SIMPLE_TYPE_FLOAT = Constants.XSD_FLOAT.getLocalPart();
        SIMPLE_TYPE_HEXBIN = Constants.XSD_HEXBIN.getLocalPart();
        SIMPLE_TYPE_INT = Constants.XSD_INT.getLocalPart();
        SIMPLE_TYPE_INTEGER = Constants.XSD_INTEGER.getLocalPart();
        SIMPLE_TYPE_LANGUAGE = Constants.XSD_LANGUAGE.getLocalPart();
        SIMPLE_TYPE_LONG = Constants.XSD_LONG.getLocalPart();
        SIMPLE_TYPE_NEGATIVEINTEGER = Constants.XSD_NEGATIVEINTEGER.getLocalPart();
        SIMPLE_TYPE_NONNEGATIVEINTEGER = Constants.XSD_NONNEGATIVEINTEGER.getLocalPart();
        SIMPLE_TYPE_NONPOSITIVEINTEGER = Constants.XSD_NONPOSITIVEINTEGER.getLocalPart();
        SIMPLE_TYPE_NORMALIZEDSTRING = Constants.XSD_NORMALIZEDSTRING.getLocalPart();
        SIMPLE_TYPE_POSITIVEINTEGER = Constants.XSD_POSITIVEINTEGER.getLocalPart();
        SIMPLE_TYPE_STRING = Constants.XSD_STRING.getLocalPart();
        SIMPLE_TYPE_TOKEN = Constants.XSD_TOKEN.getLocalPart();
    }
}

